/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.base.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.api.IQuarkButtonAllowed;
import org.violetmoon.quark.api.ITransferManager;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.config.QuarkGeneralConfig;
import org.violetmoon.quark.content.management.module.EasyTransferringModule;

public class InventoryTransferHandler {
    public static void transfer(Player player, boolean isRestock, boolean smart) {
        if (!Quark.ZETA.modules.isEnabled(EasyTransferringModule.class) || player.isSpectator() || !InventoryTransferHandler.accepts(player.containerMenu, player)) {
            return;
        }
        Transfer transfer = isRestock ? new Restock(player, smart) : new Transfer(player, smart);
        transfer.execute();
    }

    private static boolean hasProvider(Object te) {
        return false;
    }

    private static ITransferManager getProvider(Object te) {
        return null;
    }

    public static boolean accepts(AbstractContainerMenu container, Player player) {
        if (container instanceof CraftingMenu || player.level().isClientSide() && container instanceof CreativeModeInventoryScreen.ItemPickerMenu) {
            return false;
        }
        if (InventoryTransferHandler.hasProvider(container)) {
            return InventoryTransferHandler.getProvider(container).acceptsTransfer(player);
        }
        return container instanceof IQuarkButtonAllowed || container.slots.size() - player.getInventory().items.size() >= QuarkGeneralConfig.chestButtonSlotTarget;
    }

    public static class Restock
    extends Transfer {
        public Restock(Player player, boolean filtered) {
            super(player, filtered);
        }

        @Override
        public void transfer(TransferPredicate predicate) {
            IItemHandler inv = (IItemHandler)((Pair)this.itemHandlers.getFirst()).getLeft();
            PlayerInvWrapper playerInv = new PlayerInvWrapper((Container)this.player.getInventory());
            for (int i = inv.getSlots() - 1; i >= 0; --i) {
                ItemStack copy;
                ItemStack ret;
                ItemStack stackAt = inv.extractItem(i, inv.getStackInSlot(i).getCount(), true);
                if (stackAt.isEmpty() || ItemStack.matches((ItemStack)stackAt, (ItemStack)(ret = this.insertInHandler((IItemHandler)playerInv, copy = stackAt.copy(), predicate)))) continue;
                inv.extractItem(i, stackAt.getCount() - ret.getCount(), false);
            }
        }
    }

    public static class Transfer {
        public final Player player;
        public final boolean smart;
        public final List<Pair<IItemHandler, Double>> itemHandlers = new ArrayList<Pair<IItemHandler, Double>>();

        public Transfer(Player player, boolean smart) {
            this.player = player;
            this.smart = smart;
        }

        public void execute() {
            this.locateItemHandlers();
            if (this.itemHandlers.isEmpty()) {
                return;
            }
            if (this.smart) {
                this.smartTransfer();
            } else {
                this.roughTransfer();
            }
            this.player.inventoryMenu.broadcastChanges();
            this.player.containerMenu.broadcastChanges();
        }

        public void smartTransfer() {
            this.transfer((stack, handler) -> {
                int slots = handler.getSlots();
                for (int i = 0; i < slots; ++i) {
                    ItemStack stackAt = handler.getStackInSlot(i);
                    if (stackAt.isEmpty()) continue;
                    boolean itemEqual = stack.getItem() == stackAt.getItem();
                    boolean damageEqual = stack.getDamageValue() == stackAt.getDamageValue();
                    boolean nbtEqual = ItemStack.isSameItemSameComponents((ItemStack)stackAt, (ItemStack)stack);
                    if (itemEqual && damageEqual && nbtEqual) {
                        return true;
                    }
                    if (!stack.isDamageableItem() || stack.getMaxStackSize() != 1 || !itemEqual || !nbtEqual) continue;
                    return true;
                }
                return false;
            });
        }

        public void roughTransfer() {
            this.transfer((stack, handler) -> true);
        }

        public void locateItemHandlers() {
            AbstractContainerMenu c = this.player.containerMenu;
            for (Slot s : c.slots) {
                Container inv = s.container;
                if (inv == this.player.getInventory()) continue;
                this.itemHandlers.add((Pair<IItemHandler, Double>)Pair.of((Object)ContainerWrapper.provideWrapper(s, c), (Object)0.0));
                break;
            }
        }

        public void transfer(TransferPredicate predicate) {
            Inventory inv = this.player.getInventory();
            for (int i = Inventory.getSelectionSize(); i < inv.items.size(); ++i) {
                ItemStack ret;
                ItemStack stackAt = inv.getItem(i);
                if (stackAt.isEmpty() || ItemStack.matches((ItemStack)stackAt, (ItemStack)(ret = this.insert(stackAt, predicate)))) continue;
                inv.setItem(i, ret);
            }
        }

        public ItemStack insert(ItemStack stack, TransferPredicate predicate) {
            ItemStack ret = stack.copy();
            for (Pair<IItemHandler, Double> pair : this.itemHandlers) {
                IItemHandler handler = (IItemHandler)pair.getLeft();
                ret = this.insertInHandler(handler, ret, predicate);
                if (!ret.isEmpty()) continue;
                return ItemStack.EMPTY;
            }
            return ret;
        }

        public ItemStack insertInHandler(IItemHandler handler, ItemStack stack, TransferPredicate predicate) {
            if (predicate.test(stack, handler)) {
                ItemStack retStack = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack, (boolean)false);
                if (retStack.isEmpty()) {
                    return retStack;
                }
                retStack = retStack.copy();
                return retStack;
            }
            return stack;
        }
    }

    public static interface TransferPredicate
    extends BiPredicate<ItemStack, IItemHandler> {
    }

    public static class ContainerWrapper
    extends InvWrapper {
        private final AbstractContainerMenu container;

        public static IItemHandler provideWrapper(Slot slot, AbstractContainerMenu container) {
            if (slot instanceof SlotItemHandler) {
                SlotItemHandler slotItemHandler = (SlotItemHandler)slot;
                IItemHandler handler = slotItemHandler.getItemHandler();
                if (InventoryTransferHandler.hasProvider(handler)) {
                    return InventoryTransferHandler.getProvider(handler).getTransferItemHandler(() -> handler);
                }
                return handler;
            }
            return ContainerWrapper.provideWrapper(slot.container, container);
        }

        public static IItemHandler provideWrapper(Container inv, AbstractContainerMenu container) {
            if (InventoryTransferHandler.hasProvider(inv)) {
                return InventoryTransferHandler.getProvider(inv).getTransferItemHandler(() -> new ContainerWrapper(inv, container));
            }
            return new ContainerWrapper(inv, container);
        }

        private ContainerWrapper(Container inv, AbstractContainerMenu container) {
            super(inv);
            this.container = container;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            Slot containerSlot = this.getSlot(slot);
            if (containerSlot == null || !containerSlot.mayPlace(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        private Slot getSlot(int slotId) {
            Container inv = this.getInv();
            for (Slot slot : this.container.slots) {
                if (slot.container != inv || slot.getSlotIndex() != slotId) continue;
                return slot;
            }
            return null;
        }
    }

    public static class PlayerInvWrapper
    extends InvWrapper {
        public PlayerInvWrapper(Container inv) {
            super(inv);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (stack.isEmpty()) {
                stack = stack.copy();
            }
            return super.insertItem(slot, stack, simulate);
        }

        public int getSlots() {
            return super.getSlots() - 5;
        }
    }
}

