/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.tools.module.AncientTomesModule;

public class EnchantTome
extends LootItemConditionalFunction {
    public static final MapCodec<EnchantTome> CODEC = RecordCodecBuilder.mapCodec(instance -> EnchantTome.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, EnchantTome::new));

    public EnchantTome(List<LootItemCondition> conditions) {
        super(conditions);
    }

    @NotNull
    public LootItemFunctionType<EnchantTome> getType() {
        return AncientTomesModule.tomeEnchantType;
    }

    @NotNull
    public ItemStack run(@NotNull ItemStack stack, LootContext context) {
        Holder<Enchantment> enchantment = AncientTomesModule.validEnchants.get(context.getRandom().nextInt(AncientTomesModule.validEnchants.size()));
        return EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(enchantment, ((Enchantment)enchantment.value()).getMaxLevel()));
    }
}

