/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.block.be;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.addons.oddities.module.TinyPotatoModule;
import org.violetmoon.quark.addons.oddities.util.TinyPotatoInfo;
import org.violetmoon.quark.base.handler.QuarkSounds;
import org.violetmoon.zeta.util.MiscUtil;
import org.violetmoon.zeta.util.SimpleInventoryBlockEntity;

public class TinyPotatoBlockEntity
extends SimpleInventoryBlockEntity
implements Nameable {
    public static final String TAG_NAME = "name";
    public static final String TAG_ANGRY = "angery";
    private static final int JUMP_EVENT = 0;
    public int jumpTicks = 0;
    public Component name = Component.literal((String)"");
    private int soundCd = 0;
    public boolean angry = false;
    public boolean isActuallyAnItem = false;
    private static final Map<String, String> GENDER = new HashMap<String, String>();
    private static final Map<String, SoundEvent> SOUNDS = new HashMap<String, SoundEvent>();

    public TinyPotatoBlockEntity(BlockPos pos, BlockState state) {
        super(TinyPotatoModule.blockEntityType, pos, state);
    }

    public void interact(Player player, InteractionHand hand, ItemStack stack, Direction side) {
        int index = side.get3DDataValue();
        if (index >= 0) {
            ItemStack stackAt = this.getItem(index);
            if (!stackAt.isEmpty() && stack.isEmpty()) {
                player.setItemInHand(hand, stackAt);
                this.setItem(index, ItemStack.EMPTY);
            } else if (!stack.isEmpty()) {
                ItemStack copy = stack.split(1);
                if (stack.isEmpty()) {
                    player.setItemInHand(hand, stackAt);
                } else if (!stackAt.isEmpty()) {
                    player.getInventory().placeItemBackInInventory(stackAt);
                }
                this.setItem(index, copy);
            }
        }
        if (this.level != null && !this.level.isClientSide) {
            TinyPotatoInfo info;
            String checkName;
            this.jump();
            if (this.hasCustomName() && SOUNDS.containsKey(checkName = (info = TinyPotatoInfo.fromComponent(this.name)).name().toLowerCase(Locale.ROOT).trim()) && this.soundCd == 0) {
                SoundEvent playSound = SOUNDS.get(checkName);
                this.soundCd = 20;
                this.level.playSound(null, this.worldPosition, playSound, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            ItemStack tater = ItemStack.EMPTY;
            boolean manyTater = false;
            for (int i = 0; i < this.getContainerSize(); ++i) {
                ItemStack stackAt = this.getItem(i);
                if (stackAt.isEmpty() || !stackAt.is(TinyPotatoModule.tiny_potato.asItem())) continue;
                if (tater.isEmpty()) {
                    tater = stackAt;
                    continue;
                }
                manyTater = true;
                break;
            }
            if (!tater.isEmpty()) {
                String taterGender;
                String string = taterGender = manyTater ? "children" : "son";
                if (tater.getComponents().has(DataComponents.CUSTOM_NAME) && !manyTater) {
                    TinyPotatoInfo info2 = TinyPotatoInfo.fromComponent(tater.getHoverName());
                    taterGender = GENDER.getOrDefault(info2.name(), taterGender);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.sendSystemMessage((Component)Component.translatable((String)("quark.misc.my_" + taterGender)), true);
                }
            }
        }
    }

    private void jump() {
        if (this.level != null && this.jumpTicks == 0) {
            this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 0, 20);
        }
    }

    public boolean triggerEvent(int id, int param) {
        if (id == 0) {
            this.jumpTicks = param;
            return true;
        }
        return super.triggerEvent(id, param);
    }

    public static void commonTick(Level level, BlockPos pos, BlockState state, TinyPotatoBlockEntity self) {
        if (self.jumpTicks > 0) {
            --self.jumpTicks;
        }
        if (!level.isClientSide) {
            if (level.random.nextInt(100) == 0) {
                self.jump();
            }
            if (self.soundCd > 0) {
                --self.soundCd;
            }
        }
    }

    public void inventoryChanged(int i) {
        this.sync();
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.sync();
        }
    }

    public void sync() {
        MiscUtil.syncTE((BlockEntity)this);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void readSharedNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.readSharedNBT(tag, provider);
        this.name = Component.Serializer.fromJson((String)tag.getString(TAG_NAME), (HolderLookup.Provider)provider);
        this.angry = tag.getBoolean(TAG_ANGRY);
    }

    public void writeSharedNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeSharedNBT(tag, provider);
        tag.putString(TAG_NAME, Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)provider));
        tag.putBoolean(TAG_ANGRY, this.angry);
    }

    public int getContainerSize() {
        return 6;
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean canPlaceItem(int slot, @NotNull ItemStack itemstack) {
        return this.getItem(slot).isEmpty();
    }

    public void startOpen(@NotNull Player player) {
    }

    public void stopOpen(@NotNull Player player) {
    }

    @NotNull
    public Component getName() {
        return Component.translatable((String)TinyPotatoModule.tiny_potato.getDescriptionId());
    }

    @Nullable
    public Component getCustomName() {
        return this.name.getString().isEmpty() ? null : this.name;
    }

    @NotNull
    public Component getDisplayName() {
        Component customName;
        if (this.hasCustomName() && (customName = this.getCustomName()) != null) {
            return customName;
        }
        return this.getName();
    }

    static {
        GENDER.put("girlstater", "daughter");
        GENDER.put("lesbiabtater", "daughter");
        GENDER.put("lesbiamtater", "daughter");
        GENDER.put("lesbiantater", "daughter");
        GENDER.put("lesbitater", "daughter");
        GENDER.put("lessbientater", "daughter");
        GENDER.put("agendertater", "child");
        GENDER.put("enbytater", "child");
        GENDER.put("nbtater", "child");
        GENDER.put("nonbinarytater", "child");
        GENDER.put("robotater", "child");
        GENDER.put("wiretater", "child");
        GENDER.put("eutrotater", "child");
        GENDER.put("bob", "child");
        GENDER.put("snences", "child");
        GENDER.put("genderfluidtater", "child");
        GENDER.put("taterfluid", "child");
        GENDER.put("eggtater", "child");
        GENDER.put("tategg", "child");
        GENDER.put("transtater", "child");
        GENDER.put("manytater", "children");
        GENDER.put("pluraltater", "children");
        GENDER.put("snorps", "children");
        GENDER.put("systater", "children");
        GENDER.put("systemtater", "children");
        GENDER.put("tomater", "tomato");
        SOUNDS.put("shia labeouf", QuarkSounds.BLOCK_POTATO_DO_IT);
        SOUNDS.put("joe biden", QuarkSounds.BLOCK_POTATO_SODA);
        SOUNDS.put("yungnickyoung", QuarkSounds.BLOCK_POTATO_YUNG);
    }
}

