/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.entity;

import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.violetmoon.quark.base.handler.QuarkSounds;

public class SoulBead
extends Entity {
    private static final EntityDataAccessor<Integer> LIFE_TICKS = SynchedEntityData.defineId(SoulBead.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TARGET_X = SynchedEntityData.defineId(SoulBead.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TARGET_Z = SynchedEntityData.defineId(SoulBead.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final String TAG_LIFE_TICKS = "lifeTicks";
    private static final String TAG_TARGET_X = "targetX";
    private static final String TAG_TARGET_Z = "targetZ";

    public SoulBead(EntityType<? extends SoulBead> type, Level worldIn) {
        super(type, worldIn);
    }

    public void setTarget(int x, int z) {
        this.entityData.set(LIFE_TICKS, (Object)0);
        this.entityData.set(TARGET_X, (Object)x);
        this.entityData.set(TARGET_Z, (Object)z);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(LIFE_TICKS, (Object)0);
        builder.define(TARGET_X, (Object)0);
        builder.define(TARGET_Z, (Object)0);
    }

    public void tick() {
        super.tick();
        int liveTicks = (Integer)this.entityData.get(LIFE_TICKS);
        double posSpread = 0.4;
        double scale = 0.08;
        double rotateSpread = 1.5;
        double rise = 0.025;
        int maxLiveTime = 6000;
        int particles = 20;
        double trigArg = (double)liveTicks * 0.32;
        if (maxLiveTime - liveTicks < particles) {
            particles = maxLiveTime - liveTicks;
        }
        double posX = this.getX();
        double posY = this.getY();
        double posZ = this.getZ();
        Vec3 vec = new Vec3((double)((Integer)this.entityData.get(TARGET_X)).intValue(), posY, (double)((Integer)this.entityData.get(TARGET_Z)).intValue()).subtract(posX, posY, posZ).normalize().scale(scale);
        double bpx = posX + vec.x * (double)liveTicks + Math.cos(trigArg) * rotateSpread;
        double bpy = posY + vec.y * (double)liveTicks + (double)liveTicks * rise;
        double bpz = posZ + vec.z * (double)liveTicks + Math.sin(trigArg) * rotateSpread;
        for (int i = 0; i < particles; ++i) {
            double px = bpx + (Math.random() - 0.5) * posSpread;
            double py = bpy + (Math.random() - 0.5) * posSpread;
            double pz = bpz + (Math.random() - 0.5) * posSpread;
            this.level().addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(0.2f, 0.12f, 0.1f), 1.0f), px, py, pz, 0.0, 0.0, 0.0);
            if (!(Math.random() < 0.05)) continue;
            this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, Blocks.SOUL_SAND.defaultBlockState()), px, py, pz, 0.0, 0.0, 0.0);
        }
        if (Math.random() < 0.1) {
            this.level().playSound(null, bpx, bpy, bpz, QuarkSounds.ENTITY_SOUL_BEAD_IDLE, SoundSource.PLAYERS, 0.2f, 1.0f);
        }
        if (++liveTicks > maxLiveTime) {
            this.removeAfterChangingDimensions();
        } else {
            this.entityData.set(LIFE_TICKS, (Object)liveTicks);
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        compound.putInt(TAG_TARGET_X, ((Integer)this.entityData.get(TARGET_X)).intValue());
        compound.putInt(TAG_TARGET_Z, ((Integer)this.entityData.get(TARGET_Z)).intValue());
        compound.putInt(TAG_LIFE_TICKS, ((Integer)this.entityData.get(LIFE_TICKS)).intValue());
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
        this.entityData.set(TARGET_X, (Object)compound.getInt(TAG_TARGET_X));
        this.entityData.set(TARGET_Z, (Object)compound.getInt(TAG_TARGET_Z));
        this.entityData.set(LIFE_TICKS, (Object)compound.getInt(TAG_LIFE_TICKS));
    }
}

