/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.base.handler;

import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class ProxiedItemStackHandler
implements IItemHandler,
IItemHandlerModifiable {
    protected final ItemStack stack;
    protected final String key;
    protected final int size;

    public ProxiedItemStackHandler(ItemStack stack) {
        this(stack, "Inventory", 1);
    }

    public ProxiedItemStackHandler(ItemStack stack, String key) {
        this(stack, key, 1);
    }

    public ProxiedItemStackHandler(ItemStack stack, int size) {
        this(stack, "Inventory", size);
    }

    public ProxiedItemStackHandler(ItemStack stack, String key, int size) {
        this.stack = stack;
        this.key = key;
        this.size = size;
    }

    private void writeStack(int index, @NotNull ItemStack stack) {
        this.onContentsChanged(index);
    }

    private ItemStack readStack(int index) {
        return ItemStack.EMPTY;
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.validateSlotIndex(slot);
        this.writeStack(slot, stack);
        this.onContentsChanged(slot);
    }

    public int getSlots() {
        return this.size;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return this.readStack(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.readStack(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.isEmpty()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.getCount();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.getCount() > limit;
        if (!simulate) {
            this.writeStack(slot, reachedLimit ? stack.copyWithCount(limit) : stack);
        }
        return reachedLimit ? stack.copyWithCount(stack.getCount() - limit) : ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.readStack(slot);
        if (existing.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(amount, existing.getMaxStackSize());
        if (existing.getCount() <= toExtract) {
            if (!simulate) {
                this.writeStack(slot, ItemStack.EMPTY);
            }
            return existing;
        }
        if (!simulate) {
            this.writeStack(slot, this.stack.copyWithCount(existing.getCount() - toExtract));
        }
        return existing.copyWithCount(toExtract);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    protected int getStackLimit(int slot, @NotNull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.getMaxStackSize());
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return true;
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.size) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.size + ")");
        }
    }

    protected void onContentsChanged(int slot) {
    }
}

