/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.entity;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.addons.oddities.item.BackpackItem;
import org.violetmoon.quark.addons.oddities.module.TotemOfHoldingModule;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.tweaks.compat.TotemOfHoldingCuriosCompat;

public class TotemOfHoldingEntity
extends Entity {
    private static final String TAG_ITEMS = "storedItems";
    private static final String TAG_CURIOS = "curiosList";
    private static final String TAG_DYING = "dying";
    private static final String TAG_OWNER = "owner";
    private static final EntityDataAccessor<Boolean> DYING = SynchedEntityData.defineId(TotemOfHoldingEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final int DEATH_TIME = 40;
    private int deathTicks = 0;
    private String owner;
    private List<ItemStack> storedItems = new LinkedList<ItemStack>();
    private List<ItemStack> equipedCurios = new LinkedList<ItemStack>();

    public TotemOfHoldingEntity(EntityType<? extends TotemOfHoldingEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DYING, (Object)false);
    }

    public void addItem(ItemStack stack) {
        this.storedItems.add(stack);
    }

    public void addCurios(ItemStack stack) {
        this.equipedCurios.add(stack);
    }

    public void setOwner(Player player) {
        this.owner = player.getUUID().toString();
    }

    private Player getOwnerEntity() {
        for (Player player : this.level().players()) {
            String uuid = player.getUUID().toString();
            if (!uuid.equals(this.owner)) continue;
            return player;
        }
        return null;
    }

    public boolean skipAttackInteraction(@NotNull Entity entity) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!TotemOfHoldingModule.allowAnyoneToCollect && !player.hasInfiniteMaterials() && entity != this.getOwnerEntity()) {
                    return false;
                }
                int drops = Math.min(this.storedItems.size(), 3 + this.level().random.nextInt(4));
                for (int i = 0; i < drops; ++i) {
                    ItemStack stack = this.storedItems.removeFirst();
                    Item item = stack.getItem();
                    if (item instanceof ArmorItem) {
                        ArmorItem armor = (ArmorItem)item;
                        EquipmentSlot slot = armor.getEquipmentSlot();
                        ItemStack curr = player.getItemBySlot(slot);
                        if (curr.isEmpty()) {
                            player.setItemSlot(slot, stack);
                            stack = null;
                        } else if (!(curr.getItem() instanceof BackpackItem) && EnchantmentHelper.getTagEnchantmentLevel((Holder)serverLevel.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.BINDING_CURSE), (ItemStack)curr) <= 0 && EnchantmentHelper.getTagEnchantmentLevel((Holder)serverLevel.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.BINDING_CURSE), (ItemStack)stack) > 0) {
                            player.setItemSlot(slot, stack);
                            stack = curr;
                        }
                    } else if (stack.getItem() instanceof ShieldItem) {
                        ItemStack curr = player.getItemBySlot(EquipmentSlot.OFFHAND);
                        if (curr.isEmpty()) {
                            player.setItemSlot(EquipmentSlot.OFFHAND, stack);
                            stack = null;
                        }
                    } else if (Quark.ZETA.isModLoaded("curios")) {
                        stack = TotemOfHoldingCuriosCompat.equipCurios(player, this.equipedCurios, stack);
                    }
                    if (stack == null || player.addItem(stack)) continue;
                    this.spawnAtLocation(stack, 0.0f);
                }
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, this.getX(), this.getY() + 0.5, this.getZ(), drops, 0.1, 0.5, 0.1, 0.0);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.ENCHANTED_HIT, this.getX(), this.getY() + 0.5, this.getZ(), drops, 0.4, 0.5, 0.4, 0.0);
            }
        }
        return false;
    }

    public boolean isPickable() {
        return true;
    }

    public void tick() {
        Player owner;
        super.tick();
        if (!this.isAlive()) {
            return;
        }
        if (TotemOfHoldingModule.darkSoulsMode && (owner = this.getOwnerEntity()) != null && !this.level().isClientSide) {
            String ownerTotem = TotemOfHoldingModule.getTotemUUID(owner);
            if (!this.getUUID().toString().equals(ownerTotem)) {
                this.dropEverythingAndDie();
            }
        }
        if (this.storedItems.isEmpty() && !this.level().isClientSide) {
            this.entityData.set(DYING, (Object)true);
        }
        if (this.isDying()) {
            if (this.deathTicks > 40) {
                this.discard();
            } else {
                ++this.deathTicks;
            }
        } else if (this.level().isClientSide) {
            this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getX(), this.getY() + (this.random.nextDouble() - 0.5) * 0.2, this.getZ(), Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5);
        }
    }

    private void dropEverythingAndDie() {
        if (!TotemOfHoldingModule.destroyLostItems) {
            for (ItemStack storedItem : this.storedItems) {
                this.spawnAtLocation(storedItem, 0.0f);
            }
        }
        this.storedItems.clear();
        this.equipedCurios.clear();
        Player owner = this.getOwnerEntity();
        if (owner != null && !this.level().isClientSide) {
            owner.sendSystemMessage((Component)Component.translatable((String)"quark.misc.totem_darksouls").withStyle(ChatFormatting.BOLD));
        }
        this.discard();
    }

    public int getDeathTicks() {
        return this.deathTicks;
    }

    public boolean isDying() {
        return (Boolean)this.entityData.get(DYING);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        ItemStack stack;
        CompoundTag cmp;
        int i;
        ListTag list = compound.getList(TAG_ITEMS, 10);
        ListTag curiosList = compound.getList(TAG_CURIOS, 10);
        this.storedItems = new LinkedList<ItemStack>();
        this.equipedCurios = new LinkedList<ItemStack>();
        for (i = 0; i < list.size(); ++i) {
            cmp = list.getCompound(i);
            stack = ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)cmp);
            this.storedItems.add(stack);
        }
        for (i = 0; i < curiosList.size(); ++i) {
            cmp = curiosList.getCompound(i);
            stack = ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)cmp);
            this.equipedCurios.add(stack);
        }
        boolean dying = compound.getBoolean(TAG_DYING);
        this.entityData.set(DYING, (Object)dying);
        this.owner = compound.getString(TAG_OWNER);
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
        ListTag list = new ListTag();
        ListTag curiosList = new ListTag();
        for (ItemStack stack : this.storedItems) {
            list.add((Object)stack.save((HolderLookup.Provider)this.level().registryAccess()));
        }
        for (ItemStack equipedCurio : this.equipedCurios) {
            curiosList.add((Object)equipedCurio.save((HolderLookup.Provider)this.level().registryAccess()));
        }
        compound.put(TAG_ITEMS, (Tag)list);
        compound.put(TAG_CURIOS, (Tag)curiosList);
        compound.putBoolean(TAG_DYING, this.isDying());
        if (this.owner != null) {
            compound.putString(TAG_OWNER, this.owner);
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, entity);
    }
}

