/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.integration.lootr;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import noobanidus.mods.lootr.common.api.LootrTags;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.block.entity.LootrChestBlockEntity;
import noobanidus.mods.lootr.neoforge.config.ConfigManager;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.content.building.block.VariantChestBlock;
import org.violetmoon.quark.integration.lootr.LootrVariantChestBlockEntity;
import org.violetmoon.zeta.item.ZetaBlockItem;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.IZetaBlockItemProvider;

public class LootrVariantChestBlock
extends VariantChestBlock
implements IZetaBlockItemProvider {
    public LootrVariantChestBlock(String type, ZetaModule module, Supplier<BlockEntityType<? extends ChestBlockEntity>> supplier, BlockBehaviour.Properties properties) {
        super("lootr", type, module, supplier, properties.strength(2.5f));
    }

    public float getExplosionResistance() {
        if (((Boolean)ConfigManager.BLAST_IMMUNE.get()).booleanValue()) {
            return Float.MAX_VALUE;
        }
        if (((Boolean)ConfigManager.BLAST_RESISTANT.get()).booleanValue()) {
            return 16.0f;
        }
        return super.getExplosionResistance();
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult trace) {
        if (player.isShiftKeyDown() || !ChestBlock.isChestBlockedAt((LevelAccessor)world, (BlockPos)pos)) {
            // empty if block
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new LootrVariantChestBlockEntity(pos, state);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return stateIn;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection().getOpposite();
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)TYPE, (Comparable)ChestType.SINGLE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        return null;
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        if (((Boolean)ConfigManager.POWER_COMPARATORS.get()).booleanValue()) {
            return 1;
        }
        return 0;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return ILootrBlockEntity::ticker;
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockEntity blockentity = pLevel.getBlockEntity(pPos);
        if (blockentity instanceof LootrChestBlockEntity) {
            ((LootrChestBlockEntity)blockentity).recheckOpen();
        }
    }

    public BlockItem provideItemBlock(Block block, Item.Properties props) {
        return new Item(block, props, false);
    }

    public static class Item
    extends ZetaBlockItem {
        private final boolean trap;

        public Item(Block block, Item.Properties props, boolean trap) {
            super(block, props);
            this.trap = trap;
        }

        public InteractionResult onItemUseFirstZeta(ItemStack stack, UseOnContext context) {
            if (!context.isSecondaryUseActive()) {
                Player player = context.getPlayer();
                Level level = context.getLevel();
                BlockPos pos = context.getClickedPos();
                Block block = this.getBlock();
                if (player != null && player.isCreative()) {
                    TagKey key;
                    BlockState state = level.getBlockState(pos);
                    TagKey tagKey = key = this.trap ? LootrTags.Blocks.TRAPPED_CHESTS : LootrTags.Blocks.CHESTS;
                    if (state.is(key) && !state.is(block)) {
                        BlockEntity entity = level.getBlockEntity(pos);
                        CompoundTag nbt = entity == null ? null : entity.serializeAttachments((HolderLookup.Provider)context.getLevel().registryAccess());
                        level.setBlock(pos, block.withPropertiesOf(state), 18);
                        level.levelEvent(2001, pos, Block.getId((BlockState)state));
                        BlockEntity newEntity = level.getBlockEntity(pos);
                        if (newEntity != null && nbt != null) {
                            newEntity.loadWithComponents(nbt, (HolderLookup.Provider)level.registryAccess());
                        }
                        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                    }
                }
            }
            return super.onItemUseFirstZeta(stack, context);
        }
    }
}

