/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.UUID;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.client.handler.ModelHandler;
import org.violetmoon.quark.content.mobs.client.layer.foxhound.FoxhoundArmorLayer;
import org.violetmoon.quark.content.mobs.client.layer.foxhound.FoxhoundCollarLayer;
import org.violetmoon.quark.content.mobs.client.model.FoxhoundModel;
import org.violetmoon.quark.content.mobs.entity.Foxhound;

public class FoxhoundRenderer
extends MobRenderer<Foxhound, FoxhoundModel> {
    private static final ResourceLocation FOXHOUND_IDLE = Quark.asResource("textures/model/entity/foxhound/red/idle.png");
    private static final ResourceLocation FOXHOUND_HOSTILE = Quark.asResource("textures/model/entity/foxhound/red/hostile.png");
    private static final ResourceLocation FOXHOUND_SLEEPING = Quark.asResource("textures/model/entity/foxhound/red/sleeping.png");
    private static final ResourceLocation SOULHOUND_IDLE = Quark.asResource("textures/model/entity/foxhound/blue/idle.png");
    private static final ResourceLocation SOULHOUND_HOSTILE = Quark.asResource("textures/model/entity/foxhound/blue/hostile.png");
    private static final ResourceLocation SOULHOUND_SLEEPING = Quark.asResource("textures/model/entity/foxhound/blue/sleeping.png");
    private static final ResourceLocation BASALT_FOXHOUND_IDLE = Quark.asResource("textures/model/entity/foxhound/black/idle.png");
    private static final ResourceLocation BASALT_FOXHOUND_HOSTILE = Quark.asResource("textures/model/entity/foxhound/black/hostile.png");
    private static final ResourceLocation BASALT_FOXHOUND_SLEEPING = Quark.asResource("textures/model/entity/foxhound/black/sleeping.png");
    private static final int SHINY_CHANCE = 256;

    public FoxhoundRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)((FoxhoundModel)((Object)ModelHandler.model(ModelHandler.foxhound))), 0.5f);
        this.addLayer(new FoxhoundArmorLayer((RenderLayerParent<Foxhound, FoxhoundModel>)this, context.getModelSet()));
        this.addLayer(new FoxhoundCollarLayer((RenderLayerParent<Foxhound, FoxhoundModel>)this));
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull Foxhound entity) {
        if (entity.isBlue()) {
            return entity.isResting() ? SOULHOUND_SLEEPING : (entity.getRemainingPersistentAngerTime() > 0 ? SOULHOUND_HOSTILE : SOULHOUND_IDLE);
        }
        UUID id = entity.getUUID();
        long most = id.getMostSignificantBits();
        if (most % 256L == 0L) {
            return entity.isResting() ? BASALT_FOXHOUND_SLEEPING : (entity.getRemainingPersistentAngerTime() > 0 ? BASALT_FOXHOUND_HOSTILE : BASALT_FOXHOUND_IDLE);
        }
        return entity.isResting() ? FOXHOUND_SLEEPING : (entity.getRemainingPersistentAngerTime() > 0 ? FOXHOUND_HOSTILE : FOXHOUND_IDLE);
    }

    protected void setupRotations(Foxhound foxhound, PoseStack poseStack, float bob, float yBodyRot, float partialTick, float scale) {
        super.setupRotations((LivingEntity)foxhound, poseStack, bob, yBodyRot, partialTick, scale);
        if (foxhound.isResting()) {
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f + yBodyRot));
        }
    }

    protected float getFlipDegrees(@NotNull Foxhound foxhound) {
        return 0.0f;
    }
}

