/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.ai;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.violetmoon.quark.base.handler.QuarkSounds;
import org.violetmoon.quark.content.mobs.entity.Stoneling;

public class RunAndPoofGoal<T extends Entity>
extends Goal {
    private final Predicate<Entity> canBeSeenSelector = target -> target != null && target.isAlive() && entity.getSensing().hasLineOfSight(target) && !entity.isAlliedTo((Entity)target);
    protected Stoneling entity;
    private final double farSpeed;
    private final double nearSpeed;
    protected T closestLivingEntity;
    private final float avoidDistance;
    private Path path;
    private final PathNavigation navigation;
    private final Class<T> classToAvoid;
    private final Predicate<T> avoidTargetSelector;

    public RunAndPoofGoal(Stoneling entity, Class<T> classToAvoid, float avoidDistance, double farSpeed, double nearSpeed) {
        this(entity, classToAvoid, t -> true, avoidDistance, farSpeed, nearSpeed);
    }

    public RunAndPoofGoal(Stoneling entity, Class<T> classToAvoid, Predicate<T> avoidTargetSelector, float avoidDistance, double farSpeed, double nearSpeed) {
        this.entity = entity;
        this.classToAvoid = classToAvoid;
        this.avoidTargetSelector = avoidTargetSelector;
        this.avoidDistance = avoidDistance;
        this.farSpeed = farSpeed;
        this.nearSpeed = nearSpeed;
        this.navigation = entity.getNavigation();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        if (this.entity.isPlayerMade() || !this.entity.isStartled()) {
            return false;
        }
        List entities = this.entity.level().getEntitiesOfClass(this.classToAvoid, this.entity.getBoundingBox().inflate((double)this.avoidDistance, 3.0, (double)this.avoidDistance), entity -> EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(entity) && this.canBeSeenSelector.test((Entity)entity) && this.avoidTargetSelector.test((Entity)entity));
        if (entities.isEmpty()) {
            return false;
        }
        this.closestLivingEntity = (Entity)entities.get(0);
        Vec3 target = DefaultRandomPos.getPosAway((PathfinderMob)this.entity, (int)16, (int)7, (Vec3)this.closestLivingEntity.position());
        if (target != null && this.closestLivingEntity.distanceToSqr(target.x, target.y, target.z) < this.closestLivingEntity.distanceToSqr((Entity)this.entity)) {
            return false;
        }
        if (target != null) {
            this.path = this.navigation.createPath(target.x, target.y, target.z, 0);
        }
        return target == null || this.path != null;
    }

    public boolean canContinueToUse() {
        if (this.path == null || this.navigation.isDone()) {
            return false;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        Vec3 epos = this.entity.position();
        for (int i = 0; i < 8; ++i) {
            int j = Mth.floor((double)(epos.x + (double)(((float)(i % 2) - 0.5f) * 0.1f) + (double)this.entity.getEyeHeight()));
            int k = Mth.floor((double)(epos.y + (double)(((float)((i >> 1) % 2) - 0.5f) * this.entity.getBbWidth() * 0.8f)));
            int l = Mth.floor((double)(epos.z + (double)(((float)((i >> 2) % 2) - 0.5f) * this.entity.getBbWidth() * 0.8f)));
            if (pos.getX() == k && pos.getY() == j && pos.getZ() == l) continue;
            pos.set(k, j, l);
            if (!this.entity.level().getBlockState((BlockPos)pos).blocksMotion()) continue;
            return false;
        }
        return true;
    }

    public void start() {
        Vec3 epos = this.entity.position();
        if (this.path != null) {
            this.navigation.moveTo(this.path, this.farSpeed);
        }
        this.entity.level().playSound(null, epos.x, epos.y, epos.z, QuarkSounds.ENTITY_STONELING_MEEP, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    public void stop() {
        this.closestLivingEntity = null;
        Level level = this.entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel ws = (ServerLevel)level;
            Vec3 epos = this.entity.position();
            ws.sendParticles((ParticleOptions)ParticleTypes.CLOUD, epos.x, epos.y, epos.z, 40, 0.5, 0.5, 0.5, 0.1);
            ws.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, epos.x, epos.y, epos.z, 20, 0.5, 0.5, 0.5, 0.0);
        }
        for (Entity passenger : this.entity.getIndirectPassengers()) {
            if (passenger instanceof Player) continue;
            passenger.discard();
        }
        this.entity.discard();
    }

    public void tick() {
        if (this.entity.distanceToSqr((Entity)this.closestLivingEntity) < 49.0) {
            this.entity.getNavigation().setSpeedModifier(this.nearSpeed);
        } else {
            this.entity.getNavigation().setSpeedModifier(this.farSpeed);
        }
    }
}

