/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.block.pipe;

import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.addons.oddities.block.be.PipeBlockEntity;
import org.violetmoon.quark.addons.oddities.module.PipesModule;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.RenderLayerRegistry;
import org.violetmoon.zeta.util.MiscUtil;

public abstract class BasePipeBlock
extends ZetaBlock
implements EntityBlock {
    protected static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    protected static final BooleanProperty UP = BlockStateProperties.UP;
    protected static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    protected static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    protected static final BooleanProperty WEST = BlockStateProperties.WEST;
    protected static final BooleanProperty EAST = BlockStateProperties.EAST;

    protected static BooleanProperty property(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> DOWN;
            case Direction.UP -> UP;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
        };
    }

    protected BasePipeBlock(String name, SoundType soundType, @Nullable ZetaModule module) {
        this(name, module, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(3.0f, 10.0f).sound(soundType).noOcclusion());
    }

    protected BasePipeBlock(String name, @Nullable ZetaModule module, BlockBehaviour.Properties properties) {
        super(name, module, properties);
        this.registerDefaultState(this.getDefaultPipeState());
        if (module == null) {
            return;
        }
        this.setCreativeTab(CreativeModeTabs.REDSTONE_BLOCKS);
        module.zeta().renderLayerRegistry.put((Block)this, RenderLayerRegistry.Layer.CUTOUT);
    }

    public BlockState getDefaultPipeState() {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false));
    }

    boolean isPipeWaterlogged(BlockState state) {
        return false;
    }

    public boolean allowsFullConnection(PipeBlockEntity.ConnectionType conn) {
        return conn.isSolid;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (stack.getItem() == Items.STICK) {
            HashSet found = new HashSet();
            boolean fixedAny = false;
            HashSet<BlockPos> candidates = new HashSet<BlockPos>();
            HashSet<BlockPos> newCandidates = new HashSet<BlockPos>();
            candidates.add(pos);
            do {
                for (BlockPos cand : candidates) {
                    for (Direction d : Direction.values()) {
                        BlockPos offPos = cand.relative(d);
                        BlockState offState = worldIn.getBlockState(offPos);
                        if (offState.getBlock() != this || candidates.contains(offPos) || found.contains(offPos)) continue;
                        newCandidates.add(offPos);
                    }
                    BlockState curr = worldIn.getBlockState(cand);
                    BlockState target = this.getTargetState((LevelAccessor)worldIn, cand);
                    if (target.equals(curr)) continue;
                    fixedAny = true;
                    worldIn.setBlock(cand, target, 6);
                }
                found.addAll(candidates);
                candidates = newCandidates;
                newCandidates = new HashSet();
            } while (!candidates.isEmpty());
            if (fixedAny) {
                return ItemInteractionResult.sidedSuccess((boolean)worldIn.isClientSide);
            }
        }
        return super.useItemOn(stack, state, worldIn, pos, player, handIn, hit);
    }

    public BlockState rotate(BlockState state, Rotation direction) {
        BlockState newState = state;
        for (Direction dir : Direction.values()) {
            newState = (BlockState)newState.setValue((Property)BasePipeBlock.property(dir), (Comparable)((Boolean)state.getValue((Property)BasePipeBlock.property(direction.rotate(dir)))));
        }
        return newState;
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirror) {
        BlockState newState = state;
        for (Direction dir : Direction.values()) {
            newState = (BlockState)newState.setValue((Property)BasePipeBlock.property(dir), (Comparable)((Boolean)state.getValue((Property)BasePipeBlock.property(mirror.mirror(dir)))));
        }
        return newState;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        for (Direction d : Direction.values()) {
            PipeBlockEntity.ConnectionType type = PipeBlockEntity.computeConnectionTo((BlockGetter)level, pos, d);
            boolean fullConnection = this.allowsFullConnection(type);
            state = (BlockState)state.setValue((Property)MiscUtil.directionProperty((Direction)d), (Comparable)Boolean.valueOf(fullConnection));
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PipeBlockEntity) {
            PipeBlockEntity tile = (PipeBlockEntity)blockEntity;
            tile.refreshVisualConnections();
        }
        return state;
    }

    public void neighborChanged(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Block pNeighborBlock, @NotNull BlockPos pNeighborPos, boolean pMovedByPiston) {
        super.neighborChanged(pState, pLevel, pPos, pNeighborBlock, pNeighborPos, pMovedByPiston);
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof PipeBlockEntity) {
            PipeBlockEntity tile = (PipeBlockEntity)blockEntity;
            tile.refreshVisualConnections();
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getTargetState((LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        this.refreshVisualConnections(level, pos);
        super.setPlacedBy(level, pos, state, entity, stack);
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        this.refreshVisualConnections(pLevel, pPos);
    }

    public void refreshVisualConnections(Level pLevel, BlockPos pPos) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof PipeBlockEntity) {
            PipeBlockEntity tile = (PipeBlockEntity)blockEntity;
            tile.refreshVisualConnections();
        }
    }

    protected BlockState getTargetState(LevelAccessor level, BlockPos pos) {
        BlockState newState = this.defaultBlockState();
        for (Direction facing : Direction.values()) {
            PipeBlockEntity.ConnectionType type = PipeBlockEntity.computeConnectionTo((BlockGetter)level, pos, facing);
            newState = (BlockState)newState.setValue((Property)MiscUtil.directionProperty((Direction)facing), (Comparable)Boolean.valueOf(this.allowsFullConnection(type)));
        }
        return newState;
    }

    public static boolean isConnected(BlockState state, Direction side) {
        return (Boolean)state.getValue((Property)MiscUtil.directionProperty((Direction)side));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, DOWN, NORTH, SOUTH, WEST, EAST});
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(@NotNull BlockState blockState, Level worldIn, @NotNull BlockPos pos) {
        BlockEntity tile = worldIn.getBlockEntity(pos);
        if (tile instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)tile;
            return pipe.getComparatorOutput();
        }
        return 0;
    }

    public void onRemove(@NotNull BlockState state, Level worldIn, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        BlockEntity be = worldIn.getBlockEntity(pos);
        if (be instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)be;
            pipe.dropAllItems();
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new PipeBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level world, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return BasePipeBlock.createTickerHelper(type, PipesModule.blockEntityType, PipeBlockEntity::tick);
    }
}

