/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.gen;

import java.util.Objects;
import java.util.Random;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.world.config.AirStoneClusterConfig;
import org.violetmoon.quark.content.world.config.BigStoneClusterConfig;
import org.violetmoon.quark.content.world.module.BigStoneClustersModule;
import org.violetmoon.zeta.config.type.ClusterSizeConfig;
import org.violetmoon.zeta.world.generator.multichunk.ClusterBasedGenerator;

public class BigStoneClusterGenerator
extends ClusterBasedGenerator {
    private final BigStoneClusterConfig config;
    private final BlockState placeState;

    public BigStoneClusterGenerator(BigStoneClusterConfig config, BlockState placeState, BooleanSupplier condition) {
        super(config.dimensions, () -> config.enabled && condition.getAsBoolean(), (ClusterSizeConfig)config, (long)Objects.toString(Quark.ZETA.registry.getRegistryName((Object)placeState.getBlock(), (Registry)BuiltInRegistries.BLOCK)).hashCode());
        this.config = config;
        this.placeState = placeState;
    }

    public BlockPos[] getSourcesInChunk(WorldGenRegion world, Random random, ChunkGenerator generator, BlockPos chunkCorner) {
        int chance = this.config.rarity;
        if (chance > 0 && random.nextInt(chance) == 0) {
            int lower = this.config.minYLevel;
            int range = Math.abs(this.config.maxYLevel - this.config.minYLevel);
            BlockPos pos = chunkCorner.offset(random.nextInt(16), random.nextInt(range) + lower, random.nextInt(16));
            if (this.config.biomes.canSpawn(this.getBiome((LevelAccessor)world, pos, true))) {
                return new BlockPos[]{pos};
            }
        }
        return new BlockPos[0];
    }

    public String toString() {
        return "BigStoneClusterGenerator[" + String.valueOf(this.placeState) + "]";
    }

    public ClusterBasedGenerator.IGenerationContext createContext(BlockPos src, ChunkGenerator generator, Random random, BlockPos chunkCorner, final WorldGenRegion world) {
        return new ClusterBasedGenerator.IGenerationContext(){

            public boolean canPlaceAt(BlockPos pos) {
                return BigStoneClusterGenerator.this.canPlaceBlock((ServerLevelAccessor)world, pos);
            }

            public void consume(BlockPos pos) {
                world.setBlock(pos, BigStoneClusterGenerator.this.placeState, 0);
            }
        };
    }

    private boolean canPlaceBlock(ServerLevelAccessor world, BlockPos pos) {
        BigStoneClusterConfig bigStoneClusterConfig = this.config;
        if (bigStoneClusterConfig instanceof AirStoneClusterConfig) {
            AirStoneClusterConfig clusterConfig = (AirStoneClusterConfig)bigStoneClusterConfig;
            if (clusterConfig.generateInAir) {
                return world.getBlockState(pos).isAir();
            }
        }
        return BigStoneClustersModule.blockReplacePredicate.test((Level)world.getLevel(), world.getBlockState(pos).getBlock());
    }
}

