/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.violetmoon.quark.addons.oddities.util.InfluenceLocations;
import org.violetmoon.quark.api.IEnchantmentInfluencer;

public record CustomInfluence(int strength, int color, InfluenceLocations influence) implements IEnchantmentInfluencer
{
    @Override
    public int getEnchantmentInfluenceColor(BlockGetter world, BlockPos pos, BlockState state) {
        int r = FastColor.ARGB32.red((int)this.color) << 16;
        int g = FastColor.ARGB32.green((int)this.color) << 8;
        int b = FastColor.ARGB32.blue((int)this.color);
        return r + g + b;
    }

    @Override
    public int getInfluenceStack(BlockGetter world, BlockPos pos, BlockState state) {
        return this.strength;
    }

    @Override
    public boolean influencesEnchantment(BlockGetter world, BlockPos pos, BlockState state, Holder<Enchantment> enchantment) {
        return this.influence.boost().contains(ResourceLocation.parse((String)enchantment.getRegisteredName()));
    }

    @Override
    public boolean dampensEnchantment(BlockGetter world, BlockPos pos, BlockState state, Holder<Enchantment> enchantment) {
        return this.influence.dampen().contains(ResourceLocation.parse((String)enchantment.getRegisteredName()));
    }
}

