/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.api.ITrowelable;
import org.violetmoon.quark.api.IUsageTickerOverride;
import org.violetmoon.quark.base.components.ItemWrapperComponent;
import org.violetmoon.quark.base.components.QuarkDataComponents;
import org.violetmoon.quark.content.tools.module.SeedPouchModule;
import org.violetmoon.zeta.item.ZetaItem;
import org.violetmoon.zeta.module.IDisableable;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;
import org.violetmoon.zeta.util.RegistryUtil;

public class SeedPouchItem
extends ZetaItem
implements IUsageTickerOverride,
ITrowelable,
CreativeTabManager.AppendsUniquely {
    private static final int SEED_BAR_COLOR = Mth.color((float)0.4f, (float)0.4f, (float)1.0f);
    private static final int FERTILIZER_BAR_COLOR = Mth.color((float)0.85f, (float)0.85f, (float)0.85f);

    public SeedPouchItem(ZetaModule module) {
        super("seed_pouch", module, new Item.Properties().stacksTo(1));
        CreativeTabManager.addNextToItem((ResourceKey)CreativeModeTabs.TOOLS_AND_UTILITIES, (ItemLike)this, (ItemLike)Items.LEAD, (boolean)false);
    }

    public boolean overrideOtherStackedOnMe(@NotNull ItemStack pouch, @NotNull ItemStack incoming, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess carriedSlotAccessor) {
        if (pouch.getCount() != 1 || action != ClickAction.SECONDARY || !slot.allowModification(player)) {
            return false;
        }
        if (incoming.isEmpty()) {
            return this.dropOntoEmptyCursor(player, pouch, carriedSlotAccessor);
        }
        return this.absorbFromCursor(player, pouch, carriedSlotAccessor);
    }

    public boolean overrideStackedOnOther(@NotNull ItemStack pouch, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player) {
        if (pouch.getCount() != 1 || action != ClickAction.SECONDARY || !slot.allowModification(player)) {
            return false;
        }
        ItemStack droppedOnto = slot.getItem();
        if (droppedOnto.isEmpty()) {
            return this.dropIntoEmptySlot(player, pouch, slot);
        }
        return this.absorbFromSlot(player, pouch, slot);
    }

    private boolean absorbFromCursor(Player player, ItemStack pouch, SlotAccess cursorAccess) {
        return SeedPouchItem.mutateContents(pouch, contents -> {
            ItemStack onCursor = cursorAccess.get();
            if (!contents.absorb(onCursor)) {
                return false;
            }
            cursorAccess.set(onCursor);
            SeedPouchItem.playInsertSound((Entity)player);
            return true;
        });
    }

    private boolean absorbFromSlot(Player player, ItemStack pouch, Slot pickupFrom) {
        return SeedPouchItem.mutateContents(pouch, contents -> {
            if (!contents.absorb(pickupFrom.getItem())) {
                return false;
            }
            pickupFrom.setChanged();
            SeedPouchItem.playInsertSound((Entity)player);
            return true;
        });
    }

    private boolean dropOntoEmptyCursor(Player player, ItemStack pouch, SlotAccess cursorAccess) {
        return SeedPouchItem.mutateContents(pouch, contents -> {
            if (contents.isEmpty()) {
                return false;
            }
            cursorAccess.set(contents.splitOneStack());
            SeedPouchItem.playRemoveOneSound((Entity)player);
            return true;
        });
    }

    private boolean dropIntoEmptySlot(Player player, ItemStack pouch, Slot depositInto) {
        return SeedPouchItem.mutateContents(pouch, contents -> {
            if (contents.isEmpty()) {
                return false;
            }
            depositInto.set(contents.splitOneStack());
            SeedPouchItem.playRemoveOneSound((Entity)player);
            return true;
        });
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    private static void playRemoveOneSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private static void playInsertSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return true;
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        int count = SeedPouchItem.getCount(stack);
        return Math.round((float)count * 13.0f / (float)SeedPouchModule.maxItems);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return SeedPouchItem.getContents(stack).isFertilizer() ? FERTILIZER_BAR_COLOR : SEED_BAR_COLOR;
    }

    public static PouchContents getContents(ItemStack stack) {
        return PouchContents.readFromStack(stack);
    }

    public static int getCount(ItemStack stack) {
        return PouchContents.readCountOnlyFromStack(stack);
    }

    public static <T> T mutateContents(ItemStack pouch, Function<PouchContents, T> func) {
        return PouchContents.mutate(pouch, func);
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        Component base = super.getName(stack);
        PouchContents contents = SeedPouchItem.getContents(stack);
        if (contents.isEmpty()) {
            return base;
        }
        MutableComponent comp = base.copy();
        comp.append((Component)Component.literal((String)" ("));
        comp.append(contents.getContents().getHoverName());
        comp.append((Component)Component.literal((String)")"));
        return comp;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        ItemStack pouch = context.getItemInHand();
        return SeedPouchItem.mutateContents(pouch, contents -> {
            BlockEntity targetedBE;
            if (contents.isEmpty()) {
                return super.useOn(context);
            }
            ItemStack seed = contents.getContents().copy();
            int total = contents.count;
            seed.setCount(Math.min(seed.getMaxStackSize(), total));
            Player player = context.getPlayer();
            if (player != null && player.isShiftKeyDown() && !context.getLevel().isClientSide() && (targetedBE = context.getLevel().getBlockEntity(BlockPos.containing((Position)context.getClickLocation()))) instanceof ChestBlockEntity) {
                ChestBlockEntity chest = (ChestBlockEntity)targetedBE;
                Optional<IItemHandler> optionalItemHandler = Optional.ofNullable((IItemHandler)context.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, chest.getBlockPos(), (Object)Direction.NORTH));
                if (optionalItemHandler.isPresent()) {
                    ItemStack toInsert = seed.copy();
                    toInsert.setCount(total);
                    ItemStack inserted = ItemHandlerHelper.insertItem((IItemHandler)optionalItemHandler.get(), (ItemStack)toInsert, (boolean)false);
                    int amountInserted = total - inserted.getCount();
                    if (amountInserted == 0) {
                        MutableComponent component = Component.literal((String)"The inventory you are trying to insert into is full...").withStyle(ChatFormatting.RED);
                        player.displayClientMessage((Component)component, true);
                    } else {
                        contents.shrink(amountInserted);
                    }
                }
            }
            if (player == null || !player.isShiftKeyDown()) {
                return this.placeSeed((PouchContents)contents, context, seed, context.getClickedPos());
            }
            InteractionResult bestRes = InteractionResult.FAIL;
            int range = contents.isSeed() ? SeedPouchModule.shiftRange : SeedPouchModule.fertilizerShiftRange;
            int blocks = range * range;
            int shift = -((int)Math.floor((float)range / 2.0f));
            for (int i = 0; i < blocks; ++i) {
                int x = shift + i % range;
                int z = shift + i / range;
                InteractionResult res = this.placeSeed((PouchContents)contents, context, seed, context.getClickedPos().offset(x, 0, z));
                if (contents.isEmpty()) break;
                if (bestRes.consumesAction()) continue;
                bestRes = res;
            }
            return bestRes;
        });
    }

    private InteractionResult placeSeed(PouchContents mutableContents, UseOnContext context, ItemStack seed, BlockPos pos) {
        int itemsToTake;
        InteractionResult res;
        @Nullable Player player = context.getPlayer();
        if (player == null) {
            res = seed.getItem().useOn((UseOnContext)new PouchItemUseContext(context, seed, pos));
        } else {
            ItemStack restore = player.getItemInHand(context.getHand());
            player.setItemInHand(context.getHand(), seed);
            res = seed.getItem().useOn((UseOnContext)new PouchItemUseContext(context, seed, pos));
            player.setItemInHand(context.getHand(), restore);
        }
        int n = itemsToTake = res == InteractionResult.CONSUME ? 1 : 0;
        if (!(itemsToTake == 0 || player != null && player.getAbilities().instabuild)) {
            mutableContents.shrink(itemsToTake);
        }
        return res;
    }

    public List<ItemStack> appendItemsToCreativeTab(RegistryAccess access) {
        if (!this.isEnabled()) {
            return List.of();
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((ItemLike)this));
        if (SeedPouchModule.showAllVariantsInCreative && access != null) {
            (SeedPouchModule.allowFertilizer ? Stream.of(SeedPouchModule.seedPouchHoldableTag, SeedPouchModule.seedPouchFertilizersTag) : Stream.of(SeedPouchModule.seedPouchHoldableTag)).flatMap(tag -> RegistryUtil.getTagValues((RegistryAccess)access, (TagKey)tag).stream()).filter(IDisableable::isEnabled).map(seed -> {
                PouchContents contents = new PouchContents();
                contents.setContents(new ItemStack((ItemLike)seed));
                contents.setCount(SeedPouchModule.maxItems);
                return contents.writeToStack(new ItemStack((ItemLike)this));
            }).forEach(list::add);
        }
        return list;
    }

    @Override
    public ItemStack getUsageTickerItem(ItemStack stack, RegistryAccess access) {
        PouchContents contents = SeedPouchItem.getContents(stack);
        return contents.isEmpty() ? stack : contents.getContents();
    }

    @Override
    public int getUsageTickerCountForItem(ItemStack stack, Predicate<ItemStack> target) {
        PouchContents contents = SeedPouchItem.getContents(stack);
        return !contents.isEmpty() && target.test(contents.getContents()) ? contents.getCount() : 0;
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        return SeedPouchItem.getCount(stack) == 0 ? Optional.empty() : Optional.of(new Tooltip(stack));
    }

    public static class PouchContents {
        public static final String TAG_STORED_ITEM = "storedItem";
        public static final String TAG_COUNT = "itemCount";
        private ItemStack contents = ItemStack.EMPTY;
        private int count = 0;

        public ItemStack writeToStack(ItemStack target) {
            CompoundTag tag = new CompoundTag();
            if (this.isEmpty()) {
                target.remove(QuarkDataComponents.STORED_ITEM);
                target.remove(QuarkDataComponents.ITEM_COUNT);
            } else {
                target.set(QuarkDataComponents.STORED_ITEM, (Object)new ItemWrapperComponent(this.contents));
                target.set(QuarkDataComponents.ITEM_COUNT, (Object)this.count);
            }
            return target;
        }

        public static PouchContents readFromStack(ItemStack target) {
            PouchContents contents = new PouchContents();
            if (target.has(QuarkDataComponents.STORED_ITEM) && target.has(QuarkDataComponents.ITEM_COUNT)) {
                contents.contents = ((ItemWrapperComponent)target.get(QuarkDataComponents.STORED_ITEM)).stack();
                contents.count = (Integer)target.get(QuarkDataComponents.ITEM_COUNT);
            }
            return contents;
        }

        public static int readCountOnlyFromStack(ItemStack target) {
            if (target.has(QuarkDataComponents.ITEM_COUNT)) {
                return (Integer)target.get(QuarkDataComponents.ITEM_COUNT);
            }
            return 0;
        }

        public static <T> T mutate(ItemStack pouch, Function<PouchContents, T> action) {
            PouchContents contents = PouchContents.readFromStack(pouch);
            T result = action.apply(contents);
            contents.writeToStack(pouch);
            return result;
        }

        public boolean isEmpty() {
            return this.contents.isEmpty() || this.count == 0;
        }

        public ItemStack getContents() {
            return this.contents;
        }

        public int getCount() {
            return this.count;
        }

        public boolean isSeed() {
            return !this.isEmpty() && this.contents.is(SeedPouchModule.seedPouchHoldableTag);
        }

        public boolean isFertilizer() {
            return !this.isEmpty() && this.contents.is(SeedPouchModule.seedPouchFertilizersTag);
        }

        public void setContents(ItemStack contents) {
            this.contents = contents.copy();
            this.contents.setCount(1);
        }

        public void setCount(int newCount) {
            this.count = newCount;
            if (this.count <= 0) {
                this.count = 0;
                this.contents = ItemStack.EMPTY;
            }
        }

        public void grow(int more) {
            this.setCount(this.count + more);
        }

        public void shrink(int less) {
            this.setCount(this.count - less);
        }

        public boolean absorb(ItemStack other) {
            if (!this.canFit(other)) {
                return false;
            }
            int toMove = Math.min(SeedPouchModule.maxItems - this.count, other.getCount());
            if (toMove == 0) {
                return false;
            }
            if (this.isEmpty()) {
                this.setContents(other);
                this.setCount(toMove);
            } else {
                this.grow(toMove);
            }
            other.shrink(toMove);
            return true;
        }

        public ItemStack split(int request) {
            int howMany = Math.min(this.count, request);
            ItemStack result = this.contents.copy();
            result.setCount(howMany);
            this.shrink(howMany);
            return result;
        }

        public ItemStack splitOneStack() {
            return this.split(this.contents.getMaxStackSize());
        }

        public boolean canFit(ItemStack other) {
            if (this.isEmpty()) {
                return other.is(SeedPouchModule.seedPouchHoldableTag) || SeedPouchModule.allowFertilizer && other.is(SeedPouchModule.seedPouchFertilizersTag);
            }
            return this.count < SeedPouchModule.maxItems && ItemStack.isSameItemSameComponents((ItemStack)this.contents, (ItemStack)other);
        }
    }

    public static class PouchItemUseContext
    extends UseOnContext {
        protected PouchItemUseContext(UseOnContext parent, ItemStack stack, BlockPos targetPos) {
            super(parent.getLevel(), parent.getPlayer(), parent.getHand(), stack, new BlockHitResult(parent.getClickLocation(), parent.getClickedFace(), targetPos, parent.isInside()));
        }
    }

    public record Tooltip(ItemStack stack) implements TooltipComponent
    {
    }
}

