/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.violetmoon.quark.content.tweaks.block.WaterPetalBlock;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.player.ZRightClickBlock;
import org.violetmoon.zeta.event.play.entity.player.ZRightClickItem;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="tweaks")
public class PetalsOnWaterModule
extends ZetaModule {
    Block water_pink_petals;

    @LoadEvent
    public final void register(ZRegister event) {
        this.water_pink_petals = new WaterPetalBlock(Items.PINK_PETALS, "water_pink_petals", this, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PINK_PETALS));
    }

    @PlayEvent
    public void onUseOnAir(ZRightClickItem event) {
        ItemStack stack = event.getItemStack();
        if (stack.is(Items.PINK_PETALS)) {
            Player player = event.getEntity();
            Level level = event.getLevel();
            InteractionHand hand = event.getHand();
            BlockHitResult blockhitresult = Item.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            BlockPos pos = blockhitresult.getBlockPos();
            BlockState state = level.getBlockState(pos);
            Direction direction = blockhitresult.getDirection();
            if (state.is(Blocks.WATER) && this.rightClickPetal(player, level, pos, state, direction, hand, stack)) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide));
            }
        }
    }

    @PlayEvent
    public void onUseOnBlock(ZRightClickBlock event) {
        ItemStack stack = event.getItemStack();
        if (stack.is(Items.PINK_PETALS) && this.rightClickPetal(event.getPlayer(), event.getLevel(), event.getPos(), event.getLevel().getBlockState(event.getPos()), event.getFace(), event.getHand(), event.getItemStack())) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)event.getLevel().isClientSide));
        }
    }

    private boolean rightClickPetal(Player player, Level level, BlockPos pos, BlockState state, Direction direction, InteractionHand hand, ItemStack stack) {
        boolean ret;
        if (direction == Direction.UP && !state.is(Blocks.WATER) && !state.is(this.water_pink_petals)) {
            pos = pos.above();
            state = level.getBlockState(pos);
        }
        if (ret = this.tryPlacePetal(player, level, pos, state, direction, hand, stack)) {
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            level.playSound(player, pos, SoundEvents.PINK_PETALS_PLACE, SoundSource.PLAYERS);
        }
        return ret;
    }

    private boolean tryPlacePetal(Player player, Level level, BlockPos pos, BlockState state, Direction direction, InteractionHand hand, ItemStack stack) {
        int amt;
        BlockPlaceContext ctx = new BlockPlaceContext(player, hand, stack, new BlockHitResult(new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), direction, pos, false));
        if (state.is(Blocks.WATER)) {
            FluidState fluid = level.getFluidState(pos);
            if (!fluid.isSource()) {
                return false;
            }
            BlockPos above = pos.above();
            BlockState stateAbove = level.getBlockState(above);
            if (stateAbove.is(this.water_pink_petals)) {
                state = stateAbove;
                pos = above;
            } else if (stateAbove.isAir()) {
                level.setBlock(above, this.water_pink_petals.getStateForPlacement(ctx), 3);
                return true;
            }
        }
        if (state.is(this.water_pink_petals) && (amt = ((Integer)state.getValue((Property)PinkPetalsBlock.AMOUNT)).intValue()) < 4) {
            level.setBlock(pos, (BlockState)state.setValue((Property)PinkPetalsBlock.AMOUNT, (Comparable)Integer.valueOf(amt + 1)), 3);
            return true;
        }
        return false;
    }
}

