/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.management.inventory;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ShulkerBoxSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.violetmoon.quark.api.ISortingLockedSlots;
import org.violetmoon.quark.content.management.module.ExpandedItemInteractionsModule;

public class HeldShulkerBoxMenu
extends AbstractContainerMenu
implements ISortingLockedSlots {
    private final Container container;
    private final Player player;
    public final int blockedSlot;

    public HeldShulkerBoxMenu(int containerID, Inventory playerInventory, int blockedSlot) {
        this(containerID, playerInventory, (Container)new SimpleContainer(27), blockedSlot);
    }

    public HeldShulkerBoxMenu(int containerID, Inventory playerInventory, FriendlyByteBuf buf) {
        this(containerID, playerInventory, buf.readInt());
    }

    public HeldShulkerBoxMenu(int containerID, Inventory playerInventory, Container container, int blockedSlot) {
        super(ExpandedItemInteractionsModule.heldShulkerBoxMenuType, containerID);
        int slot;
        int column;
        int row;
        HeldShulkerBoxMenu.checkContainerSize((Container)container, (int)27);
        this.container = container;
        this.player = playerInventory.player;
        this.blockedSlot = blockedSlot;
        container.startOpen(this.player);
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 9; ++column) {
                slot = column + row * 9;
                this.addSlot((Slot)new ShulkerBoxSlot(container, slot, 8 + column * 18, 18 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 9; ++column) {
                slot = column + row * 9 + 9;
                if (slot == blockedSlot) continue;
                this.addSlot(new Slot((Container)playerInventory, slot, 8 + column * 18, 84 + row * 18));
            }
        }
        for (int slot2 = 0; slot2 < 9; ++slot2) {
            if (slot2 == blockedSlot) continue;
            this.addSlot(new Slot((Container)playerInventory, slot2, 8 + slot2 * 18, 142));
        }
    }

    public boolean stillValid(Player checkedPlayer) {
        return this.container.stillValid(checkedPlayer);
    }

    public ItemStack quickMoveStack(Player checkedPlayer, int slotIndex) {
        ItemStack copy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack stack = slot.getItem();
            copy = stack.copy();
            if (slotIndex < this.container.getContainerSize() ? !this.moveItemStackTo(stack, this.container.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(stack, 0, this.container.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return copy;
    }

    public void suppressRemoteUpdates() {
        super.suppressRemoteUpdates();
        this.player.inventoryMenu.suppressRemoteUpdates();
    }

    public void resumeRemoteUpdates() {
        super.resumeRemoteUpdates();
        this.player.inventoryMenu.resumeRemoteUpdates();
    }

    public void removed(Player checkedPlayer) {
        super.removed(checkedPlayer);
        this.container.stopOpen(checkedPlayer);
    }

    @Override
    public int[] getSortingLockedSlots(boolean sortingPlayerInventory) {
        int[] nArray;
        if (sortingPlayerInventory) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = this.blockedSlot;
        } else {
            nArray = null;
        }
        return nArray;
    }
}

