/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.addons.oddities.block.be.CrateBlockEntity;
import org.violetmoon.quark.addons.oddities.module.CrateModule;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;

public class CrateBlock
extends ZetaBlock
implements EntityBlock {
    public static final BooleanProperty PROPERTY_OPEN = BlockStateProperties.OPEN;

    public CrateBlock(@Nullable ZetaModule module) {
        super("crate", module, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BARREL));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)PROPERTY_OPEN, (Comparable)Boolean.valueOf(false)));
        if (module == null) {
            return;
        }
        this.setCreativeTab(CreativeModeTabs.FUNCTIONAL_BLOCKS, (ItemLike)Blocks.BARREL, false);
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos) {
        BlockEntity be = world.getBlockEntity(pos);
        if (be instanceof CrateBlockEntity) {
            CrateBlockEntity crate = (CrateBlockEntity)be;
            return (int)(Math.floor((double)crate.displayTotal * 14.0 / (double)crate.getContainerSize()) + (double)(crate.displayTotal > 0 ? 1 : 0));
        }
        return 0;
    }

    @Nullable
    public MenuProvider getMenuProvider(@NotNull BlockState state, Level level, @NotNull BlockPos pos) {
        MenuProvider provider;
        BlockEntity be = level.getBlockEntity(pos);
        return be instanceof MenuProvider ? (provider = (MenuProvider)be) : null;
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, Level worldIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (worldIn.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity be = worldIn.getBlockEntity(pos);
        if (be instanceof CrateBlockEntity) {
            CrateBlockEntity crate = (CrateBlockEntity)be;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.openMenu((MenuProvider)crate, pos);
            }
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    public void setPlacedBy(@NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity tileentity;
        if (stack.getComponents().has(DataComponents.CUSTOM_NAME) && (tileentity = worldIn.getBlockEntity(pos)) instanceof CrateBlockEntity) {
            CrateBlockEntity crate = (CrateBlockEntity)tileentity;
            crate.setComponents(stack.getComponents());
        }
    }

    public void tick(@NotNull BlockState state, ServerLevel worldIn, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        BlockEntity tileentity = worldIn.getBlockEntity(pos);
        if (tileentity instanceof CrateBlockEntity) {
            ((CrateBlockEntity)tileentity).crateTick();
        }
    }

    public void onRemove(BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileentity;
        if (!state.is(newState.getBlock()) && (tileentity = worldIn.getBlockEntity(pos)) instanceof CrateBlockEntity) {
            CrateBlockEntity crate = (CrateBlockEntity)tileentity;
            crate.spillTheTea();
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PROPERTY_OPEN});
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new CrateBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level world, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return CrateBlock.createTickerHelper(type, CrateModule.blockEntityType, CrateBlockEntity::tick);
    }
}

