/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.module;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.mobs.client.render.entity.FoxhoundRenderer;
import org.violetmoon.quark.content.mobs.entity.Foxhound;
import org.violetmoon.zeta.advancement.ManualTrigger;
import org.violetmoon.zeta.advancement.modifier.MonsterHunterModifier;
import org.violetmoon.zeta.advancement.modifier.TwoByTwoModifier;
import org.violetmoon.zeta.api.IAdvancementModifier;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.config.type.CompoundBiomeConfig;
import org.violetmoon.zeta.config.type.CostSensitiveEntitySpawnConfig;
import org.violetmoon.zeta.config.type.EntitySpawnConfig;
import org.violetmoon.zeta.config.type.IBiomeConfig;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZEntityAttributeCreation;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.living.ZLivingChangeTarget;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="mobs")
public class FoxhoundModule
extends ZetaModule {
    public static EntityType<Foxhound> foxhoundType;
    @Config(description="The chance coal will tame a foxhound")
    public static double tameChance;
    @Config(flag="foxhound_furnace")
    public static boolean foxhoundsSpeedUpFurnaces;
    @Config
    public static EntitySpawnConfig spawnConfig;
    @Config
    public static EntitySpawnConfig lesserSpawnConfig;
    public static TagKey<Block> foxhoundSpawnableTag;
    public static ManualTrigger foxhoundFurnaceTrigger;

    @LoadEvent
    public final void register(ZRegister event) {
        foxhoundType = EntityType.Builder.of(Foxhound::new, (MobCategory)MobCategory.CREATURE).sized(0.8f, 0.8f).clientTrackingRange(8).fireImmune().build("foxhound");
        Quark.ZETA.registry.register(foxhoundType, "foxhound", Registries.ENTITY_TYPE);
        Quark.ZETA.entitySpawn.registerSpawn(foxhoundType, MobCategory.CREATURE, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Foxhound::spawnPredicate, spawnConfig);
        Quark.ZETA.entitySpawn.track(foxhoundType, MobCategory.CREATURE, lesserSpawnConfig, true);
        Quark.ZETA.entitySpawn.addEgg((ZetaModule)this, foxhoundType, 8981773, 15904587, spawnConfig);
        event.getAdvancementModifierRegistry().addModifier((IAdvancementModifier)new MonsterHunterModifier((ZetaModule)this, (Set)ImmutableSet.of(foxhoundType)));
        event.getAdvancementModifierRegistry().addModifier((IAdvancementModifier)new TwoByTwoModifier((ZetaModule)this, (Set)ImmutableSet.of(foxhoundType)));
        foxhoundFurnaceTrigger = event.getAdvancementModifierRegistry().registerManualTrigger("foxhound_furnace");
    }

    @LoadEvent
    public final void entityAttrs(ZEntityAttributeCreation e) {
        e.put(foxhoundType, Wolf.createAttributes().build());
    }

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        foxhoundSpawnableTag = BlockTags.create((ResourceLocation)Quark.asResource("foxhound_spawnable"));
    }

    @PlayEvent
    public void onAggro(ZLivingChangeTarget event) {
        if (event.getNewTarget() != null && event.getTargetType() != LivingChangeTargetEvent.LivingTargetType.BEHAVIOR_TARGET && event.getEntity().getType() == EntityType.IRON_GOLEM && event.getNewTarget().getType() == foxhoundType && ((Foxhound)event.getNewTarget()).isTame()) {
            event.setCanceled(true);
        }
    }

    static {
        tameChance = 0.05;
        foxhoundsSpeedUpFurnaces = true;
        spawnConfig = new EntitySpawnConfig(30, 1, 2, (IBiomeConfig)CompoundBiomeConfig.fromBiomeReslocs((boolean)false, (String[])new String[]{"minecraft:nether_wastes", "minecraft:basalt_deltas"}));
        lesserSpawnConfig = new CostSensitiveEntitySpawnConfig(2, 1, 1, 0.7, 0.15, (IBiomeConfig)CompoundBiomeConfig.fromBiomeReslocs((boolean)false, (String[])new String[]{"minecraft:soul_sand_valley"}));
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends FoxhoundModule {
        @LoadEvent
        public final void clientSetup(ZClientSetup event) {
            EntityRenderers.register((EntityType)foxhoundType, FoxhoundRenderer::new);
        }
    }
}

