/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.automation.block;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.content.automation.base.RandomizerPowerState;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.RenderLayerRegistry;

public class RedstoneRandomizerBlock
extends ZetaBlock {
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<RandomizerPowerState> POWERED = EnumProperty.create((String)"powered", RandomizerPowerState.class);

    public RedstoneRandomizerBlock(String regname, @Nullable ZetaModule module, BlockBehaviour.Properties properties) {
        super(regname, module, properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(POWERED, (Comparable)((Object)RandomizerPowerState.OFF)));
        if (module == null) {
            return;
        }
        module.zeta().renderLayerRegistry.put((Block)this, RenderLayerRegistry.Layer.CUTOUT);
        this.setCreativeTab(CreativeModeTabs.REDSTONE_BLOCKS, (ItemLike)Blocks.COMPARATOR, false);
    }

    public void tick(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        boolean willBePowered;
        boolean isPowered = this.isPowered(state);
        if (isPowered != (willBePowered = this.shouldBePowered((Level)world, pos, state))) {
            RandomizerPowerState notOff;
            RandomizerPowerState oldPowerState = (RandomizerPowerState)((Object)state.getValue(POWERED));
            RandomizerPowerState newPowerState = !willBePowered ? RandomizerPowerState.OFF : (rand.nextBoolean() ? RandomizerPowerState.LEFT : RandomizerPowerState.RIGHT);
            world.setBlockAndUpdate(pos, (BlockState)state.setValue(POWERED, (Comparable)((Object)newPowerState)));
            RandomizerPowerState randomizerPowerState = notOff = oldPowerState == RandomizerPowerState.OFF ? newPowerState : oldPowerState;
            if (notOff == RandomizerPowerState.OFF) {
                return;
            }
            Direction rel = switch (notOff) {
                case RandomizerPowerState.LEFT -> ((Direction)state.getValue((Property)FACING)).getClockWise();
                case RandomizerPowerState.RIGHT -> ((Direction)state.getValue((Property)FACING)).getCounterClockWise();
                default -> throw new IllegalStateException();
            };
            world.updateNeighborsAtExceptFromFacing(pos.relative(rel), (Block)this, rel.getOpposite());
        }
    }

    protected void updateState(Level world, BlockPos pos, BlockState state) {
        boolean willBePowered;
        boolean isPowered = this.isPowered(state);
        if (isPowered != (willBePowered = this.shouldBePowered(world, pos, state)) && !world.getBlockTicks().willTickThisTick(pos, (Object)this)) {
            TickPriority priority = isPowered ? TickPriority.VERY_HIGH : TickPriority.HIGH;
            world.scheduleTick(pos, (Block)this, 2, priority);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED});
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    public boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader world, BlockPos pos) {
        return RedstoneRandomizerBlock.canSupportRigidBlock((BlockGetter)world, (BlockPos)pos.below());
    }

    protected boolean isPowered(BlockState state) {
        return state.getValue(POWERED) != RandomizerPowerState.OFF;
    }

    public int getDirectSignal(BlockState blockState, @NotNull BlockGetter blockAccess, @NotNull BlockPos pos, @NotNull Direction side) {
        return blockState.getSignal(blockAccess, pos, side);
    }

    public int getSignal(BlockState blockState, @NotNull BlockGetter blockAccess, @NotNull BlockPos pos, @NotNull Direction side) {
        RandomizerPowerState powerState = (RandomizerPowerState)((Object)blockState.getValue(POWERED));
        return switch (powerState) {
            case RandomizerPowerState.RIGHT -> {
                if (((Direction)blockState.getValue((Property)FACING)).getClockWise() == side) {
                    yield 15;
                }
                yield 0;
            }
            case RandomizerPowerState.LEFT -> {
                if (((Direction)blockState.getValue((Property)FACING)).getCounterClockWise() == side) {
                    yield 15;
                }
                yield 0;
            }
            default -> 0;
        };
    }

    public void neighborChanged(BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        if (state.canSurvive((LevelReader)world, pos)) {
            this.updateState(world, pos, state);
        } else {
            RedstoneRandomizerBlock.breakAndDrop((Block)this, state, world, pos);
        }
    }

    public static void breakAndDrop(Block block, BlockState state, Level world, BlockPos pos) {
        RedstoneRandomizerBlock.dropResources((BlockState)state, (LevelAccessor)world, (BlockPos)pos, null);
        world.removeBlock(pos, false);
        for (Direction direction : Direction.values()) {
            world.updateNeighborsAt(pos.relative(direction), block);
        }
    }

    protected boolean shouldBePowered(Level world, BlockPos pos, BlockState state) {
        return this.calculateInputStrength(world, pos, state) > 0;
    }

    protected int calculateInputStrength(Level world, BlockPos pos, BlockState state) {
        Direction face = (Direction)state.getValue((Property)FACING);
        BlockPos checkPos = pos.relative(face);
        int strength = world.getSignal(checkPos, face);
        if (strength >= 15) {
            return strength;
        }
        BlockState checkState = world.getBlockState(checkPos);
        return Math.max(strength, checkState.getBlock() == Blocks.REDSTONE_WIRE ? (Integer)checkState.getValue((Property)RedStoneWireBlock.POWER) : 0);
    }

    public boolean isSignalSource(@NotNull BlockState state) {
        return true;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void setPlacedBy(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, LivingEntity placer, @NotNull ItemStack stack) {
        if (this.shouldBePowered(world, pos, state)) {
            world.scheduleTick(pos, (Block)this, 1);
        }
    }

    public void onPlace(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        RedstoneRandomizerBlock.notifyNeighbors((Block)this, world, pos, state);
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!isMoving && state.getBlock() != newState.getBlock()) {
            super.onRemove(state, world, pos, newState, false);
            RedstoneRandomizerBlock.notifyNeighbors((Block)this, world, pos, state);
        }
    }

    public static void notifyNeighbors(Block block, Level world, BlockPos pos, BlockState state) {
        Direction face = (Direction)state.getValue((Property)FACING);
        BlockPos neighborPos = pos.relative(face.getOpposite());
        if (EventHooks.onNeighborNotify((Level)world, (BlockPos)pos, (BlockState)world.getBlockState(pos), EnumSet.of(face.getOpposite()), (boolean)false).isCanceled()) {
            return;
        }
        world.neighborChanged(neighborPos, block, pos);
        world.updateNeighborsAtExceptFromFacing(neighborPos, block, face);
    }

    public void animateTick(BlockState stateIn, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        if (stateIn.getValue(POWERED) != RandomizerPowerState.OFF) {
            double x = (double)pos.getX() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
            double y = (double)pos.getY() + 0.4 + ((double)rand.nextFloat() - 0.5) * 0.2;
            double z = (double)pos.getZ() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
            worldIn.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

