/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.module;

import com.google.common.collect.ImmutableSet;
import com.terraformersmc.biolith.api.biome.BiomePlacement;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.world.block.GlowLichenGrowthBlock;
import org.violetmoon.quark.content.world.block.GlowShroomBlock;
import org.violetmoon.quark.content.world.block.GlowShroomRingBlock;
import org.violetmoon.quark.content.world.block.HugeGlowShroomBlock;
import org.violetmoon.quark.content.world.feature.GlowExtrasFeature;
import org.violetmoon.quark.content.world.feature.GlowShroomsFeature;
import org.violetmoon.zeta.advancement.modifier.AdventuringTimeModifier;
import org.violetmoon.zeta.api.IAdvancementModifier;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="world")
public class GlimmeringWealdModule
extends ZetaModule {
    public static final ResourceLocation BIOME_NAME = Quark.asResource("glimmering_weald");
    public static final ResourceKey<Biome> BIOME_KEY = Quark.asResourceKey(Registries.BIOME, "glimmering_weald");
    public static ResourceKey<PlacedFeature> GLOW_SHROOMS_FEATURE = Quark.asResourceKey(Registries.PLACED_FEATURE, "glow_shrooms");
    public static ResourceKey<PlacedFeature> GLOW_SHROOMS_EXTRAS_FEATURE = Quark.asResourceKey(Registries.PLACED_FEATURE, "glow_shrooms_extras");
    public static GlowShroomsFeature glow_shrooms_feature;
    public static GlowExtrasFeature glow_shrooms_extras_feature;
    public static Holder<PlacedFeature> ore_lapis_extra;
    public static Holder<PlacedFeature> placed_glow_shrooms;
    public static Holder<PlacedFeature> placed_glow_extras;
    @Hint
    public static Block glow_shroom;
    @Hint
    public static Block glow_lichen_growth;
    public static Block glow_shroom_block;
    public static Block glow_shroom_stem;
    public static Block glow_shroom_ring;
    public static TagKey<Item> glowShroomFeedablesTag;

    @LoadEvent
    public final void register(ZRegister event) {
        CreativeTabManager.startChain((ResourceKey)CreativeModeTabs.NATURAL_BLOCKS, (boolean)false, (boolean)false, (ItemLike)Blocks.HANGING_ROOTS);
        glow_shroom = new GlowShroomBlock(this).setCreativeTab(CreativeModeTabs.NATURAL_BLOCKS, (ItemLike)Blocks.HANGING_ROOTS, false);
        glow_shroom_block = new HugeGlowShroomBlock("glow_shroom_block", this, true);
        glow_shroom_stem = new HugeGlowShroomBlock("glow_shroom_stem", this, false);
        glow_shroom_ring = new GlowShroomRingBlock(this);
        glow_lichen_growth = new GlowLichenGrowthBlock(this);
        CreativeTabManager.endChain();
        event.getVariantRegistry().addFlowerPot(glow_lichen_growth, "glow_lichen_growth", prop -> prop.lightLevel(state -> 8));
        event.getVariantRegistry().addFlowerPot(glow_shroom, "glow_shroom", prop -> prop.lightLevel(state -> 10));
        glow_shrooms_feature = new GlowShroomsFeature();
        event.getRegistry().register((Object)glow_shrooms_feature, GLOW_SHROOMS_FEATURE.location(), Registries.FEATURE);
        glow_shrooms_extras_feature = new GlowExtrasFeature();
        event.getRegistry().register((Object)glow_shrooms_extras_feature, GLOW_SHROOMS_EXTRAS_FEATURE.location(), Registries.FEATURE);
    }

    @LoadEvent
    public void postRegister(ZRegister.Post e) {
        Climate.Parameter FULL_RANGE = Climate.Parameter.span((float)-1.0f, (float)1.0f);
        Climate.ParameterPoint climatePoint = Climate.parameters((Climate.Parameter)FULL_RANGE, (Climate.Parameter)FULL_RANGE, (Climate.Parameter)Climate.Parameter.span((float)-1.2f, (float)0.75f), (Climate.Parameter)Climate.Parameter.span((float)-0.28f, (float)0.08f), (Climate.Parameter)Climate.Parameter.span((float)0.95f, (float)1.1f), (Climate.Parameter)FULL_RANGE, (float)0.0f);
        BiomePlacement.addOverworld(BIOME_KEY, (Climate.ParameterPoint)climatePoint);
        Quark.ZETA.advancementModifierRegistry.addModifier((IAdvancementModifier)new AdventuringTimeModifier((ZetaModule)this, (Set)ImmutableSet.of(BIOME_KEY)));
    }

    @LoadEvent
    public void setup(ZCommonSetup e) {
        glowShroomFeedablesTag = Quark.asTagKey(Registries.ITEM, "glow_shroom_feedables");
        e.enqueueWork(() -> {
            ComposterBlock.COMPOSTABLES.put((Object)glow_shroom.asItem(), 0.65f);
            ComposterBlock.COMPOSTABLES.put((Object)glow_shroom_block.asItem(), 0.65f);
            ComposterBlock.COMPOSTABLES.put((Object)glow_shroom_stem.asItem(), 0.65f);
            ComposterBlock.COMPOSTABLES.put((Object)glow_shroom_ring.asItem(), 0.65f);
            ComposterBlock.COMPOSTABLES.put((Object)glow_lichen_growth.asItem(), 0.5f);
        });
    }
}

