/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.mixin.mixins.client.variants;

import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.ChickenRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Chicken;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.violetmoon.quark.content.client.module.VariantAnimalTexturesModule;
import org.violetmoon.quark.content.tweaks.module.GrabChickensModule;

@Mixin(value={ChickenRenderer.class})
public abstract class ChickenRendererMixin
extends MobRenderer<Chicken, ChickenModel<Chicken>> {
    public ChickenRendererMixin(EntityRendererProvider.Context context, ChickenModel<Chicken> model, float shadowRadius) {
        super(context, model, shadowRadius);
    }

    @Inject(method={"getTextureLocation(Lnet/minecraft/world/entity/animal/Chicken;)Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="HEAD")}, cancellable=true)
    private void overrideTexture(Chicken chicken, CallbackInfoReturnable<ResourceLocation> cir) {
        ResourceLocation loc;
        ChickenRenderer render = (ChickenRenderer)this;
        EntityModel model = render.getModel();
        if (model instanceof ChickenModel) {
            ChickenModel vanillaChicken = (ChickenModel)model;
            GrabChickensModule.Client.setRenderChickenFeetStatus(chicken, vanillaChicken);
        }
        if ((loc = VariantAnimalTexturesModule.Client.getChickenTexture(chicken)) != null) {
            cir.setReturnValue((Object)loc);
        }
    }
}

