/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.ai;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import org.violetmoon.quark.content.mobs.entity.Foxhound;

public class FoxhoundSleepGoal
extends Goal {
    private final Foxhound foxhound;
    private boolean wasSitting;

    public FoxhoundSleepGoal(Foxhound foxhound) {
        this.foxhound = foxhound;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.TARGET));
    }

    public boolean canUse() {
        if (this.foxhound.isSleeping()) {
            if (!this.foxhound.isTame() || this.foxhound.isInWater() || !this.foxhound.onGround()) {
                return false;
            }
            LivingEntity living = this.foxhound.getOwner();
            if (living == null) {
                return true;
            }
            return !(this.foxhound.distanceToSqr((Entity)living) < 144.0) || living.getLastHurtByMob() == null;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.foxhound.getPose() == Pose.SLEEPING;
    }

    public void start() {
        this.foxhound.getNavigation().stop();
        this.wasSitting = this.foxhound.isOrderedToSit();
        this.foxhound.setPose(Pose.SLEEPING);
    }

    public void stop() {
        this.foxhound.setOrderedToSit(this.wasSitting);
        if (this.wasSitting) {
            this.foxhound.setPose(Pose.SITTING);
        } else {
            this.foxhound.setPose(Pose.STANDING);
        }
    }
}

