/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.util.BlockPropertyUtil;
import org.violetmoon.quark.content.world.block.CorundumBlock;
import org.violetmoon.zeta.block.IZetaBlock;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.RenderLayerRegistry;

public class CorundumClusterBlock
extends ZetaBlock
implements SimpleWaterloggedBlock {
    public final CorundumBlock base;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static VoxelShape northAabb;
    protected static VoxelShape southAabb;
    protected static VoxelShape eastAabb;
    protected static VoxelShape westAabb;
    protected static VoxelShape upAabb;
    protected static VoxelShape downAabb;

    public CorundumClusterBlock(CorundumBlock base) {
        super(Quark.ZETA.registryUtil.inheritQuark((IZetaBlock)base, "%s_cluster"), base.getModule(), BlockPropertyUtil.copyPropertySafe((Block)base).sound(SoundType.AMETHYST_CLUSTER));
        this.base = base;
        base.cluster = this;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.DOWN)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        ZetaModule module = base.getModule();
        if (module == null) {
            return;
        }
        module.zeta().renderLayerRegistry.put((Block)this, RenderLayerRegistry.Layer.CUTOUT);
        this.setCreativeTab(CreativeModeTabs.COLORED_BLOCKS);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction direction = (Direction)state.getValue(FACING);
        return switch (direction) {
            case Direction.NORTH -> northAabb;
            case Direction.SOUTH -> southAabb;
            case Direction.EAST -> eastAabb;
            case Direction.WEST -> westAabb;
            case Direction.DOWN -> downAabb;
            default -> upAabb;
        };
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        if (!this.canSurvive(state, (LevelReader)worldIn, pos)) {
            worldIn.destroyBlock(pos, true);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction dir = (Direction)state.getValue(FACING);
        BlockPos off = pos.relative(dir.getOpposite());
        BlockState offState = worldIn.getBlockState(off);
        return offState.isFaceSturdy((BlockGetter)worldIn, off, dir);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getClickedFace())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, pos, facingPos);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return type == PathComputationType.WATER && state.getFluidState().is(FluidTags.WATER);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    static {
        int yBound = 7;
        int xBound = 3;
        upAabb = Block.box((double)xBound, (double)0.0, (double)xBound, (double)(16 - xBound), (double)yBound, (double)(16 - xBound));
        downAabb = Block.box((double)xBound, (double)(16 - yBound), (double)xBound, (double)(16 - xBound), (double)16.0, (double)(16 - xBound));
        northAabb = Block.box((double)xBound, (double)xBound, (double)(16 - yBound), (double)(16 - xBound), (double)(16 - xBound), (double)16.0);
        southAabb = Block.box((double)xBound, (double)xBound, (double)0.0, (double)(16 - xBound), (double)(16 - xBound), (double)yBound);
        eastAabb = Block.box((double)0.0, (double)xBound, (double)xBound, (double)yBound, (double)(16 - xBound), (double)(16 - xBound));
        westAabb = Block.box((double)(16 - yBound), (double)xBound, (double)xBound, (double)16.0, (double)(16 - xBound), (double)(16 - xBound));
    }
}

