/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.client.emote;

import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.violetmoon.quark.content.tweaks.client.emote.EmoteBase;
import org.violetmoon.quark.content.tweaks.client.emote.EmoteHandler;
import org.violetmoon.quark.content.tweaks.client.emote.EmoteTemplate;

public class EmoteSound
extends AbstractSoundInstance
implements TickableSoundInstance {
    protected boolean donePlaying;
    private final WeakReference<Player> player;
    private final EmoteTemplate template;
    private final boolean endWithSequence;

    public static void add(List<EmoteSound> allSounds, List<EmoteSound> sounds, Player player, EmoteTemplate template, ResourceLocation soundEvent, float volume, float pitch, boolean repeating, boolean endWithSequence) {
        EmoteSound emoteSound = new EmoteSound(player, template, soundEvent, volume, pitch, repeating, endWithSequence);
        sounds.add(emoteSound);
        allSounds.add(emoteSound);
        Minecraft.getInstance().getSoundManager().play((SoundInstance)emoteSound);
    }

    public static void endAll(List<EmoteSound> sounds) {
        for (EmoteSound sound : sounds) {
            sound.donePlaying = true;
        }
    }

    public static void endSection(List<EmoteSound> sounds) {
        for (EmoteSound sound : sounds) {
            if (!sound.endWithSequence) continue;
            sound.donePlaying = true;
        }
    }

    public EmoteSound(Player player, EmoteTemplate template, ResourceLocation sound, float volume, float pitch, boolean repeating, boolean endWithSequence) {
        super(sound, SoundSource.PLAYERS, SoundInstance.createUnseededRandom());
        this.player = new WeakReference<Player>(player);
        this.template = template;
        this.endWithSequence = endWithSequence;
        this.volume = volume;
        this.pitch = pitch;
        if (repeating) {
            this.looping = true;
            this.delay = 0;
        }
    }

    public void tick() {
        Player player = (Player)this.player.get();
        if (player == null || !player.isAlive()) {
            this.donePlaying = true;
        } else {
            EmoteBase emote = EmoteHandler.getPlayerEmote(player);
            if (emote == null || emote.desc.template != this.template) {
                this.donePlaying = true;
            } else {
                Vec3 pos = player.position();
                this.x = (float)pos.x;
                this.y = (float)pos.y;
                this.z = (float)pos.z;
            }
        }
    }

    public boolean isStopped() {
        return this.donePlaying;
    }
}

