/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class MultiFoliageStraightTrunkPlacer
extends TrunkPlacer {
    final int foliageDistance;
    final int maxBlobs;
    public static final MapCodec<MultiFoliageStraightTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(overengineered -> MultiFoliageStraightTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)overengineered).and(overengineered.group((App)Codec.INT.fieldOf("foliageDistance").forGetter(x -> x.foliageDistance), (App)Codec.INT.fieldOf("maxBlobs").forGetter(x -> x.maxBlobs))).apply((Applicative)overengineered, MultiFoliageStraightTrunkPlacer::new));
    public static final TrunkPlacerType<MultiFoliageStraightTrunkPlacer> TYPE = new TrunkPlacerType(CODEC);

    public MultiFoliageStraightTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, int foliageDistance, int maxBlobs) {
        super(baseHeight, heightRandA, heightRandB);
        this.foliageDistance = foliageDistance;
        this.maxBlobs = maxBlobs;
    }

    protected TrunkPlacerType<?> type() {
        return TYPE;
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> placer, RandomSource random, int idk, BlockPos rootPos, TreeConfiguration cfg) {
        MultiFoliageStraightTrunkPlacer.setDirtAt((LevelSimulatedReader)level, placer, (RandomSource)random, (BlockPos)rootPos.below(), (TreeConfiguration)cfg);
        ArrayList<BlockPos> folliagePositions = new ArrayList<BlockPos>();
        int placed = 0;
        int j = 0;
        for (int i = idk; i >= 0; --i) {
            BlockPos target = rootPos.above(i);
            this.placeLog(level, placer, random, target, cfg);
            if (placed >= this.maxBlobs) continue;
            if (j == 0) {
                folliagePositions.add(target);
                j = this.foliageDistance;
                ++placed;
                continue;
            }
            --j;
        }
        return folliagePositions.stream().map(p -> new FoliagePlacer.FoliageAttachment(p, 0, false)).collect(Collectors.toList());
    }
}

