/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.building.block.HollowFrameBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.RenderLayerRegistry;
import org.violetmoon.zeta.util.MiscUtil;

public class HollowWoodBlock
extends HollowFrameBlock {
    protected static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    protected static final BooleanProperty UP = BlockStateProperties.UP;
    protected static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    protected static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    protected static final BooleanProperty WEST = BlockStateProperties.WEST;
    protected static final BooleanProperty EAST = BlockStateProperties.EAST;
    private final boolean flammable;

    public HollowWoodBlock(Block sourceLog, @Nullable ZetaModule module, boolean flammable) {
        this(Quark.ZETA.registryUtil.inherit(sourceLog, "hollow_%s"), sourceLog, module, flammable);
    }

    public HollowWoodBlock(String name, Block sourceLog, @Nullable ZetaModule module, boolean flammable) {
        super(name, module, MiscUtil.copyPropertySafe((BlockBehaviour)sourceLog).isSuffocating((s, g, p) -> false));
        this.flammable = flammable;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)DOWN, (Comparable)Boolean.valueOf(true))).setValue((Property)UP, (Comparable)Boolean.valueOf(true))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(true))).setValue((Property)WEST, (Comparable)Boolean.valueOf(true))).setValue((Property)EAST, (Comparable)Boolean.valueOf(true)));
        if (module == null) {
            return;
        }
        module.zeta().renderLayerRegistry.put((Block)this, RenderLayerRegistry.Layer.CUTOUT_MIPPED);
    }

    @Override
    public byte getShapeCode(BlockState state) {
        return HollowWoodBlock.shapeCode(state, DOWN, UP, NORTH, SOUTH, WEST, EAST);
    }

    public BlockState rotate(BlockState state, Rotation direction) {
        BlockState newState = state;
        for (Direction dir : Direction.values()) {
            newState = (BlockState)newState.setValue((Property)MiscUtil.directionProperty((Direction)dir), (Comparable)((Boolean)state.getValue((Property)MiscUtil.directionProperty((Direction)direction.rotate(dir)))));
        }
        return newState;
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirror) {
        BlockState newState = state;
        for (Direction dir : Direction.values()) {
            newState = (BlockState)newState.setValue((Property)MiscUtil.directionProperty((Direction)dir), (Comparable)((Boolean)state.getValue((Property)MiscUtil.directionProperty((Direction)mirror.mirror(dir)))));
        }
        return newState;
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility itemAbility, boolean simulate) {
        if ("axe_strip".equals(String.valueOf(itemAbility))) {
            Vec3 exactPos = context.getClickLocation();
            BlockPos centerPos = context.getClickedPos();
            Direction face = Direction.getNearest((double)(exactPos.x - ((double)centerPos.getX() + 0.5)), (double)(exactPos.y - ((double)centerPos.getY() + 0.5)), (double)(exactPos.z - ((double)centerPos.getZ() + 0.5)));
            return (BlockState)state.cycle((Property)MiscUtil.directionProperty((Direction)face));
        }
        return super.getToolModifiedStateZeta(state, context, ItemAbility.get((String)String.valueOf(itemAbility)), simulate);
    }

    @Override
    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> def) {
        super.createBlockStateDefinition(def);
        def.add(new Property[]{UP, DOWN, NORTH, SOUTH, WEST, EAST});
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.flammable;
    }
}

