/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.ai;

import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import org.violetmoon.quark.content.mobs.entity.Shiba;

public class DeliverFetchedItemGoal
extends FollowOwnerGoal {
    private final Shiba shiba;
    private int timeTilNextJump = 20;

    public DeliverFetchedItemGoal(Shiba shiba, double speed, float minDist, float maxDist) {
        super((TamableAnimal)shiba, speed, minDist, maxDist);
        this.shiba = shiba;
    }

    public void tick() {
        super.tick();
        --this.timeTilNextJump;
        if (this.timeTilNextJump <= 0) {
            this.timeTilNextJump = this.shiba.level().random.nextInt(5) + 10;
            if (this.shiba.onGround()) {
                this.shiba.push(0.0, 0.3, 0.0);
                this.shiba.setJumping(true);
            }
        }
    }

    public boolean canUse() {
        return super.canUse() && !this.shiba.getMouthItem().isEmpty();
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && !this.shiba.getMouthItem().isEmpty();
    }
}

