/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.content.building.entity.Stool;
import org.violetmoon.quark.content.building.module.StoolsModule;
import org.violetmoon.zeta.block.OldMaterials;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;

public class StoolBlock
extends ZetaBlock
implements SimpleWaterloggedBlock {
    private static final VoxelShape SHAPE_TOP = Block.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    private static final VoxelShape SHAPE_LEG = Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)1.0, (double)4.0);
    private static final VoxelShape SHAPE_TOP_BIG = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_LEG_BIG = Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)8.0, (double)4.0);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)SHAPE_TOP, (VoxelShape[])new VoxelShape[]{SHAPE_LEG, SHAPE_LEG.move(0.75, 0.0, 0.0), SHAPE_LEG.move(0.75, 0.0, 0.75), SHAPE_LEG.move(0.0, 0.0, 0.75)});
    private static final VoxelShape SHAPE_BIG = Shapes.or((VoxelShape)SHAPE_TOP_BIG, (VoxelShape[])new VoxelShape[]{SHAPE_LEG_BIG, SHAPE_LEG_BIG.move(0.75, 0.0, 0.0), SHAPE_LEG_BIG.move(0.75, 0.0, 0.75), SHAPE_LEG_BIG.move(0.0, 0.0, 0.75)});
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty BIG = BooleanProperty.create((String)"big");
    public static final BooleanProperty SAT_IN = BooleanProperty.create((String)"sat_in");

    public StoolBlock(@Nullable ZetaModule module, DyeColor color) {
        super(color.getName() + "_stool", module, OldMaterials.wool().mapColor(color.getMapColor()).sound(SoundType.WOOD).strength(0.2f).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)BIG, (Comparable)Boolean.valueOf(false))).setValue((Property)SAT_IN, (Comparable)Boolean.valueOf(false)));
        if (module == null) {
            return;
        }
        this.setCreativeTab(CreativeModeTabs.COLORED_BLOCKS, (ItemLike)Blocks.PINK_BED, false);
    }

    public void blockClicked(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        if (!((Boolean)state.getValue((Property)BIG)).booleanValue()) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BIG, (Comparable)Boolean.valueOf(true)));
            world.scheduleTick(pos, (Block)this, 1);
        }
    }

    public void tick(@NotNull BlockState state, @NotNull ServerLevel worldIn, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        this.fixState((Level)worldIn, pos, state);
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (((Boolean)state.getValue((Property)SAT_IN)).booleanValue() || !worldIn.getBlockState(pos.above()).isAir() || player.getVehicle() != null) {
            return super.useWithoutItem(state, worldIn, pos, player, hit);
        }
        if (!worldIn.isClientSide) {
            Stool entity = new Stool(StoolsModule.stoolEntity, worldIn);
            entity.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.6, (double)pos.getZ() + 0.5);
            worldIn.addFreshEntity((Entity)entity);
            player.startRiding((Entity)entity);
            worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)SAT_IN, (Comparable)Boolean.valueOf(true)));
        }
        return InteractionResult.sidedSuccess((boolean)worldIn.isClientSide);
    }

    public void fallOn(@NotNull Level worldIn, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull Entity entityIn, float fallDistance) {
        super.fallOn(worldIn, state, pos, entityIn, fallDistance * 0.5f);
    }

    public void updateEntityAfterFallOn(@NotNull BlockGetter worldIn, Entity entityIn) {
        if (entityIn.isSuppressingBounce()) {
            super.updateEntityAfterFallOn(worldIn, entityIn);
        } else {
            this.bounceEntity(entityIn);
        }
    }

    private void bounceEntity(Entity entity) {
        Vec3 vector3d = entity.getDeltaMovement();
        if (vector3d.y < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.setDeltaMovement(vector3d.x, -vector3d.y * (double)0.66f * d0, vector3d.z);
        }
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return (Boolean)state.getValue((Property)BIG) != false ? SHAPE_BIG : SHAPE;
    }

    public boolean propagatesSkylightDown(BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getStateFor(context.getLevel(), context.getClickedPos());
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, pos, facingPos);
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, worldIn, pos, blockIn, fromPos, isMoving);
        this.fixState(worldIn, pos, state);
    }

    private void fixState(Level worldIn, BlockPos pos, BlockState state) {
        BlockState target = this.getStateFor(worldIn, pos);
        if (!target.equals(state)) {
            worldIn.setBlockAndUpdate(pos, target);
        }
    }

    private BlockState getStateFor(Level world, BlockPos pos) {
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos).getType() == Fluids.WATER))).setValue((Property)BIG, (Comparable)Boolean.valueOf(world.getBlockState(pos.above()).getShape((BlockGetter)world, pos.above()).min(Direction.Axis.Y) == 0.0))).setValue((Property)SAT_IN, (Comparable)Boolean.valueOf(!world.getEntitiesOfClass(Stool.class, new AABB(new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), new Vec3((double)pos.above().getX(), (double)pos.above().getY(), (double)pos.above().getZ())).inflate(0.4), e -> e.blockPosition().equals((Object)pos)).isEmpty()));
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, @NotNull Level worldIn, @NotNull BlockPos pos) {
        return (Boolean)blockState.getValue((Property)SAT_IN) != false ? 15 : 0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, BIG, SAT_IN});
    }
}

