/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.client.module;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.recipebook.GhostRecipe;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookPage;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.violetmoon.quark.base.client.handler.ClientUtil;
import org.violetmoon.zeta.client.event.play.ZClientTick;
import org.violetmoon.zeta.client.event.play.ZRenderContainerScreen;
import org.violetmoon.zeta.client.event.play.ZScreen;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="client")
public class MicrocraftingHelperModule
extends ZetaModule {

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends MicrocraftingHelperModule {
        private static Screen currentScreen;
        private static RecipeHolder<?> currentRecipe;
        private static final Stack<StackedRecipe> recipes;
        private static int compoundCount;

        @PlayEvent
        public void onClick(ZScreen.MouseButtonPressed.Pre event) {
            Screen screen = event.getScreen();
            if (screen instanceof CraftingScreen) {
                RecipeBookComponent recipeBook;
                Pair<GhostRecipe, GhostRecipe.GhostIngredient> pair;
                CraftingScreen cscreen = (CraftingScreen)screen;
                if (event.getButton() == 1 && (pair = this.getHoveredGhost((AbstractContainerScreen<?>)cscreen, recipeBook = cscreen.getRecipeBookComponent())) != null) {
                    GhostRecipe ghost = (GhostRecipe)pair.getLeft();
                    GhostRecipe.GhostIngredient ghostIngr = (GhostRecipe.GhostIngredient)pair.getRight();
                    Ingredient ingr = ghostIngr.ingredient;
                    Minecraft mc = screen.getMinecraft();
                    RegistryAccess registryAccess = mc.level.registryAccess();
                    RecipeHolder<?> recipeToSet = this.getRecipeToSet(recipeBook, ingr, true, registryAccess);
                    if (recipeToSet == null) {
                        recipeToSet = this.getRecipeToSet(recipeBook, ingr, false, registryAccess);
                    }
                    if (recipeToSet != null) {
                        int ourCount = 0;
                        ItemStack testStack = recipeToSet.value().getResultItem((HolderLookup.Provider)registryAccess);
                        for (int j = 1; j < ghost.size(); ++j) {
                            GhostRecipe.GhostIngredient testGhostIngr = ghost.get(j);
                            Ingredient testIngr = testGhostIngr.ingredient;
                            if (!testIngr.test(testStack)) continue;
                            ++ourCount;
                        }
                        if (ourCount > 0) {
                            int prevCount = compoundCount;
                            int reqCount = ourCount * prevCount;
                            int mult = (int)Math.ceil((double)ourCount / (double)testStack.getCount());
                            RecipeHolder ghostRecipe = ghost.getRecipe();
                            StackedRecipe stackedRecipe = new StackedRecipe(ghostRecipe, testStack, compoundCount *= mult, this.getClearCondition(ingr, reqCount));
                            boolean stackIt = true;
                            if (recipes.isEmpty()) {
                                ItemStack rootDisplayStack = ghostRecipe.value().getResultItem((HolderLookup.Provider)registryAccess);
                                StackedRecipe rootRecipe = new StackedRecipe(null, rootDisplayStack, rootDisplayStack.getCount(), () -> recipes.size() == 1);
                                recipes.add(rootRecipe);
                            } else {
                                for (int i = 0; i < recipes.size(); ++i) {
                                    StackedRecipe currRecipe = (StackedRecipe)recipes.get(recipes.size() - i - 1);
                                    if (currRecipe.recipe != recipeToSet) continue;
                                    for (int j = 0; j <= i; ++j) {
                                        recipes.pop();
                                    }
                                    stackIt = false;
                                    compoundCount = currRecipe.count;
                                    break;
                                }
                            }
                            if (stackIt) {
                                recipes.add(stackedRecipe);
                            }
                        }
                        ghost.clear();
                        mc.gameMode.handlePlaceRecipe(mc.player.containerMenu.containerId, recipeToSet, true);
                        currentRecipe = recipeToSet;
                    }
                    event.setCanceled(true);
                }
            }
        }

        @PlayEvent
        public void onDrawGui(ZRenderContainerScreen.Background event) {
            Minecraft mc = Minecraft.getInstance();
            Screen screen = mc.screen;
            if (screen instanceof CraftingScreen) {
                GhostRecipe.GhostIngredient ingr;
                Pair<GhostRecipe, GhostRecipe.GhostIngredient> pair;
                CraftingScreen cscreen = (CraftingScreen)screen;
                GuiGraphics guiGraphics = event.getGuiGraphics();
                PoseStack mstack = guiGraphics.pose();
                int left = cscreen.getGuiLeft() + 95;
                int top = cscreen.getGuiTop() + 6;
                if (!recipes.isEmpty()) {
                    int start;
                    RenderSystem.setShader(GameRenderer::getPositionTexShader);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    mstack.pushPose();
                    guiGraphics.blit(ClientUtil.GENERAL_ICONS, left, top, 0, 0.0f, 108.0f, 80, 20, 256, 256);
                    mstack.popPose();
                    for (int i = start = Math.max(0, recipes.size() - 3); i < recipes.size(); ++i) {
                        int index = i - start;
                        StackedRecipe recipe = (StackedRecipe)recipes.get(i);
                        int x = left + index * 24 + 2;
                        int y = top + 2;
                        ItemStack drawStack = recipe.displayItem;
                        guiGraphics.renderItem(drawStack, x, y);
                        guiGraphics.renderItemDecorations(mc.font, drawStack, x, y);
                        if (index <= 0) continue;
                        guiGraphics.drawString(mc.font, "<", x - 6, y + 4, 0x3F3F3F, false);
                    }
                }
                if ((pair = this.getHoveredGhost((AbstractContainerScreen<?>)cscreen, cscreen.getRecipeBookComponent())) != null && (ingr = (GhostRecipe.GhostIngredient)pair.getRight()) != null) {
                    currentScreen.setTooltipForNextRenderPass(Tooltip.create((Component)Component.translatable((String)"quark.misc.rightclick_to_craft")), (ClientTooltipPositioner)AboveCursorPositioner.INSTANCE, false);
                }
            }
        }

        @PlayEvent
        public void onTick(ZClientTick.Start event) {
            Minecraft mc = Minecraft.getInstance();
            Screen prevScreen = currentScreen;
            currentScreen = mc.screen;
            boolean clearCompound = true;
            if (prevScreen != currentScreen) {
                recipes.clear();
                currentRecipe = null;
            }
            if (!recipes.isEmpty()) {
                Screen screen = currentScreen;
                if (screen instanceof CraftingScreen) {
                    CraftingScreen crafting = (CraftingScreen)screen;
                    RecipeBookComponent book = crafting.getRecipeBookComponent();
                    GhostRecipe ghost = book.ghostRecipe;
                    if (currentRecipe != null && ghost.getRecipe() != null && ghost.getRecipe() != currentRecipe) {
                        recipes.clear();
                        currentRecipe = null;
                    }
                }
                if (!recipes.isEmpty()) {
                    StackedRecipe top = recipes.peek();
                    if (top.clearCondition.getAsBoolean()) {
                        if (top.recipe != null) {
                            mc.gameMode.handlePlaceRecipe(mc.player.containerMenu.containerId, top.recipe, true);
                            currentRecipe = top.recipe;
                            compoundCount = top.count;
                        }
                        recipes.pop();
                    }
                    clearCompound = false;
                }
            }
            if (clearCompound) {
                compoundCount = 1;
            }
        }

        private RecipeHolder<?> getRecipeToSet(RecipeBookComponent recipeBook, Ingredient ingr, boolean craftableOnly, RegistryAccess registryAccess) {
            EditBox text = recipeBook.searchBox;
            for (ItemStack stack : ingr.getItems()) {
                String itemName = stack.getHoverName().copy().getString().toLowerCase(Locale.ROOT).trim();
                text.setValue(itemName);
                recipeBook.checkSearchStringUpdate();
                RecipeBookPage page = recipeBook.recipeBookPage;
                ArrayList<RecipeCollection> recipeLists = page.recipeCollections;
                recipeLists = new ArrayList<RecipeCollection>(recipeLists);
                if (recipeLists.isEmpty()) continue;
                recipeLists.removeIf(rl -> {
                    List list = rl.getDisplayRecipes(craftableOnly);
                    return list.isEmpty();
                });
                if (recipeLists.isEmpty()) {
                    return null;
                }
                recipeLists.sort((rl1, rl2) -> {
                    if (rl1 == rl2) {
                        return 0;
                    }
                    RecipeHolder r1 = (RecipeHolder)rl1.getDisplayRecipes(craftableOnly).get(0);
                    RecipeHolder r2 = (RecipeHolder)rl2.getDisplayRecipes(craftableOnly).get(0);
                    return this.compareRecipes(r1, r2);
                });
                for (RecipeCollection list : recipeLists) {
                    List recipeList = list.getDisplayRecipes(craftableOnly);
                    recipeList.sort(this::compareRecipes);
                    for (RecipeHolder recipe : recipeList) {
                        if (!ingr.test(recipe.value().getResultItem((HolderLookup.Provider)registryAccess))) continue;
                        return recipe;
                    }
                }
            }
            return null;
        }

        private int compareRecipes(RecipeHolder<?> r1, RecipeHolder<?> r2) {
            boolean id2Mc;
            if (r1 == r2) {
                return 0;
            }
            String id1 = r1.id().toString();
            String id2 = r2.id().toString();
            boolean id1Mc = id1.startsWith("minecraft");
            if (id1Mc != (id2Mc = id2.startsWith("minecraft"))) {
                return id1Mc ? -1 : 1;
            }
            return id1.compareTo(id2);
        }

        private BooleanSupplier getClearCondition(Ingredient ingr, int req) {
            Minecraft mc = Minecraft.getInstance();
            return () -> {
                int missing = req;
                for (ItemStack invStack : mc.player.getInventory().items) {
                    if (!ingr.test(invStack) || (missing -= invStack.getCount()) > 0) continue;
                    return true;
                }
                return false;
            };
        }

        private Pair<GhostRecipe, GhostRecipe.GhostIngredient> getHoveredGhost(AbstractContainerScreen<?> cscreen, RecipeBookComponent recipeBook) {
            GhostRecipe ghost;
            Slot slot = cscreen.getSlotUnderMouse();
            if (recipeBook != null && slot != null && (ghost = recipeBook.ghostRecipe).getRecipe() != null) {
                for (int i = 1; i < ghost.size(); ++i) {
                    GhostRecipe.GhostIngredient ghostIngr = ghost.get(i);
                    if (ghostIngr.getX() != slot.x || ghostIngr.getY() != slot.y) continue;
                    return Pair.of((Object)ghost, (Object)ghostIngr);
                }
            }
            return null;
        }

        static {
            recipes = new Stack();
            compoundCount = 1;
        }

        private record StackedRecipe(RecipeHolder<?> recipe, ItemStack displayItem, int count, BooleanSupplier clearCondition) {
            private StackedRecipe(RecipeHolder<?> recipe, ItemStack displayItem, int count, BooleanSupplier clearCondition) {
                this.recipe = recipe;
                this.count = count;
                this.clearCondition = clearCondition;
                this.displayItem = displayItem.copy();
                this.displayItem.setCount(count);
            }
        }

        private static class AboveCursorPositioner
        implements ClientTooltipPositioner {
            private static final AboveCursorPositioner INSTANCE = new AboveCursorPositioner();

            private AboveCursorPositioner() {
            }

            public Vector2ic positionTooltip(int pScreenWidth, int pScreenHeight, int pMouseX, int pMouseY, int pTooltipWidth, int pTooltipHeight) {
                Vector2i vector2i = new Vector2i(pMouseX, pMouseY).add(12, -29);
                this.positionTooltip(pScreenWidth, pScreenHeight, vector2i, pTooltipWidth, pTooltipHeight);
                return vector2i;
            }

            private void positionTooltip(int pScreenWidth, int pScreenHeight, Vector2i pTooltipPos, int pTooltipWidth, int pTooltipHeight) {
                int i;
                if (pTooltipPos.x + pTooltipWidth > pScreenWidth) {
                    pTooltipPos.x = Math.max(pTooltipPos.x - 24 - pTooltipWidth, 4);
                }
                if (pTooltipPos.y + (i = pTooltipHeight + 3) > pScreenHeight) {
                    pTooltipPos.y = pScreenHeight - i;
                }
            }
        }
    }
}

