/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import org.violetmoon.quark.content.mobs.entity.Wraith;

public class WraithModel
extends EntityModel<Wraith> {
    public final ModelPart main;
    public final ModelPart body;
    public final ModelPart arms;
    private double offset;
    private float alphaMult;

    public WraithModel(ModelPart root) {
        super(RenderType::entityTranslucent);
        this.main = root.getChild("main");
        this.body = this.main.getChild("body");
        this.arms = this.main.getChild("arms");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition main = root.addOrReplaceChild("main", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        main.addOrReplaceChild("arms", CubeListBuilder.create().texOffs(36, 6).addBox(-8.5f, 1.0f, -2.0f, 3.0f, 15.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 55).addBox(-5.5f, 12.0f, 0.0f, 11.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(47, 3).addBox(-8.5f, 11.0f, -2.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.25f)).texOffs(36, 6).mirror().addBox(5.5f, 1.0f, -2.0f, 3.0f, 15.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(47, 3).mirror().addBox(5.5f, 11.0f, -2.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.25f)).mirror(false), PartPose.offset((float)0.0f, (float)-17.0f, (float)-1.0f));
        main.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.5f, -10.0f, -4.0f, 11.0f, 26.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-18.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void setupAnim(Wraith entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        Random rng = new Random(entity.getId());
        int offset1 = rng.nextInt(10000000);
        int offset2 = rng.nextInt(6000000);
        int offset3 = rng.nextInt(8000000);
        float time = ageInTicks + (float)offset1;
        float time2 = ageInTicks + (float)offset2;
        float time3 = ageInTicks + (float)offset3;
        this.main.xRot = (float)Math.sin(time / 16.0f) * 0.1f - 0.3f;
        this.main.yRot = (float)Math.sin(time2 / 20.0f) * 0.12f;
        this.main.zRot = (float)Math.sin(time3 / 12.0f) * 0.07f;
        this.arms.xRot = (float)Math.sin(time2 / 22.0f) * 0.15f;
        this.offset = Math.sin(time / 16.0f) * 0.1 - 0.25;
        this.alphaMult = 0.8f + (float)Math.sin(time2 / 20.0f) * 0.2f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer bufferIn, int packedLight, int packedOverlay, int color) {
        poseStack.pushPose();
        poseStack.translate(0.0, this.offset, -0.1);
        this.main.render(poseStack, bufferIn, packedLight, packedOverlay, color);
        poseStack.popPose();
    }
}

