/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.experimental.item;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.experimental.module.VariantSelectorModule;
import org.violetmoon.quark.content.tweaks.module.LockRotationModule;
import org.violetmoon.zeta.item.ZetaItem;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;

public class HammerItem
extends ZetaItem {
    public HammerItem(ZetaModule module) {
        super("hammer", module, new Item.Properties().stacksTo(1));
        CreativeTabManager.addToTab((ResourceKey)CreativeModeTabs.TOOLS_AND_UTILITIES, (ItemLike)this);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        String variant;
        Block variantBlock;
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (player != null && (variantBlock = VariantSelectorModule.getVariantBlockFromAny(block, variant = VariantSelectorModule.getSavedVariant(player))) != null) {
            level.removeBlock(pos, false);
            YungsBetterBlockPlaceContext bpc = new YungsBetterBlockPlaceContext(context);
            BlockState place = variantBlock.getStateForPlacement((BlockPlaceContext)bpc);
            place = LockRotationModule.fixBlockRotation(place, bpc);
            if (place != null && !place.equals(state) && !level.isClientSide) {
                level.removeBlock(pos, false);
                level.setBlock(pos, place, 3);
                player.swing(context.getHand());
                level.playSound(null, pos, place.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                level.setBlock(pos, state, 0);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    private static class YungsBetterBlockPlaceContext
    extends BlockPlaceContext {
        public YungsBetterBlockPlaceContext(UseOnContext ctx) {
            super(ctx);
        }

        @NotNull
        public BlockPos getClickedPos() {
            boolean oldRepl = this.replaceClicked;
            this.replaceClicked = true;
            BlockPos pos = super.getClickedPos();
            this.replaceClicked = oldRepl;
            return pos;
        }
    }
}

