/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;

public class BambooMatBlock
extends ZetaBlock {
    private static final EnumProperty<Direction> FACING = BlockStateProperties.FACING_HOPPER;

    public BambooMatBlock(String name, @Nullable ZetaModule module) {
        this(name, module, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS);
    }

    public BambooMatBlock(String name, @Nullable ZetaModule module, ResourceKey<CreativeModeTab> tab) {
        super(name, module, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).forceSolidOn().strength(0.5f).sound(SoundType.BAMBOO).ignitedByLava().pushReaction(PushReaction.DESTROY).isRedstoneConductor((s, r, p) -> false));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.NORTH));
        if (module == null) {
            return;
        }
        this.setCreativeTab(tab);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction dir = ctx.getHorizontalDirection();
        if (ctx.getPlayer().getXRot() > 70.0f) {
            dir = Direction.DOWN;
        }
        if (dir != Direction.DOWN) {
            Direction opposite = dir.getOpposite();
            BlockPos target = ctx.getClickedPos().relative(opposite);
            BlockState state = ctx.getLevel().getBlockState(target);
            if (state.getBlock() != this || state.getValue(FACING) != opposite) {
                target = ctx.getClickedPos().relative(dir);
                state = ctx.getLevel().getBlockState(target);
                if (state.getBlock() == this && state.getValue(FACING) == dir) {
                    dir = opposite;
                }
            }
        }
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)dir);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }
}

