/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.zeta.client.event.play.ZInputUpdate;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.load.ZGatherHints;
import org.violetmoon.zeta.event.play.entity.player.ZPlayerTick;
import org.violetmoon.zeta.event.play.entity.player.ZRightClickBlock;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.RegistryUtil;

@ZetaLoadModule(category="tweaks")
public class EnhancedLaddersModule
extends ZetaModule {
    @Config.Max(value=0.0)
    @Config
    public double fallSpeed = -0.2;
    @Config
    public static boolean allowFreestanding = true;
    @Config
    public static boolean allowDroppingDown = true;
    @Config
    public static boolean allowSliding = true;
    @Config
    public static boolean allowInventorySneak = true;
    public static boolean staticEnabled;
    private static TagKey<Item> laddersTag;
    private static TagKey<Block> laddersBlockTag;
    private static final DirectionProperty FACING;

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        laddersTag = Quark.asTagKey(Registries.ITEM, "ladders");
        laddersBlockTag = Quark.asTagKey(Registries.BLOCK, "ladders");
    }

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        staticEnabled = this.isEnabled();
    }

    @LoadEvent
    public void addAdditionalHints(ZGatherHints event) {
        if (!(allowFreestanding || allowDroppingDown || allowSliding || allowInventorySneak)) {
            return;
        }
        MutableComponent comp = Component.empty();
        String pad = "";
        if (allowDroppingDown) {
            comp = comp.append(pad).append((Component)Component.translatable((String)"quark.jei.hint.ladder_dropping"));
            pad = " ";
        }
        if (allowFreestanding) {
            comp = comp.append(pad).append((Component)Component.translatable((String)"quark.jei.hint.ladder_freestanding"));
            pad = " ";
        }
        if (allowSliding) {
            comp = comp.append(pad).append((Component)Component.translatable((String)"quark.jei.hint.ladder_sliding"));
            pad = " ";
        }
        if (allowInventorySneak) {
            comp = comp.append(pad).append((Component)Component.translatable((String)"quark.jei.hint.ladder_sneak"));
        }
        List ladders = RegistryUtil.getTagValues((RegistryAccess)event.getRegistryAccess(), laddersTag);
        for (Item item : ladders) {
            event.accept((ItemLike)item, (Component)comp);
        }
    }

    public static boolean canSurviveTweak(boolean vanillaSurvive, BlockState state, LevelReader world, BlockPos pos) {
        if (vanillaSurvive && !world.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite())).is(laddersBlockTag)) {
            return true;
        }
        if (!(staticEnabled && allowFreestanding && state.is(laddersBlockTag) && state.hasProperty((Property)FACING))) {
            return false;
        }
        BlockState aboveState = world.getBlockState(pos.above());
        return aboveState.is(laddersBlockTag) && aboveState.hasProperty((Property)FACING) && aboveState.getValue((Property)FACING) == state.getValue((Property)FACING);
    }

    public static boolean shouldDoUpdateShapeTweak(BlockState state) {
        return staticEnabled && allowFreestanding && state.is(laddersBlockTag);
    }

    @PlayEvent
    public void onInteract(ZRightClickBlock event) {
        InteractionHand hand;
        if (!allowDroppingDown) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack stack = player.getItemInHand(hand = event.getHand());
        if (!stack.isEmpty() && stack.is(laddersTag)) {
            Block block = Block.byItem((Item)stack.getItem());
            Level world = event.getLevel();
            BlockPos pos = event.getPos();
            while (world.getBlockState(pos).getBlock() == block) {
                BlockState copyState;
                boolean water;
                event.setCanceled(true);
                BlockPos posDown = pos.below();
                if (world.isOutsideBuildHeight(posDown)) break;
                BlockState stateDown = world.getBlockState(posDown);
                if (stateDown.getBlock() == block) {
                    pos = posDown;
                    continue;
                }
                boolean bl = water = stateDown.getBlock() == Blocks.WATER;
                if (!water && !stateDown.isAir() || !(copyState = world.getBlockState(pos)).canSurvive((LevelReader)world, posDown)) break;
                world.setBlockAndUpdate(posDown, (BlockState)copyState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(water)));
                world.playSound(null, (double)posDown.getX(), (double)posDown.getY(), (double)posDown.getZ(), SoundEvents.LADDER_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                    if (stack.getCount() <= 0) {
                        player.setItemInHand(hand, ItemStack.EMPTY);
                    }
                }
                event.setCancellationResult(InteractionResult.sidedSuccess((boolean)world.isClientSide));
                break;
            }
        }
    }

    protected boolean isScaffolding(BlockState state, LivingEntity entity) {
        return this.zeta().blockExtensions.get(state).isScaffoldingZeta(state, (LevelReader)entity.level(), entity.blockPosition(), entity);
    }

    static {
        FACING = LadderBlock.FACING;
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends EnhancedLaddersModule {
        @PlayEvent
        public void onInput(ZInputUpdate event) {
            Input input;
            if (!allowInventorySneak) {
                return;
            }
            Player player = event.getEntity();
            if (!(!player.onClimbable() || player.getAbilities().flying || this.isScaffolding(player.level().getBlockState(player.blockPosition()), (LivingEntity)player) || Minecraft.getInstance().screen == null || player.zza == 0.0f && player.getXRot() > 70.0f || player.onGround() || (input = event.getInput()) == null)) {
                input.shiftKeyDown = true;
            }
        }

        @PlayEvent
        public void onPlayerTick(ZPlayerTick.Start event) {
            if (!allowSliding) {
                return;
            }
            Player player = event.getPlayer();
            if (player.onClimbable() && player.level().isClientSide) {
                BlockPos playerPos = player.blockPosition();
                BlockPos downPos = playerPos.below();
                boolean scaffold = this.isScaffolding(player.level().getBlockState(playerPos), (LivingEntity)player);
                if (player.isCrouching() == scaffold && player.zza == 0.0f && player.yya <= 0.0f && player.xxa == 0.0f && player.getXRot() > 70.0f && !player.jumping && !player.getAbilities().flying && player.level().getBlockState(downPos).isLadder((LevelReader)player.level(), downPos, (LivingEntity)player)) {
                    Vec3 move = new Vec3(0.0, this.fallSpeed, 0.0);
                    AABB target = player.getBoundingBox().move(move);
                    Iterable collisions = player.level().getBlockCollisions((Entity)player, target);
                    if (!collisions.iterator().hasNext()) {
                        player.setBoundingBox(target);
                        player.move(MoverType.SELF, move);
                    }
                }
            }
        }
    }
}

