/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.ai;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.BooleanSupplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.violetmoon.quark.base.util.MutableVectorHolder;
import org.violetmoon.quark.content.mobs.entity.Stoneling;

public class ActWaryGoal
extends WaterAvoidingRandomStrollGoal {
    private final Stoneling stoneling;
    private final BooleanSupplier scaredBySuddenMovement;
    private final double range;
    private boolean startled;
    private final Map<Player, MutableVectorHolder> lastPositions = new WeakHashMap<Player, MutableVectorHolder>();
    private final Map<Player, MutableVectorHolder> lastSpeeds = new WeakHashMap<Player, MutableVectorHolder>();

    public ActWaryGoal(Stoneling stoneling, double speed, double range, BooleanSupplier scaredBySuddenMovement) {
        super((PathfinderMob)stoneling, speed, 1.0f);
        this.stoneling = stoneling;
        this.range = range;
        this.scaredBySuddenMovement = scaredBySuddenMovement;
    }

    private static void updateMotion(MutableVectorHolder holder, double x, double y, double z) {
        holder.x = x;
        holder.y = y;
        holder.z = z;
    }

    private static void updatePos(MutableVectorHolder holder, Entity entity) {
        Vec3 pos = entity.position();
        holder.x = pos.x;
        holder.y = pos.y;
        holder.z = pos.z;
    }

    private static MutableVectorHolder initPos(Player p) {
        MutableVectorHolder holder = new MutableVectorHolder();
        ActWaryGoal.updatePos(holder, (Entity)p);
        return holder;
    }

    public void startle() {
        this.startled = true;
    }

    public boolean isStartled() {
        return this.startled;
    }

    protected boolean shouldApplyPath() {
        return super.canUse();
    }

    public void tick() {
        if (this.stoneling.getNavigation().isDone() && this.shouldApplyPath()) {
            this.start();
        }
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public void stop() {
        this.stoneling.getNavigation().stop();
    }

    public boolean canUse() {
        if (this.startled || this.stoneling.isPlayerMade()) {
            return false;
        }
        List playersAround = this.stoneling.level().getEntitiesOfClass(Player.class, this.stoneling.getBoundingBox().inflate(this.range), player -> player != null && !player.getAbilities().instabuild && player.distanceToSqr((Entity)this.stoneling) < this.range * this.range);
        if (playersAround.isEmpty()) {
            return false;
        }
        for (Player player2 : playersAround) {
            if (player2.isDiscrete()) {
                if (!this.scaredBySuddenMovement.getAsBoolean()) continue;
                MutableVectorHolder lastSpeed = this.lastSpeeds.computeIfAbsent(player2, p -> new MutableVectorHolder());
                MutableVectorHolder lastPos = this.lastPositions.computeIfAbsent(player2, ActWaryGoal::initPos);
                Vec3 pos = player2.position();
                double dX = pos.x - lastPos.x;
                double dY = pos.y - lastPos.y;
                double dZ = pos.z - lastPos.z;
                double xDisplacement = dX - lastSpeed.x;
                double yDisplacement = dY - lastSpeed.y;
                double zDisplacement = dZ - lastSpeed.z;
                ActWaryGoal.updateMotion(lastSpeed, dX, dY, dZ);
                ActWaryGoal.updatePos(lastPos, (Entity)player2);
                double displacementSq = xDisplacement * xDisplacement + yDisplacement * yDisplacement + zDisplacement * zDisplacement;
                if (displacementSq < 0.01) {
                    return true;
                }
                this.startled = true;
                return false;
            }
            this.startled = true;
            return false;
        }
        return true;
    }
}

