/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.entity;

import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.handler.QuarkSounds;
import org.violetmoon.quark.content.mobs.ai.BarkAtDarknessGoal;
import org.violetmoon.quark.content.mobs.ai.DeliverFetchedItemGoal;
import org.violetmoon.quark.content.mobs.ai.FetchArrowGoal;
import org.violetmoon.quark.content.mobs.module.ShibaModule;
import org.violetmoon.quark.content.tweaks.ai.NuzzleGoal;
import org.violetmoon.quark.content.tweaks.ai.WantLoveGoal;

public class Shiba
extends TamableAnimal {
    private static final EntityDataAccessor<Integer> COLLAR_COLOR = SynchedEntityData.defineId(Shiba.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<ItemStack> MOUTH_ITEM = SynchedEntityData.defineId(Shiba.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Integer> FETCHING = SynchedEntityData.defineId(Shiba.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public BlockPos currentHyperfocus = null;
    private int hyperfocusCooldown = 0;

    public Shiba(EntityType<? extends Shiba> type, Level worldIn) {
        super(type, worldIn);
        this.setTame(false, false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(3, (Goal)new BarkAtDarknessGoal(this));
        this.goalSelector.addGoal(4, (Goal)new FetchArrowGoal(this));
        this.goalSelector.addGoal(5, (Goal)new DeliverFetchedItemGoal(this, 1.1, -1.0f, 32.0f));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(7, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.BONE}), false));
        this.goalSelector.addGoal(8, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(9, (Goal)new NuzzleGoal(this, 0.5, 16.0f, 2.0f, QuarkSounds.ENTITY_SHIBA_WHINE));
        this.goalSelector.addGoal(10, (Goal)new WantLoveGoal(this, 0.2f));
        this.goalSelector.addGoal(11, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(12, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(13, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void tick() {
        LivingEntity owner;
        super.tick();
        AbstractArrow fetching = this.getFetching();
        if (fetching != null && (this.isSleeping() || fetching.level() != this.level() || !fetching.isAlive() || fetching.pickup == AbstractArrow.Pickup.DISALLOWED)) {
            this.setFetching(null);
        }
        if (!this.level().isClientSide) {
            if (this.hyperfocusCooldown > 0) {
                --this.hyperfocusCooldown;
            }
            if (fetching != null || this.isSleeping() || this.isInSittingPose() || !this.isTame() || this.isLeashed()) {
                this.currentHyperfocus = null;
            } else {
                owner = this.getOwner();
                if (this.currentHyperfocus != null) {
                    boolean ownerAbsent;
                    boolean hyperfocusClear = this.level().getBrightness(LightLayer.BLOCK, this.currentHyperfocus) > 0;
                    boolean bl = ownerAbsent = owner == null || owner instanceof Player && !owner.getMainHandItem().is(Items.TORCH) && !owner.getOffhandItem().is(Items.TORCH);
                    if (hyperfocusClear || ownerAbsent) {
                        this.currentHyperfocus = null;
                        this.hyperfocusCooldown = 40;
                        if (hyperfocusClear && !ownerAbsent && owner instanceof ServerPlayer) {
                            ServerPlayer sp = (ServerPlayer)owner;
                            ShibaModule.shibaHelpTrigger.trigger(sp);
                        }
                    }
                }
                if (this.currentHyperfocus == null && owner instanceof Player) {
                    Player player = (Player)owner;
                    if (this.hyperfocusCooldown == 0 && (player.getMainHandItem().is(Items.TORCH) || player.getOffhandItem().is(Items.TORCH))) {
                        BlockPos ourPos = this.blockPosition();
                        int searchRange = 10;
                        for (int i = 0; i < 20; ++i) {
                            BlockPos test = ourPos.offset(this.random.nextInt(21) - 10, this.random.nextInt(21) - 10, this.random.nextInt(21) - 10);
                            if (!this.hasLineOfSight(test.above(), 10.0) || !this.level().getBlockState(test).isAir() || !this.level().getBlockState(test.below()).isSolidRender((BlockGetter)this.level(), test.below()) || this.level().getBrightness(LightLayer.BLOCK, test) != 0 || ShibaModule.ignoreAreasWithSkylight && this.level().canSeeSky(test)) continue;
                            this.currentHyperfocus = test;
                        }
                    }
                }
            }
        }
        if (!this.isSleeping() && !this.level().isClientSide && fetching == null && this.getMouthItem().isEmpty() && (owner = this.getOwner()) != null) {
            AABB check = owner.getBoundingBox().inflate(2.0);
            List arrows = this.level().getEntitiesOfClass(AbstractArrow.class, check, a -> a.getOwner() == owner && a.pickup != AbstractArrow.Pickup.DISALLOWED);
            if (arrows.size() > 0) {
                AbstractArrow arrow = (AbstractArrow)arrows.get(this.level().random.nextInt(arrows.size()));
                this.setFetching(arrow);
            }
        }
    }

    public boolean hasLineOfSight(BlockPos pos, double maxRange) {
        Vec3 currentPos = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        Vec3 targetPos = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
        if (targetPos.distanceTo(currentPos) > maxRange) {
            return false;
        }
        return this.level().clip(new ClipContext(currentPos, targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() == HitResult.Type.MISS;
    }

    public AbstractArrow getFetching() {
        int id = (Integer)this.entityData.get(FETCHING);
        if (id == -1) {
            return null;
        }
        Entity e = this.level().getEntity(id);
        if (!(e instanceof AbstractArrow)) {
            return null;
        }
        return (AbstractArrow)e;
    }

    public void setFetching(AbstractArrow e) {
        this.entityData.set(FETCHING, (Object)(e == null ? -1 : e.getId()));
    }

    public boolean isFood(ItemStack stack) {
        Item item = stack.getItem();
        return item.getFoodProperties(stack, (LivingEntity)this) != null && stack.is(ItemTags.MEAT);
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, entity);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COLLAR_COLOR, (Object)DyeColor.RED.getId());
        builder.define(MOUTH_ITEM, (Object)ItemStack.EMPTY);
        builder.define(FETCHING, (Object)-1);
    }

    public DyeColor getCollarColor() {
        return DyeColor.byId((int)((Integer)this.entityData.get(COLLAR_COLOR)));
    }

    public void setCollarColor(DyeColor collarcolor) {
        this.entityData.set(COLLAR_COLOR, (Object)collarcolor.getId());
    }

    public ItemStack getMouthItem() {
        return (ItemStack)this.entityData.get(MOUTH_ITEM);
    }

    public void setMouthItem(ItemStack stack) {
        this.entityData.set(MOUTH_ITEM, (Object)stack);
    }

    public int getMaxSpawnClusterSize() {
        return 8;
    }

    public boolean canMate(@NotNull Animal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.isTame()) {
            return false;
        }
        if (!(otherAnimal instanceof Shiba)) {
            return false;
        }
        Shiba wolfentity = (Shiba)otherAnimal;
        if (!wolfentity.isTame()) {
            return false;
        }
        if (wolfentity.isSleeping()) {
            return false;
        }
        return this.isInLove() && wolfentity.isInLove();
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte("CollarColor", (byte)this.getCollarColor().getId());
        CompoundTag itemcmp = new CompoundTag();
        ItemStack holding = this.getMouthItem();
        if (!holding.isEmpty()) {
            holding.save((HolderLookup.Provider)this.level().registryAccess(), (Tag)itemcmp);
        }
        compound.put("MouthItem", (Tag)itemcmp);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("CollarColor")) {
            this.setCollarColor(DyeColor.byId((int)compound.getInt("CollarColor")));
        }
        if (compound.contains("MouthItem")) {
            CompoundTag itemcmp = compound.getCompound("MouthItem");
            this.setMouthItem(ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)itemcmp));
        }
    }

    @NotNull
    public InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        ItemStack heldItemStack = player.getItemInHand(hand);
        Item item = heldItemStack.getItem();
        Level level = this.level();
        if (player.isDiscrete() && player.getMainHandItem().isEmpty()) {
            if (hand == InteractionHand.MAIN_HAND && WantLoveGoal.canPet(this)) {
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    Vec3 pos = this.position();
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.HEART, pos.x, pos.y + 0.5, pos.z, 1, 0.0, 0.0, 0.0, 0.1);
                    this.playSound(QuarkSounds.ENTITY_SHIBA_WHINE, 0.6f, 0.5f + (float)Math.random() * 0.5f);
                }
                WantLoveGoal.setPetTime(this);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        } else {
            if (level.isClientSide) {
                boolean flag = this.isOwnedBy((LivingEntity)player) || this.isTame() || item == Items.BONE && !this.isTame();
                return flag ? InteractionResult.SUCCESS : InteractionResult.PASS;
            }
            boolean isPlayerOwner = this.isOwnedBy((LivingEntity)player);
            if (this.isTame()) {
                DyeItem dyeItem;
                DyeColor dyecolor;
                ItemStack mouthItem = this.getMouthItem();
                if (!mouthItem.isEmpty()) {
                    Level level2;
                    ItemStack copy = mouthItem.copy();
                    if (!player.addItem(copy)) {
                        this.spawnAtLocation(copy);
                    }
                    if ((level2 = player.level()) instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level2;
                        Vec3 pos = this.position();
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.HEART, pos.x, pos.y + 0.5, pos.z, 1, 0.0, 0.0, 0.0, 0.1);
                        this.playSound(QuarkSounds.ENTITY_SHIBA_WHINE, 0.6f, 0.5f + (float)Math.random() * 0.5f);
                    }
                    this.setMouthItem(ItemStack.EMPTY);
                    return InteractionResult.CONSUME;
                }
                if (this.isFood(heldItemStack) && this.getHealth() < this.getMaxHealth()) {
                    if (!player.getAbilities().instabuild) {
                        heldItemStack.shrink(1);
                    }
                    this.heal(item.getFoodProperties(heldItemStack, (LivingEntity)this).nutrition());
                    return InteractionResult.CONSUME;
                }
                if (item instanceof DyeItem && (dyecolor = (dyeItem = (DyeItem)item).getDyeColor()) != this.getCollarColor()) {
                    this.setCollarColor(dyecolor);
                    if (!player.getAbilities().instabuild) {
                        heldItemStack.shrink(1);
                    }
                    return InteractionResult.CONSUME;
                }
                if (!heldItemStack.isEmpty() && mouthItem.isEmpty() && heldItemStack.getItem() instanceof SwordItem) {
                    ItemStack copy = heldItemStack.copy();
                    copy.setCount(1);
                    heldItemStack.setCount(heldItemStack.getCount() - 1);
                    this.setMouthItem(copy);
                    return InteractionResult.CONSUME;
                }
                if (heldItemStack.is(Items.WOLF_ARMOR) && this.isOwnedBy((LivingEntity)player) && this.getBodyArmorItem().isEmpty() && !this.isBaby()) {
                    this.setBodyArmorItem(heldItemStack.copyWithCount(1));
                    heldItemStack.consume(1, (LivingEntity)player);
                    return InteractionResult.SUCCESS;
                }
                if (heldItemStack.canPerformAction(ItemAbilities.SHEARS_REMOVE_ARMOR) && this.isOwnedBy((LivingEntity)player) && this.hasArmor() && (!EnchantmentHelper.has((ItemStack)this.getBodyArmorItem(), (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE) || player.isCreative())) {
                    heldItemStack.hurtAndBreak(1, (LivingEntity)player, Shiba.getSlotForHand((InteractionHand)hand));
                    this.playSound(SoundEvents.ARMOR_UNEQUIP_WOLF);
                    ItemStack itemstack1 = this.getBodyArmorItem();
                    this.setBodyArmorItem(ItemStack.EMPTY);
                    this.spawnAtLocation(itemstack1);
                    return InteractionResult.SUCCESS;
                }
                if (((Ingredient)((ArmorMaterial)ArmorMaterials.ARMADILLO.value()).repairIngredient().get()).test(heldItemStack) && this.isInSittingPose() && this.hasArmor() && isPlayerOwner && this.getBodyArmorItem().isDamaged()) {
                    heldItemStack.shrink(1);
                    this.playSound(SoundEvents.WOLF_ARMOR_REPAIR);
                    ItemStack bodyArmor = this.getBodyArmorItem();
                    int repairValue = bodyArmor.getMaxDamage() / 8;
                    bodyArmor.setDamageValue(Math.max(0, bodyArmor.getDamageValue() - repairValue));
                    return InteractionResult.SUCCESS;
                }
                InteractionResult interactionResult = super.mobInteract(player, hand);
                if ((!interactionResult.consumesAction() || this.isBaby()) && isPlayerOwner) {
                    this.setOrderedToSit(!this.isOrderedToSit());
                    this.jumping = false;
                    this.navigation.stop();
                    this.setTarget(null);
                    return InteractionResult.CONSUME;
                }
                return interactionResult;
            }
            if (item == Items.BONE) {
                if (!player.getAbilities().instabuild) {
                    heldItemStack.shrink(1);
                }
                if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)player)) {
                    WantLoveGoal.setPetTime(this);
                    this.tame(player);
                    this.navigation.stop();
                    this.setTarget(null);
                    this.setOrderedToSit(true);
                    level.broadcastEntityEvent((Entity)this, (byte)7);
                } else {
                    level.broadcastEntityEvent((Entity)this, (byte)6);
                }
                return InteractionResult.CONSUME;
            }
        }
        return super.mobInteract(player, hand);
    }

    public void setTame(boolean tame, boolean applyTamingSideEffects) {
        super.setTame(tame, applyTamingSideEffects);
        if (tame) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(20.0);
            this.setHealth(20.0f);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(8.0);
        }
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(4.0);
    }

    protected void playStepSound(@NotNull BlockPos pos, @NotNull BlockState blockIn) {
        this.playSound(QuarkSounds.ENTITY_SHIBA_STEP, 0.15f, 1.0f);
    }

    protected SoundEvent getAmbientSound() {
        if (this.random.nextInt(3) == 0) {
            return this.getHealth() / this.getMaxHealth() < 0.5f ? QuarkSounds.ENTITY_SHIBA_WHINE : QuarkSounds.ENTITY_SHIBA_PANT;
        }
        return QuarkSounds.ENTITY_SHIBA_AMBIENT;
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource source) {
        return this.canArmorAbsorb(source) ? SoundEvents.WOLF_ARMOR_DAMAGE : QuarkSounds.ENTITY_SHIBA_HURT;
    }

    protected SoundEvent getDeathSound() {
        return QuarkSounds.ENTITY_SHIBA_DEATH;
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    public AgeableMob getBreedOffspring(@NotNull ServerLevel world, @NotNull AgeableMob mate) {
        Shiba wolfentity = (Shiba)ShibaModule.shibaType.create((Level)world);
        UUID uuid = this.getOwnerUUID();
        if (uuid != null) {
            wolfentity.setOwnerUUID(uuid);
            wolfentity.setTame(true, false);
        }
        return wolfentity;
    }

    private boolean canArmorAbsorb(DamageSource damageSource) {
        return this.hasArmor() && !damageSource.is(DamageTypeTags.BYPASSES_WOLF_ARMOR);
    }

    public boolean hasArmor() {
        return this.getBodyArmorItem().is(Items.WOLF_ARMOR);
    }

    protected void actuallyHurt(DamageSource damageSource, float damageAmount) {
        if (!this.canArmorAbsorb(damageSource)) {
            super.actuallyHurt(damageSource, damageAmount);
        } else {
            ItemStack itemstack = this.getBodyArmorItem();
            int i = itemstack.getDamageValue();
            int j = itemstack.getMaxDamage();
            itemstack.hurtAndBreak(Mth.ceil((float)damageAmount), (LivingEntity)this, EquipmentSlot.BODY);
            if (Crackiness.WOLF_ARMOR.byDamage(i, j) != Crackiness.WOLF_ARMOR.byDamage(this.getBodyArmorItem())) {
                this.playSound(SoundEvents.WOLF_ARMOR_CRACK);
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)level;
                    serverlevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, Items.ARMADILLO_SCUTE.getDefaultInstance()), this.getX(), this.getY() + 1.0, this.getZ(), 20, 0.2, 0.1, 0.2, 0.1);
                }
            }
        }
    }

    protected void hurtArmor(DamageSource damageSource, float damageAmount) {
        this.doHurtEquipment(damageSource, damageAmount, new EquipmentSlot[]{EquipmentSlot.BODY});
    }
}

