/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.ai;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.mobs.entity.Foxhound;

public class FindPlaceToSleepGoal
extends MoveToBlockGoal {
    private final Foxhound foxhound;
    private final Target target;
    private boolean hadSlept = false;

    public FindPlaceToSleepGoal(Foxhound foxhound, double speed, Target target) {
        super((PathfinderMob)foxhound, speed, 8);
        this.foxhound = foxhound;
        this.target = target;
    }

    public boolean canUse() {
        return this.foxhound.isTame() && !this.foxhound.isOrderedToSit() && super.canUse();
    }

    public boolean canContinueToUse() {
        return (!this.hadSlept || this.foxhound.isSleeping()) && super.canContinueToUse();
    }

    public void start() {
        super.start();
        this.hadSlept = false;
        this.foxhound.setOrderedToSit(false);
        this.foxhound.getSleepGoal().setSleeping(false);
        this.foxhound.setInSittingPose(false);
    }

    public void stop() {
        super.stop();
        this.hadSlept = false;
        this.foxhound.setOrderedToSit(false);
        this.foxhound.getSleepGoal().setSleeping(false);
        this.foxhound.setInSittingPose(false);
    }

    public void tick() {
        super.tick();
        Vec3 motion = this.foxhound.getDeltaMovement();
        if (!this.isReachedTarget() || motion.x > 0.0 || motion.z > 0.0) {
            this.foxhound.setOrderedToSit(false);
            this.foxhound.getSleepGoal().setSleeping(false);
            this.foxhound.setInSittingPose(false);
        } else if (!this.foxhound.isOrderedToSit()) {
            this.foxhound.setOrderedToSit(true);
            this.foxhound.getSleepGoal().setSleeping(true);
            this.foxhound.setInSittingPose(true);
            this.foxhound.startSleeping(this.blockPos.above());
            this.hadSlept = true;
        }
    }

    protected boolean isValidTarget(@NotNull LevelReader world, @NotNull BlockPos pos) {
        if (!world.isEmptyBlock(pos.above())) {
            return false;
        }
        BlockState state = world.getBlockState(pos);
        BlockEntity tileentity = world.getBlockEntity(pos);
        int light = Quark.ZETA.blockExtensions.get(state).getLightEmissionZeta(state, (BlockGetter)world, pos);
        return switch (this.target.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (tileentity instanceof FurnaceBlockEntity && light > 2) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (tileentity instanceof FurnaceBlockEntity && light <= 2) {
                    yield true;
                }
                yield false;
            }
            case 2 -> light > 2;
        };
    }

    public static enum Target {
        LIT_FURNACE,
        FURNACE,
        GLOWING;

    }
}

