/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.experimental.module;

import com.mojang.text2speech.Narrator;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import org.violetmoon.quark.catnip.animation.AnimationTickHolder;
import org.violetmoon.zeta.client.event.load.ZKeyMapping;
import org.violetmoon.zeta.client.event.play.ZInput;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="experimental", enabledByDefault=false)
public class NarratorReadoutModule
extends ZetaModule {

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends NarratorReadoutModule {
        private KeyMapping keybind;
        private KeyMapping keybindFull;
        private float last;

        @LoadEvent
        public void registerKeybinds(ZKeyMapping event) {
            this.keybind = event.init("quark.keybind.narrator_readout", null, "quark.gui.keygroup.misc");
            this.keybindFull = event.init("quark.keybind.narrator_full_readout", null, "quark.gui.keygroup.misc");
        }

        @PlayEvent
        public void onMouseInput(ZInput.MouseButton event) {
            boolean down = this.isDown(event.getButton(), 0, true, this.keybind);
            boolean full = this.isDown(event.getButton(), 0, true, this.keybindFull);
            this.acceptInput(down || full, down);
        }

        @PlayEvent
        public void onKeyInput(ZInput.Key event) {
            boolean down = this.isDown(event.getKey(), event.getScanCode(), false, this.keybind);
            boolean full = this.isDown(event.getKey(), event.getScanCode(), false, this.keybindFull);
            this.acceptInput(down || full, down);
        }

        private boolean isDown(int key, int scancode, boolean mouse, KeyMapping keybind) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.screen != null) {
                if (mouse) {
                    return keybind.matchesMouse(key) && (keybind.getKeyModifier() == KeyModifier.NONE || keybind.getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.GUI));
                }
                return keybind.matches(key, scancode) && (keybind.getKeyModifier() == KeyModifier.NONE || keybind.getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.GUI));
            }
            return keybind.isDown();
        }

        private void acceptInput(boolean down, boolean full) {
            Minecraft mc = Minecraft.getInstance();
            float curr = (float)AnimationTickHolder.getTicks() + Minecraft.getInstance().getTimer().getGameTimeDeltaTicks();
            if (down && curr - this.last > 10.0f) {
                Narrator narrator = Narrator.getNarrator();
                String readout = this.getReadout(mc, full);
                if (readout != null) {
                    narrator.say(readout, true);
                    this.last = curr;
                }
            }
        }

        private String getReadout(Minecraft mc, boolean full) {
            LocalPlayer player = mc.player;
            if (player == null) {
                return I18n.get((String)"quark.readout.not_ingame", (Object[])new Object[0]);
            }
            StringBuilder sb = new StringBuilder();
            if (mc.screen == null) {
                HitResult ray = mc.hitResult;
                if (ray != null && ray.getType() == HitResult.Type.BLOCK) {
                    BlockPos pos = ((BlockHitResult)ray).getBlockPos();
                    BlockState state = mc.level.getBlockState(pos);
                    Item item = state.getBlock().asItem();
                    if (item != null) {
                        sb.append(I18n.get((String)"quark.readout.looking", (Object[])new Object[]{item.getName(new ItemStack((ItemLike)item)).getString()}));
                        if (full) {
                            sb.append(", ");
                        }
                    }
                    if (state.getBlock() instanceof SignBlock) {
                        String msg;
                        SignBlockEntity tile = (SignBlockEntity)mc.level.getBlockEntity(pos);
                        sb.append(I18n.get((String)"quark.readout.sign_says", (Object[])new Object[0]));
                        for (Component cmp : tile.getFrontText().getMessages(false)) {
                            msg = cmp.getString().trim();
                            if (msg.isEmpty()) continue;
                            sb.append(cmp.getString());
                            sb.append(" ");
                        }
                        sb.append(". ");
                        sb.append(I18n.get((String)"quark.readout.sign_says", (Object[])new Object[0]));
                        for (Component cmp : tile.getBackText().getMessages(false)) {
                            msg = cmp.getString().trim();
                            if (msg.isEmpty()) continue;
                            sb.append(cmp.getString());
                            sb.append(" ");
                        }
                        sb.append(". ");
                    }
                }
                if (full) {
                    ItemStack stack = player.getMainHandItem();
                    ItemStack stack2 = player.getOffhandItem();
                    if (stack.isEmpty()) {
                        stack = stack2;
                        stack2 = ItemStack.EMPTY;
                    }
                    if (!stack.isEmpty()) {
                        if (!stack2.isEmpty()) {
                            sb.append(I18n.get((String)"quark.readout.holding_with_off", (Object[])new Object[]{stack.getCount(), stack.getHoverName().getString(), stack2.getCount(), stack2.getHoverName().getString()}));
                        } else {
                            sb.append(I18n.get((String)"quark.readout.holding", (Object[])new Object[]{stack.getCount(), stack.getHoverName().getString()}));
                        }
                        sb.append(", ");
                    }
                    sb.append(I18n.get((String)"quark.readout.health", (Object[])new Object[]{(int)mc.player.getHealth()}));
                    sb.append(", ");
                    sb.append(I18n.get((String)"quark.readout.food", (Object[])new Object[]{mc.player.getFoodData().getFoodLevel()}));
                }
            } else {
                Screen stack = mc.screen;
                if (stack instanceof AbstractContainerScreen) {
                    ItemStack stack2;
                    AbstractContainerScreen cnt = (AbstractContainerScreen)stack;
                    Slot slot = cnt.getSlotUnderMouse();
                    ItemStack itemStack = stack2 = slot == null ? ItemStack.EMPTY : slot.getItem();
                    if (stack2.isEmpty()) {
                        sb.append(I18n.get((String)"quark.readout.no_item", (Object[])new Object[0]));
                    } else {
                        List tooltip = Screen.getTooltipFromItem((Minecraft)mc, (ItemStack)stack2);
                        for (Component t : tooltip) {
                            MutableComponent print = t.copy();
                            List bros = print.getSiblings();
                            for (Component sib : bros) {
                                TranslatableContents ttc;
                                MutableComponent mut;
                                ComponentContents componentContents;
                                if (!(sib instanceof MutableComponent) || !((componentContents = (mut = (MutableComponent)sib).getContents()) instanceof TranslatableContents) || !(ttc = (TranslatableContents)componentContents).getKey().contains("enchantment.level.")) continue;
                                bros.set(bros.indexOf(sib), Component.translatable((String)ttc.getKey().substring("enchantment.level.".length())));
                                break;
                            }
                            sb.append(print.getString());
                            if (full) {
                                sb.append(", ");
                                continue;
                            }
                            break;
                        }
                    }
                } else {
                    sb.append(mc.screen.getNarrationMessage());
                }
            }
            return sb.toString();
        }
    }
}

