/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.violetmoon.quark.content.tools.module.SkullPikesModule;

public class SkullPike
extends Entity {
    public SkullPike(EntityType<?> type, Level world) {
        super(type, world);
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel sworld = (ServerLevel)level;
            boolean good = false;
            BlockPos pos = this.blockPosition();
            BlockState state = this.level().getBlockState(pos);
            if (state.is(SkullPikesModule.pikeTrophiesTag)) {
                BlockPos down = pos.below();
                BlockState downState = this.level().getBlockState(down);
                if (downState.is(BlockTags.FENCES)) {
                    good = true;
                }
            }
            if (!good) {
                this.removeAfterChangingDimensions();
            }
            if (Math.random() < 0.4) {
                sworld.sendParticles((ParticleOptions)(Math.random() < 0.05 ? ParticleTypes.WARPED_SPORE : ParticleTypes.ASH), (double)pos.getX() + 0.5, (double)pos.getY() + 0.25, (double)pos.getZ() + 0.5, 1, 0.25, 0.25, 0.25, 0.0);
            }
        }
    }

    public boolean isVisible(Entity entityIn) {
        Vec3 vector3d = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        Vec3 vector3d1 = new Vec3(entityIn.getX(), entityIn.getEyeY(), entityIn.getZ());
        return this.level().clip(new ClipContext(vector3d, vector3d1, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() == HitResult.Type.MISS;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
    }
}

