/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.mixin.mixins;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.violetmoon.quark.content.client.hax.PseudoAccessorItemStack;
import org.violetmoon.quark.content.client.resources.AttributeSlot;
import org.violetmoon.quark.content.tools.module.AncientTomesModule;
import org.violetmoon.quark.content.tools.module.ColorRunesModule;
import org.violetmoon.quark.content.tweaks.module.GoldToolsHaveFortuneModule;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin
implements PseudoAccessorItemStack {
    @Unique
    private Map<AttributeSlot, Multimap<Attribute, AttributeModifier>> capturedAttributes = new HashMap<AttributeSlot, Multimap<Attribute, AttributeModifier>>();

    @Shadow
    public abstract ItemStack copy();

    @ModifyReturnValue(method={"getRarity"}, at={@At(value="RETURN")})
    private Rarity getRarity(Rarity prev) {
        return AncientTomesModule.shiftRarity((ItemStack)this, prev);
    }

    @WrapOperation(method={"addToTooltip"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;get(Lnet/minecraft/core/component/DataComponentType;)Ljava/lang/Object;")})
    private Object overwriteEnchantmentTooltip(ItemStack stack, DataComponentType<?> componentType, Operation<Object> original, @Local(argsOnly=true) Item.TooltipContext context) {
        return original.call(new Object[]{GoldToolsHaveFortuneModule.createTooltipStack(stack, componentType, context.registries()), componentType});
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="RETURN")})
    private void overwriteTooltip(Item.TooltipContext context, Player player, TooltipFlag flag, CallbackInfoReturnable<List<Component>> cir) {
        GoldToolsHaveFortuneModule.modifyTooltip((ItemStack)this, (List)cir.getReturnValue(), context.registries());
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;addToTooltip(Lnet/minecraft/core/component/DataComponentType;Lnet/minecraft/world/item/Item$TooltipContext;Ljava/util/function/Consumer;Lnet/minecraft/world/item/TooltipFlag;)V", ordinal=2)})
    private void addRuneTooltip(Item.TooltipContext tooltipContext, Player player, TooltipFlag tooltipFlag, CallbackInfoReturnable<List<Component>> cir, @Local List<Component> list) {
        ColorRunesModule.appendRuneTooltip((ItemStack)this, list);
    }

    @Override
    public Map<AttributeSlot, Multimap<Attribute, AttributeModifier>> quark$getCapturedAttributes() {
        return this.capturedAttributes;
    }

    @Override
    public void quark$capturePotionAttributes(List<Pair<Attribute, AttributeModifier>> attributes) {
        LinkedHashMultimap attributeContainer = LinkedHashMultimap.create();
        for (Pair<Attribute, AttributeModifier> pair : attributes) {
            attributeContainer.put((Object)((Attribute)pair.getFirst()), (Object)((AttributeModifier)pair.getSecond()));
        }
        this.capturedAttributes.put(AttributeSlot.POTION, (Multimap<Attribute, AttributeModifier>)attributeContainer);
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="HEAD")})
    private void clearCapturedTooltip(Item.TooltipContext context, Player player, TooltipFlag flag, CallbackInfoReturnable<List<Component>> cir) {
        this.capturedAttributes = new HashMap<AttributeSlot, Multimap<Attribute, AttributeModifier>>();
    }
}

