/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.module;

import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.common.Tags;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.mobs.client.render.entity.StonelingRenderer;
import org.violetmoon.quark.content.mobs.entity.Stoneling;
import org.violetmoon.quark.content.mobs.item.DiamondHeartItem;
import org.violetmoon.zeta.advancement.ManualTrigger;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.config.type.CompoundBiomeConfig;
import org.violetmoon.zeta.config.type.DimensionConfig;
import org.violetmoon.zeta.config.type.EntitySpawnConfig;
import org.violetmoon.zeta.config.type.IBiomeConfig;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZEntityAttributeCreation;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="mobs")
public class StonelingsModule
extends ZetaModule {
    public static EntityType<Stoneling> stonelingType;
    @Config
    public static int maxYLevel;
    @Config
    public static DimensionConfig dimensions;
    @Config
    public static EntitySpawnConfig spawnConfig;
    @Config(flag="stoneling_drop_diamond_heart")
    public static boolean enableDiamondHeart;
    @Config(description="When enabled, stonelings are much more aggressive in checking for players")
    public static boolean cautiousStonelings;
    @Config
    public static boolean tamableStonelings;
    @Config(description="Disabled if if Pathfinder Maps are disabled.", flag="stoneling_weald_pathfinder")
    public static boolean wealdPathfinderMaps;
    public static ManualTrigger makeStonelingTrigger;
    @Hint(value="stoneling_drop_diamond_heart")
    public static Item diamondHeart;
    public boolean registered = false;

    @LoadEvent
    public final void register(ZRegister event) {
        this.registered = true;
        diamondHeart = new DiamondHeartItem("diamond_heart", this, new Item.Properties().rarity(Rarity.UNCOMMON));
        stonelingType = EntityType.Builder.of(Stoneling::new, (MobCategory)MobCategory.CREATURE).sized(0.5f, 0.9f).clientTrackingRange(8).build("stoneling");
        Quark.ZETA.registry.register(stonelingType, "stoneling", Registries.ENTITY_TYPE);
        makeStonelingTrigger = event.getAdvancementModifierRegistry().registerManualTrigger("make_stoneling");
        Quark.ZETA.entitySpawn.registerSpawn(stonelingType, MobCategory.MONSTER, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Stoneling::spawnPredicate, spawnConfig);
        Quark.ZETA.entitySpawn.addEgg((ZetaModule)this, stonelingType, 0xA1A1A1, 0x505050, spawnConfig);
    }

    @LoadEvent
    public final void entityAttrs(ZEntityAttributeCreation e) {
        e.put(stonelingType, Stoneling.prepareAttributes().build());
    }

    static {
        maxYLevel = 0;
        dimensions = DimensionConfig.overworld((boolean)false);
        spawnConfig = new EntitySpawnConfig(80, 1, 1, (IBiomeConfig)CompoundBiomeConfig.fromBiomeTags((boolean)true, (TagKey[])new TagKey[]{Tags.Biomes.IS_VOID, BiomeTags.IS_NETHER, BiomeTags.IS_END}));
        enableDiamondHeart = true;
        cautiousStonelings = false;
        tamableStonelings = true;
        wealdPathfinderMaps = true;
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends StonelingsModule {
        @LoadEvent
        public final void clientSetup(ZClientSetup event) {
            EntityRenderers.register((EntityType)stonelingType, StonelingRenderer::new);
        }
    }
}

