/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.network.PacketDistributor;
import org.violetmoon.quark.api.IRotationLockable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.client.handler.ClientUtil;
import org.violetmoon.quark.base.network.message.SetLockProfileMessage;
import org.violetmoon.quark.content.building.block.QuarkVerticalSlabBlock;
import org.violetmoon.quark.content.building.block.VerticalSlabBlock;
import org.violetmoon.zeta.client.event.load.ZKeyMapping;
import org.violetmoon.zeta.client.event.play.ZInput;
import org.violetmoon.zeta.client.event.play.ZRenderGuiOverlay;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.play.entity.player.ZPlayer;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="tweaks")
public class LockRotationModule
extends ZetaModule {
    private static final String TAG_LOCKED_ONCE = "quark:locked_once";
    private static final HashMap<UUID, LockProfile> lockProfiles = new HashMap();
    @Config(description="When true, lock rotation indicator in the same style as crosshair")
    public static boolean renderLikeCrossHair = true;

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        lockProfiles.clear();
    }

    public static BlockState fixBlockRotation(BlockState state, BlockPlaceContext ctx) {
        if (state == null || ctx.getPlayer() == null || !Quark.ZETA.modules.isEnabled(LockRotationModule.class)) {
            return state;
        }
        UUID uuid = ctx.getPlayer().getUUID();
        if (lockProfiles.containsKey(uuid)) {
            LockProfile profile = lockProfiles.get(uuid);
            BlockState transformed = LockRotationModule.getRotatedState(ctx.getLevel(), ctx.getClickedPos(), state, profile.facing.getOpposite(), profile.half);
            if (!transformed.equals(state)) {
                return Block.updateFromNeighbourShapes((BlockState)transformed, (LevelAccessor)ctx.getLevel(), (BlockPos)ctx.getClickedPos());
            }
        }
        return state;
    }

    public static BlockState getRotatedState(Level world, BlockPos pos, BlockState state, Direction face, int half) {
        BlockState setState = state;
        Map props = state.getValues();
        Block block = state.getBlock();
        if (block instanceof IRotationLockable) {
            IRotationLockable lockable = (IRotationLockable)block;
            setState = lockable.applyRotationLock(world, pos, state, face, half);
        } else if (props.containsKey(BlockStateProperties.FACING)) {
            setState = (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)face);
        } else if (props.containsKey(QuarkVerticalSlabBlock.TYPE) && props.get(QuarkVerticalSlabBlock.TYPE) != VerticalSlabBlock.VerticalSlabType.DOUBLE && face.getAxis() != Direction.Axis.Y) {
            setState = (BlockState)state.setValue((Property)QuarkVerticalSlabBlock.TYPE, (Comparable)((Object)Objects.requireNonNull(VerticalSlabBlock.VerticalSlabType.fromDirection(face))));
        } else if (props.containsKey(BlockStateProperties.HORIZONTAL_FACING) && face.getAxis() != Direction.Axis.Y) {
            setState = block instanceof StairBlock ? (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)face.getOpposite()) : (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)face);
        } else if (props.containsKey(BlockStateProperties.AXIS)) {
            setState = (BlockState)state.setValue((Property)BlockStateProperties.AXIS, (Comparable)face.getAxis());
        } else if (props.containsKey(BlockStateProperties.FACING_HOPPER)) {
            setState = (BlockState)state.setValue((Property)BlockStateProperties.FACING_HOPPER, (Comparable)(face == Direction.DOWN ? face : face.getOpposite()));
        }
        if (half != -1) {
            if (props.containsKey(BlockStateProperties.SLAB_TYPE) && props.get(BlockStateProperties.SLAB_TYPE) != SlabType.DOUBLE) {
                setState = (BlockState)setState.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)(half == 1 ? SlabType.TOP : SlabType.BOTTOM));
            } else if (props.containsKey(BlockStateProperties.HALF)) {
                setState = (BlockState)setState.setValue((Property)BlockStateProperties.HALF, (Comparable)(half == 1 ? Half.TOP : Half.BOTTOM));
            }
        } else if (face.getAxis().equals((Object)Direction.Axis.Y)) {
            if (props.containsKey(BlockStateProperties.SLAB_TYPE) && props.get(BlockStateProperties.SLAB_TYPE) != SlabType.DOUBLE) {
                setState = (BlockState)setState.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)(face == Direction.DOWN ? SlabType.TOP : SlabType.BOTTOM));
            } else if (props.containsKey(BlockStateProperties.HALF)) {
                setState = (BlockState)setState.setValue((Property)BlockStateProperties.HALF, (Comparable)(face == Direction.DOWN ? Half.TOP : Half.BOTTOM));
            }
        }
        return setState;
    }

    @PlayEvent
    public void onPlayerLogoff(ZPlayer.LoggedOut event) {
        lockProfiles.remove(event.getEntity().getUUID());
    }

    public static void setProfile(Player player, LockProfile profile) {
        UUID uuid = player.getUUID();
        if (profile == null) {
            lockProfiles.remove(uuid);
        } else {
            boolean locked = player.getPersistentData().getBoolean(TAG_LOCKED_ONCE);
            if (!locked) {
                MutableComponent keybind = Component.keybind((String)"quark.keybind.lock_rotation").withStyle(ChatFormatting.AQUA);
                MutableComponent text = Component.translatable((String)"quark.misc.rotation_lock", (Object[])new Object[]{keybind});
                player.sendSystemMessage((Component)text);
                player.getPersistentData().putBoolean(TAG_LOCKED_ONCE, true);
            }
            lockProfiles.put(uuid, profile);
        }
    }

    @PlayEvent
    public void respawn(ZPlayer.Clone event) {
        if (event.getOriginal().getPersistentData().getBoolean(TAG_LOCKED_ONCE)) {
            event.getEntity().getPersistentData().putBoolean(TAG_LOCKED_ONCE, true);
        }
    }

    public record LockProfile(Direction facing, int half) {
        public static final StreamCodec<ByteBuf, LockProfile> STREAM_CODEC = StreamCodec.composite((StreamCodec)Direction.STREAM_CODEC, LockProfile::facing, (StreamCodec)ByteBufCodecs.INT, LockProfile::half, LockProfile::new);
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends LockRotationModule {
        private LockProfile clientProfile;
        private KeyMapping keybind;

        @LoadEvent
        public void registerKeybinds(ZKeyMapping event) {
            this.keybind = event.init("quark.keybind.lock_rotation", "k", "quark.gui.keygroup.misc");
        }

        @PlayEvent
        public void onMouseInput(ZInput.MouseButton event) {
            this.acceptInput();
        }

        @PlayEvent
        public void onKeyInput(ZInput.Key event) {
            this.acceptInput();
        }

        /*
         * Unable to fully structure code
         */
        private void acceptInput() {
            block7: {
                mc = Minecraft.getInstance();
                down = this.keybind.isDown();
                if (!mc.isWindowActive() || !down || mc.screen != null) break block7;
                result = mc.hitResult;
                if (!(result instanceof BlockHitResult)) ** GOTO lbl-1000
                bresult = (BlockHitResult)result;
                if (result.getType() == HitResult.Type.BLOCK) {
                    hitVec = bresult.getLocation();
                    face = bresult.getDirection();
                    half = Math.abs((int)((hitVec.y - (double)((int)hitVec.y)) * 2.0));
                    if (face.getAxis() == Direction.Axis.Y) {
                        half = -1;
                    } else if (hitVec.y < 0.0) {
                        half = 1 - half;
                    }
                    newProfile = new LockProfile(face.getOpposite(), half);
                } else lbl-1000:
                // 2 sources

                {
                    look = mc.player.getLookAngle();
                    newProfile = new LockProfile(Direction.getNearest((float)((float)look.x), (float)((float)look.y), (float)((float)look.z)), -1);
                }
                if (this.clientProfile != null && this.clientProfile.equals(newProfile)) {
                    this.clientProfile = null;
                    PacketDistributor.sendToServer((CustomPacketPayload)new SetLockProfileMessage(this.clientProfile), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else {
                    this.clientProfile = newProfile;
                    PacketDistributor.sendToServer((CustomPacketPayload)new SetLockProfileMessage(this.clientProfile), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @PlayEvent
        public void onHUDRender(ZRenderGuiOverlay.Post event) {
            if (event.getLayerName().equals((Object)VanillaGuiLayers.CROSSHAIR) && !Minecraft.getInstance().options.hideGui) {
                if (this.clientProfile != null) {
                    GuiGraphics guiGraphics = event.getGuiGraphics();
                    RenderSystem.enableBlend();
                    if (renderLikeCrossHair) {
                        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    } else {
                        RenderSystem.defaultBlendFunc();
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                    }
                    Window window = event.getWindow();
                    int x = window.getGuiScaledWidth() / 2 + 20;
                    int y = window.getGuiScaledHeight() / 2 - 8;
                    guiGraphics.blit(ClientUtil.GENERAL_ICONS, x, y, (float)(this.clientProfile.facing.ordinal() * 16), 65.0f, 16, 16, 256, 256);
                    if (this.clientProfile.half > -1) {
                        guiGraphics.blit(ClientUtil.GENERAL_ICONS, x + 16, y, (float)(this.clientProfile.half * 16), 79.0f, 16, 16, 256, 256);
                    }
                }
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }
}

