/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.datagen;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.addons.oddities.module.BackpackModule;
import org.violetmoon.quark.addons.oddities.module.CrateModule;
import org.violetmoon.quark.addons.oddities.module.MagnetsModule;
import org.violetmoon.quark.addons.oddities.module.PipesModule;
import org.violetmoon.quark.addons.oddities.module.TinyPotatoModule;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.handler.WoodSetHandler;
import org.violetmoon.quark.base.util.CorundumColor;
import org.violetmoon.quark.content.automation.module.ChuteModule;
import org.violetmoon.quark.content.automation.module.EnderWatcherModule;
import org.violetmoon.quark.content.automation.module.FeedingTroughModule;
import org.violetmoon.quark.content.automation.module.GravisandModule;
import org.violetmoon.quark.content.automation.module.IronRodModule;
import org.violetmoon.quark.content.automation.module.MetalButtonsModule;
import org.violetmoon.quark.content.automation.module.ObsidianPlateModule;
import org.violetmoon.quark.content.automation.module.RedstoneRandomizerModule;
import org.violetmoon.quark.content.building.block.RainbowLampBlock;
import org.violetmoon.quark.content.building.module.CelebratoryLampsModule;
import org.violetmoon.quark.content.building.module.CompressedBlocksModule;
import org.violetmoon.quark.content.building.module.DuskboundBlocksModule;
import org.violetmoon.quark.content.building.module.FramedGlassModule;
import org.violetmoon.quark.content.building.module.GlassItemFrameModule;
import org.violetmoon.quark.content.building.module.GoldBarsModule;
import org.violetmoon.quark.content.building.module.GrateModule;
import org.violetmoon.quark.content.building.module.HedgesModule;
import org.violetmoon.quark.content.building.module.HollowLogsModule;
import org.violetmoon.quark.content.building.module.IndustrialPaletteModule;
import org.violetmoon.quark.content.building.module.JapanesePaletteModule;
import org.violetmoon.quark.content.building.module.LeafCarpetModule;
import org.violetmoon.quark.content.building.module.MidoriModule;
import org.violetmoon.quark.content.building.module.MoreBrickTypesModule;
import org.violetmoon.quark.content.building.module.MoreMudBlocksModule;
import org.violetmoon.quark.content.building.module.MoreStoneVariantsModule;
import org.violetmoon.quark.content.building.module.NetherBrickFenceGateModule;
import org.violetmoon.quark.content.building.module.RainbowLampsModule;
import org.violetmoon.quark.content.building.module.RawMetalBricksModule;
import org.violetmoon.quark.content.building.module.RopeModule;
import org.violetmoon.quark.content.building.module.ShinglesModule;
import org.violetmoon.quark.content.building.module.SoulSandstoneModule;
import org.violetmoon.quark.content.building.module.StoolsModule;
import org.violetmoon.quark.content.building.module.SturdyStoneModule;
import org.violetmoon.quark.content.building.module.ThatchModule;
import org.violetmoon.quark.content.building.module.VariantBookshelvesModule;
import org.violetmoon.quark.content.building.module.VariantChestsModule;
import org.violetmoon.quark.content.building.module.VariantFurnacesModule;
import org.violetmoon.quark.content.building.module.VerticalPlanksModule;
import org.violetmoon.quark.content.building.module.VerticalSlabsModule;
import org.violetmoon.quark.content.building.module.WoodenPostsModule;
import org.violetmoon.quark.content.experimental.module.VariantSelectorModule;
import org.violetmoon.quark.content.mobs.module.StonelingsModule;
import org.violetmoon.quark.content.tools.module.AbacusModule;
import org.violetmoon.quark.content.tools.module.ColorRunesModule;
import org.violetmoon.quark.content.tools.module.PickarangModule;
import org.violetmoon.quark.content.tools.module.SeedPouchModule;
import org.violetmoon.quark.content.tools.module.TorchArrowModule;
import org.violetmoon.quark.content.tools.module.TrowelModule;
import org.violetmoon.quark.content.tweaks.module.GlassShardModule;
import org.violetmoon.quark.content.world.module.AncientWoodModule;
import org.violetmoon.quark.content.world.module.AzaleaWoodModule;
import org.violetmoon.quark.content.world.module.BlossomTreesModule;
import org.violetmoon.quark.content.world.module.CorundumModule;
import org.violetmoon.quark.content.world.module.NewStoneTypesModule;
import org.violetmoon.quark.content.world.module.PermafrostModule;
import org.violetmoon.quark.content.world.module.SpiralSpiresModule;
import org.violetmoon.quark.datagen.DataUtil;
import org.violetmoon.quark.datagen.QuarkTags;
import org.violetmoon.zeta.block.IZetaBlock;
import org.violetmoon.zeta.config.FlagCondition;
import org.violetmoon.zeta.util.MiscUtil;
import org.violetmoon.zeta.util.VanillaWoods;

public class QuarkRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public QuarkRecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> holderLookupProvider) {
        super(packOutput, holderLookupProvider);
    }

    public static FlagCondition zCond(String name) {
        return new FlagCondition(name, Optional.empty());
    }

    /*
     * WARNING - void declaration
     */
    protected void buildRecipes(@NotNull RecipeOutput recipeOutput) {
        String dir;
        FlagCondition cond;
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)ChuteModule.chute).pattern("WWW").pattern("SWS").pattern(" S ").define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("chute")}), "quark:automation/crafting/chute");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)EnderWatcherModule.ender_watcher).pattern("BRB").pattern("RER").pattern("BRB").define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('B'), (ItemLike)Blocks.OBSIDIAN.asItem()).define(Character.valueOf('E'), (ItemLike)Items.ENDER_EYE).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("ender_watcher")}), "quark:automation/crafting/ender_watcher");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)FeedingTroughModule.feeding_trough).pattern("#W#").pattern("###").define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('W'), (ItemLike)Items.WHEAT).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("feeding_trough")}), "quark:automation/crafting/feeding_trough");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)MetalButtonsModule.gold_button).requires(ItemTags.WOODEN_BUTTONS).requires(Tags.Items.INGOTS_GOLD).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("gold_metal_button")}), "quark:automation/crafting/gold_button");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)GravisandModule.gravisand).pattern("SSS").pattern("SES").pattern("SSS").define(Character.valueOf('S'), Tags.Items.SANDS_COLORLESS).define(Character.valueOf('E'), Tags.Items.ENDER_PEARLS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("gravisand")}), "quark:automation/crafting/gravisand");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)MetalButtonsModule.iron_button).requires(ItemTags.WOODEN_BUTTONS).requires(Tags.Items.INGOTS_IRON).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("iron_metal_button")}), "quark:automation/crafting/iron_button");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)IronRodModule.iron_rod).pattern("I").pattern("I").pattern("R").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('R'), (ItemLike)Blocks.END_ROD).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("iron_rod"), this.not((ICondition)QuarkRecipeProvider.zCond("iron_rod_pre_end"))}), "quark:automation/crafting/iron_rod");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)IronRodModule.iron_rod).pattern("I").pattern("I").pattern("I").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("iron_rod"), QuarkRecipeProvider.zCond("iron_rod_pre_end")}), "quark:automation/crafting/iron_rod_pre_end");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)NetherBrickFenceGateModule.netherBrickFenceGate).pattern("#W#").pattern("#W#").define(Character.valueOf('#'), Tags.Items.BRICKS_NETHER).define(Character.valueOf('W'), (ItemLike)Blocks.NETHER_BRICKS.asItem()).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("nether_brick_fence_gate")}), "quark:automation/crafting/nether_brick_fence_gate");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)ObsidianPlateModule.obsidian_plate).pattern("OO").define(Character.valueOf('O'), Tags.Items.OBSIDIANS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("obsidian_plate")}), "quark:automation/crafting/obsidian_plate");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)RedstoneRandomizerModule.redstone_randomizer).pattern(" X ").pattern("XBX").pattern("III").define(Character.valueOf('X'), (ItemLike)Items.REDSTONE_TORCH).define(Character.valueOf('I'), (ItemLike)Items.STONE).define(Character.valueOf('B'), (ItemLike)Items.PRISMARINE_CRYSTALS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("redstone_randomizer")}), "quark:automation/crafting/redstone_randomizer");
        for (Map.Entry<Block, Block> chestEntry : VariantChestsModule.regularChests.entrySet()) {
            cond = QuarkRecipeProvider.zCond("variant_chests");
            dir = "quark:building/chests/" + BuiltInRegistries.BLOCK.getKey((Object)chestEntry.getValue()).getPath();
            for (WoodSetHandler.WoodSet set : DataUtil.QuarkWorldWoodSets) {
                if (chestEntry.getKey() != set.planks) continue;
                dir = "quark:world/crafting/woodsets/" + set.name + "/" + set.name + "_chest";
                cond = this.and(new ICondition[]{QuarkRecipeProvider.zCond("variant_chests"), QuarkRecipeProvider.zCond(set.name + "_wood")});
                if (set != BlossomTreesModule.woodSet) continue;
                cond = this.and(new ICondition[]{QuarkRecipeProvider.zCond("variant_chests"), QuarkRecipeProvider.zCond("blossom_trees")});
            }
            QuarkRecipeProvider.chestRecipe((ItemLike)chestEntry.getValue().asItem(), (ItemLike)chestEntry.getKey()).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{cond}), dir);
        }
        for (Map.Entry<Block, Block> chestEntry : VariantChestsModule.trappedChests.entrySet()) {
            cond = QuarkRecipeProvider.zCond("variant_chests");
            dir = "quark:building/chests/" + BuiltInRegistries.BLOCK.getKey((Object)chestEntry.getValue()).getPath();
            for (WoodSetHandler.WoodSet set : DataUtil.QuarkWorldWoodSets) {
                if (chestEntry.getKey() != set.planks) continue;
                dir = "quark:world/crafting/woodsets/" + set.name + "/" + set.name + "_trapped_chest";
                cond = this.and(new ICondition[]{QuarkRecipeProvider.zCond("variant_chests"), QuarkRecipeProvider.zCond(set.name + "_wood")});
                if (set != BlossomTreesModule.woodSet) continue;
                cond = this.and(new ICondition[]{QuarkRecipeProvider.zCond("variant_chests"), QuarkRecipeProvider.zCond("blossom_trees")});
            }
            QuarkRecipeProvider.trappedChestRecipe((ItemLike)chestEntry.getValue(), (ItemLike)DataUtil.getChestFromTrappedChest(chestEntry.getValue())).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{cond}), dir);
        }
        for (Map.Entry<Block, Block> chestEntry : VariantChestsModule.regularChests.entrySet()) {
            cond = this.and(new ICondition[]{QuarkRecipeProvider.zCond("variant_chests"), QuarkRecipeProvider.zCond("wood_to_chest_recipes")});
            dir = "quark:building/chests/" + BuiltInRegistries.BLOCK.getKey((Object)chestEntry.getValue()).getPath() + "_wood";
            for (WoodSetHandler.WoodSet set : DataUtil.QuarkWorldWoodSets) {
                if (chestEntry.getKey() != set.planks) continue;
                dir = "quark:world/crafting/woodsets/" + set.name + "/" + set.name + "_chest_wood";
                cond = this.and(new ICondition[]{QuarkRecipeProvider.zCond("variant_chests"), QuarkRecipeProvider.zCond("wood_to_chest_recipes"), QuarkRecipeProvider.zCond(set.name + "_wood")});
                if (set != BlossomTreesModule.woodSet) continue;
                cond = this.and(new ICondition[]{QuarkRecipeProvider.zCond("variant_chests"), QuarkRecipeProvider.zCond("wood_to_chest_recipes"), QuarkRecipeProvider.zCond("blossom_trees")});
            }
            if (chestEntry.getKey() == Blocks.BAMBOO_PLANKS || !chestEntry.getKey().getDescriptionId().contains("planks")) continue;
            QuarkRecipeProvider.fourChestRecipe((ItemLike)chestEntry.getValue().asItem(), DataUtil.getLogTagFromPlank(chestEntry.getKey())).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{cond}), dir);
        }
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.CHEST).requires(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Quark.asResource("revertable_chests"))).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("chest_reversion")}), "quark:building/crafting/chest_revert");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.TRAPPED_CHEST).requires(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Quark.asResource("revertable_trapped_chests"))).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("chest_reversion")}), "quark:building/crafting/trapped_chest_revert");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.APPLE, (ItemLike)CompressedBlocksModule.apple, recipeOutput, null, "apple_crate");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.BEETROOT, (ItemLike)CompressedBlocksModule.beetroot, recipeOutput, null, "beetroot_crate");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.SWEET_BERRIES, (ItemLike)CompressedBlocksModule.berry, recipeOutput, null, "berry_sack");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.LEATHER, (ItemLike)CompressedBlocksModule.leather, recipeOutput, null, "bonded_leather");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.RABBIT_HIDE, (ItemLike)CompressedBlocksModule.hide, recipeOutput, null, "bonded_rabbit_hide");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.CACTUS, (ItemLike)CompressedBlocksModule.cactus, recipeOutput, null, "cactus_block");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.CARROT, (ItemLike)CompressedBlocksModule.carrot, recipeOutput, null, "carrot_crate");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.CHARCOAL, (ItemLike)CompressedBlocksModule.charcoal_block, recipeOutput, null, "charcoal_block");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.CHORUS_FRUIT, (ItemLike)CompressedBlocksModule.chorus, recipeOutput, null, "chorus_fruit_block");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.COCOA_BEANS, (ItemLike)CompressedBlocksModule.cocoa, recipeOutput, null, "cocoa_beans_sack");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.GLOW_BERRIES, (ItemLike)CompressedBlocksModule.glowberry, recipeOutput, null, "glowberry_sack");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.GOLDEN_APPLE, (ItemLike)CompressedBlocksModule.golden_apple_crate, recipeOutput, null, "golden_apple_crate");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.GOLDEN_CARROT, (ItemLike)CompressedBlocksModule.golden_carrot, recipeOutput, null, "golden_carrot_crate");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.GUNPOWDER, (ItemLike)CompressedBlocksModule.gunpowder, recipeOutput, null, "gunpowder_sack");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.NETHER_WART_BLOCK).requires((ItemLike)Items.NETHER_WART).requires((ItemLike)Items.NETHER_WART).requires((ItemLike)Items.NETHER_WART).requires((ItemLike)Items.NETHER_WART).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("nether_wart_sack")}), "quark:building/crafting/compressed/vanilla_nether_wart_block_4x4");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.NETHER_WART, (ItemLike)CompressedBlocksModule.wart, recipeOutput, null, "nether_wart_sack");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.POTATO, (ItemLike)CompressedBlocksModule.potato, recipeOutput, null, "potato_crate");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.STICK, (ItemLike)CompressedBlocksModule.stick_block, recipeOutput, null, "stick_block");
        QuarkRecipeProvider.compressUncompress((ItemLike)Items.SUGAR_CANE, (ItemLike)CompressedBlocksModule.sugarCane, recipeOutput, null, "sugar_cane_block");
        QuarkRecipeProvider.variantFurnace((ItemLike)Blocks.BLACKSTONE, VariantFurnacesModule.blackstoneFurnace, recipeOutput, "blackstone");
        QuarkRecipeProvider.variantFurnace((ItemLike)Blocks.DEEPSLATE, VariantFurnacesModule.deepslateFurnace, recipeOutput, "deepslate");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)FramedGlassModule.framed_glass, (int)8).pattern("IGI").pattern("G G").pattern("IGI").define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS_COLORLESS).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("framed_glass")}), "quark:building/crafting/glass/framed_glass");
        for (DyeColor dyeColor : FramedGlassModule.blockMap.keySet()) {
            QuarkRecipeProvider.dyedFramedGlassRecipe((ItemLike)FramedGlassModule.blockMap.get(dyeColor).getBlock(), dyeColor).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("framed_glass")}), "quark:building/glass/" + dyeColor.getName() + "_framed_glass");
        }
        for (Block sourceLog : HollowLogsModule.logMap.keySet()) {
            FlagCondition condition = QuarkRecipeProvider.zCond("hollow_logs");
            if (sourceLog.getDescriptionId().contains("ancient")) {
                condition = this.and(new ICondition[]{QuarkRecipeProvider.zCond("hollow_logs"), QuarkRecipeProvider.zCond("ancient_wood")});
            } else if (sourceLog.getDescriptionId().contains("azalea")) {
                condition = this.and(new ICondition[]{QuarkRecipeProvider.zCond("hollow_logs"), QuarkRecipeProvider.zCond("azalea_wood")});
            }
            QuarkRecipeProvider.hollowLogRecipe((ItemLike)HollowLogsModule.logMap.get(sourceLog), (ItemLike)sourceLog).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{condition}), "quark:building/crafting/hollowlogs/hollow_" + sourceLog.getDescriptionId().replaceAll("block..*.[.]", ""));
        }
        for (RainbowLampBlock rbl : RainbowLampsModule.lamps) {
            CorundumColor color = RainbowLampsModule.lampMap.get((Object)rbl);
            QuarkRecipeProvider.corundomLampRecipe((ItemLike)rbl, color).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("rainbow_lamps"), QuarkRecipeProvider.zCond("corundum"), QuarkRecipeProvider.zCond("rainbow_lamp_corundum")}), "quark:building/crafting/lamps/" + color.name + "_corundum_lamp");
            QuarkRecipeProvider.crystalLampRecipe((ItemLike)rbl, color).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("rainbow_lamps"), this.or(new ICondition[]{this.not((ICondition)QuarkRecipeProvider.zCond("corundum")), this.not((ICondition)QuarkRecipeProvider.zCond("rainbow_lamp_corundum"))})}), "quark:building/crafting/lamps/" + color.name + "_crsytal_lamp");
        }
        for (DyeColor dyeColor : FramedGlassModule.paneMap.keySet()) {
            QuarkRecipeProvider.paneRecipe((ItemLike)FramedGlassModule.paneMap.get(dyeColor).getBlock(), (ItemLike)FramedGlassModule.blockMap.get(dyeColor).getBlock()).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("framed_glass")}), "quark:building/panes/" + dyeColor.getName() + "_framed_glass_pane");
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)JapanesePaletteModule.paperWall, (int)6).pattern("###").pattern("PPP").pattern("###").define(Character.valueOf('#'), (ItemLike)Items.BAMBOO).define(Character.valueOf('P'), (ItemLike)Items.PAPER).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("paper_decor")}), "quark:building/crafting/panes/paper_wall");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)JapanesePaletteModule.paperWallBig, (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)JapanesePaletteModule.paperWall).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("paper_decor")}), "quark:building/crafting/panes/paper_wall_big");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)JapanesePaletteModule.paperWallSakura).requires((ItemLike)JapanesePaletteModule.paperWall).requires(ItemTags.SAPLINGS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("paper_decor")}), "quark:building/crafting/panes/paper_wall_sakura");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)JapanesePaletteModule.paperLantern.getBlock()).pattern("PSP").pattern("PGP").pattern("PSP").define(Character.valueOf('P'), (ItemLike)Items.PAPER).define(Character.valueOf('S'), (ItemLike)Items.BAMBOO).define(Character.valueOf('G'), Tags.Items.DUSTS_GLOWSTONE).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("paper_decor")}), "quark:building/crafting/paper_lantern");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)JapanesePaletteModule.paperLanternSakura.getBlock()).requires((ItemLike)JapanesePaletteModule.paperLantern.getBlock()).requires(ItemTags.SAPLINGS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("paper_decor")}), "quark:building/crafting/paper_lantern_sakura");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ShinglesModule.blocks.getFirst()), (int)2).pattern("##").define(Character.valueOf('#'), (ItemLike)Blocks.TERRACOTTA).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("shingles")}), "quark:building/crafting/shingles/shingles");
        for (DyeColor dyeColor : ShinglesModule.blockMap.keySet()) {
            QuarkRecipeProvider.colorShingles((ItemLike)ShinglesModule.blockMap.get(dyeColor).getBlock(), dyeColor, recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("shingles")}));
        }
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(IndustrialPaletteModule.blocks.get(0))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)IndustrialPaletteModule.blocks.get(0)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)IndustrialPaletteModule.blocks.get(0))), QuarkRecipeProvider.has((ItemLike)((ItemLike)IndustrialPaletteModule.blocks.get(0)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("iron_plates")}), "quark:building/crafting/slabs/iron_plate_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(IndustrialPaletteModule.blocks.get(1))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)IndustrialPaletteModule.blocks.get(1)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)IndustrialPaletteModule.blocks.get(1))), QuarkRecipeProvider.has((ItemLike)((ItemLike)IndustrialPaletteModule.blocks.get(1)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("iron_plates")}), "quark:building/crafting/slabs/rusty_iron_plate_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get((Object)ThatchModule.thatch)), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ThatchModule.thatch})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)ThatchModule.thatch), QuarkRecipeProvider.has((ItemLike)ThatchModule.thatch)).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("thatch")}), "quark:building/crafting/slabs/thatch_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(DuskboundBlocksModule.blocks.get(0))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)DuskboundBlocksModule.blocks.get(0)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)DuskboundBlocksModule.blocks.get(0))), QuarkRecipeProvider.has((ItemLike)((ItemLike)DuskboundBlocksModule.blocks.get(0)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("duskbound_blocks")}), "quark:building/crafting/slabs/duskbound_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(ShinglesModule.blocks.getFirst())), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ShinglesModule.blocks.getFirst()})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)ShinglesModule.blocks.getFirst())), QuarkRecipeProvider.has((ItemLike)((ItemLike)ShinglesModule.blocks.getFirst()))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("shingles")}), "quark:building/crafting/slabs/shingles_slab");
        for (DyeColor dyeColor : ShinglesModule.blockMap.keySet()) {
            QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(ShinglesModule.blockMap.get(dyeColor))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ShinglesModule.blockMap.get(dyeColor).getBlock().asItem()})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)ShinglesModule.blockMap.get(dyeColor).getBlock().asItem()), QuarkRecipeProvider.has((ItemLike)ShinglesModule.blockMap.get(dyeColor).getBlock().asItem())).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("shingles")}), "quark:building/crafting/slabs/" + dyeColor.getName() + "_shingles_slab");
        }
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreBrickTypesModule.blocks.get(0))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreBrickTypesModule.blocks.get(0)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(0))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(0)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("blue_nether_bricks")}), "quark:building/crafting/slabs/blue_nether_bricks_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreBrickTypesModule.blocks.get(1))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreBrickTypesModule.blocks.get(1)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(1))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(1)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("sandstone_bricks")}), "quark:building/crafting/slabs/sandstone_bricks_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreBrickTypesModule.blocks.get(2))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreBrickTypesModule.blocks.get(2)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(2))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(2)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("sandstone_bricks")}), "quark:building/crafting/slabs/red_sandstone_bricks_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreBrickTypesModule.blocks.get(3))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreBrickTypesModule.blocks.get(3)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(3))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(3)))).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("soul_sandstone"), QuarkRecipeProvider.zCond("sandstone_bricks")})}), "quark:building/crafting/slabs/soul_sandstone_bricks_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreBrickTypesModule.blocks.get(4))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreBrickTypesModule.blocks.get(4)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(4))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(4)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("cobblestone_bricks")}), "quark:building/crafting/slabs/cobblestone_bricks_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreBrickTypesModule.blocks.get(5))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreBrickTypesModule.blocks.get(5)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(5))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(5)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("cobblestone_bricks")}), "quark:building/crafting/slabs/mossy_cobblestone_bricks_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreBrickTypesModule.blocks.get(6))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreBrickTypesModule.blocks.get(6)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(6))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(6)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("blackstone_bricks")}), "quark:building/crafting/slabs/blackstone_bricks_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreBrickTypesModule.blocks.get(7))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreBrickTypesModule.blocks.get(7)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(7))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(7)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("dirt_bricks")}), "quark:building/crafting/slabs/dirt_bricks_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreBrickTypesModule.blocks.get(8))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreBrickTypesModule.blocks.get(8)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(8))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(8)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("netherrack_bricks")}), "quark:building/crafting/slabs/netherrack_bricks_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(SoulSandstoneModule.blocks.get(0))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)SoulSandstoneModule.blocks.get(0)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)SoulSandstoneModule.blocks.get(0))), QuarkRecipeProvider.has((ItemLike)((ItemLike)SoulSandstoneModule.blocks.get(0)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("soul_sandstone")}), "quark:building/crafting/slabs/soul_sandstone_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(SoulSandstoneModule.blocks.get(2))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)SoulSandstoneModule.blocks.get(2)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)SoulSandstoneModule.blocks.get(2))), QuarkRecipeProvider.has((ItemLike)((ItemLike)SoulSandstoneModule.blocks.get(2)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("soul_sandstone")}), "quark:building/crafting/slabs/cut_soul_sandstone_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(SoulSandstoneModule.blocks.get(3))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)SoulSandstoneModule.blocks.get(3)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)SoulSandstoneModule.blocks.get(3))), QuarkRecipeProvider.has((ItemLike)((ItemLike)SoulSandstoneModule.blocks.get(3)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("soul_sandstone")}), "quark:building/crafting/slabs/smooth_soul_sandstone_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(RawMetalBricksModule.blocks.get(0))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RawMetalBricksModule.blocks.get(0)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)RawMetalBricksModule.blocks.get(0))), QuarkRecipeProvider.has((ItemLike)((ItemLike)RawMetalBricksModule.blocks.get(0)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("raw_metal_bricks")}), "quark:building/crafting/slabs/raw_iron_bricks_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(RawMetalBricksModule.blocks.get(1))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RawMetalBricksModule.blocks.get(1)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)RawMetalBricksModule.blocks.get(1))), QuarkRecipeProvider.has((ItemLike)((ItemLike)RawMetalBricksModule.blocks.get(1)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("raw_metal_bricks")}), "quark:building/crafting/slabs/raw_gold_bricks_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(RawMetalBricksModule.blocks.get(2))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RawMetalBricksModule.blocks.get(2)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)RawMetalBricksModule.blocks.get(2))), QuarkRecipeProvider.has((ItemLike)((ItemLike)RawMetalBricksModule.blocks.get(2)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("raw_metal_bricks")}), "quark:building/crafting/slabs/raw_copper_bricks_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreStoneVariantsModule.blocks.get(0))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreStoneVariantsModule.blocks.get(0)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(0))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(0)))).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("granite"), QuarkRecipeProvider.zCond("more_stone_variants")})}), "quark:building/crafting/slabs/granite_bricks_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreStoneVariantsModule.blocks.get(3))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreStoneVariantsModule.blocks.get(3)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(3))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(3)))).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("diorite"), QuarkRecipeProvider.zCond("more_stone_variants")})}), "quark:building/crafting/slabs/diorite_bricks_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreStoneVariantsModule.blocks.get(6))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreStoneVariantsModule.blocks.get(6)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(6))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(6)))).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("andesite"), QuarkRecipeProvider.zCond("more_stone_variants")})}), "quark:building/crafting/slabs/andesite_bricks_slab");
        Block calciteSlab = DataUtil.regSearch(Quark.asResource("calcite_slab"));
        Block dripstoneSlab = DataUtil.regSearch(Quark.asResource("dripstone_block_slab"));
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)calciteSlab, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Blocks.CALCITE})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)Blocks.CALCITE), QuarkRecipeProvider.has((ItemLike)Blocks.CALCITE)).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("calcite")}), "quark:building/crafting/slabs/calcite_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)dripstoneSlab, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Blocks.DRIPSTONE_BLOCK})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)Blocks.DRIPSTONE_BLOCK), QuarkRecipeProvider.has((ItemLike)Blocks.DRIPSTONE_BLOCK)).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("dripstone")}), "quark:building/crafting/slabs/dripstone_block_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreStoneVariantsModule.polishedCalcite)), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{MoreStoneVariantsModule.polishedCalcite})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)MoreStoneVariantsModule.polishedCalcite), QuarkRecipeProvider.has((ItemLike)MoreStoneVariantsModule.polishedCalcite)).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("calcite")}), "quark:building/crafting/slabs/polished_calcite_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreStoneVariantsModule.polishedDripstone)), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{MoreStoneVariantsModule.polishedDripstone})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)MoreStoneVariantsModule.polishedDripstone), QuarkRecipeProvider.has((ItemLike)MoreStoneVariantsModule.polishedDripstone)).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("dripstone")}), "quark:building/crafting/slabs/polished_dripstone_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreStoneVariantsModule.blocks.get(9))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreStoneVariantsModule.blocks.get(9)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(9))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(9)))).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("calcite"), QuarkRecipeProvider.zCond("more_stone_variants"), QuarkRecipeProvider.zCond("stone_bricks")})}), "quark:building/crafting/slabs/calcite_bricks_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreStoneVariantsModule.blocks.get(12))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreStoneVariantsModule.blocks.get(12)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(12))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(12)))).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("dripstone"), QuarkRecipeProvider.zCond("more_stone_variants"), QuarkRecipeProvider.zCond("stone_bricks")})}), "quark:building/crafting/slabs/dripstone_bricks_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreStoneVariantsModule.blocks.get(15))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreStoneVariantsModule.blocks.get(15)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(15))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(15)))).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("limestone"), QuarkRecipeProvider.zCond("more_stone_variants")})}), "quark:world/crafting/slabs/limestone_bricks_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreStoneVariantsModule.blocks.get(18))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreStoneVariantsModule.blocks.get(18)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(18))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(18)))).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("jasper"), QuarkRecipeProvider.zCond("more_stone_variants")})}), "quark:world/crafting/slabs/jasper_bricks_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreStoneVariantsModule.blocks.get(21))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreStoneVariantsModule.blocks.get(21)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(21))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(21)))).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("shale"), QuarkRecipeProvider.zCond("more_stone_variants")})}), "quark:world/crafting/slabs/shale_bricks_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreStoneVariantsModule.blocks.get(24))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreStoneVariantsModule.blocks.get(24)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(24))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(24)))).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("myalite"), QuarkRecipeProvider.zCond("more_stone_variants")})}), "quark:world/crafting/slabs/myalite_bricks_slab");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(MidoriModule.blocks.get(0))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MidoriModule.blocks.get(0)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MidoriModule.blocks.get(0))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MidoriModule.blocks.get(0)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("midori")}), "quark:world/crafting/slabs/midori_block_slab");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(IndustrialPaletteModule.blocks.get(0))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)IndustrialPaletteModule.blocks.get(0)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)IndustrialPaletteModule.blocks.get(0))), QuarkRecipeProvider.has((ItemLike)((ItemLike)IndustrialPaletteModule.blocks.get(0)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("iron_plates")}), "quark:building/crafting/stairs/iron_plate_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(IndustrialPaletteModule.blocks.get(1))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)IndustrialPaletteModule.blocks.get(1)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)IndustrialPaletteModule.blocks.get(1))), QuarkRecipeProvider.has((ItemLike)((ItemLike)IndustrialPaletteModule.blocks.get(1)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("iron_plates")}), "quark:building/crafting/stairs/rusty_iron_plate_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get((Object)ThatchModule.thatch)), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ThatchModule.thatch})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)ThatchModule.thatch), QuarkRecipeProvider.has((ItemLike)ThatchModule.thatch)).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("thatch")}), "quark:building/crafting/stairs/thatch_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(DuskboundBlocksModule.blocks.get(0))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)DuskboundBlocksModule.blocks.get(0)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)DuskboundBlocksModule.blocks.get(0))), QuarkRecipeProvider.has((ItemLike)((ItemLike)DuskboundBlocksModule.blocks.get(0)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("duskbound_blocks")}), "quark:building/crafting/stairs/duskbound_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(ShinglesModule.blocks.getFirst())), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ShinglesModule.blocks.getFirst()})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)ShinglesModule.blocks.getFirst())), QuarkRecipeProvider.has((ItemLike)((ItemLike)ShinglesModule.blocks.getFirst()))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("shingles")}), "quark:building/crafting/stairs/shingles_stairs");
        for (DyeColor dyeColor : ShinglesModule.blockMap.keySet()) {
            QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(ShinglesModule.blockMap.get(dyeColor))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ShinglesModule.blockMap.get(dyeColor).getBlock().asItem()})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)ShinglesModule.blockMap.get(dyeColor).getBlock().asItem()), QuarkRecipeProvider.has((ItemLike)ShinglesModule.blockMap.get(dyeColor).getBlock().asItem())).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("shingles")}), "quark:building/crafting/stairs/" + dyeColor.getName() + "_shingles_stairs");
        }
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(MoreBrickTypesModule.blocks.get(0))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreBrickTypesModule.blocks.get(0)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(0))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(0)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("blue_nether_bricks")}), "quark:building/crafting/stairs/blue_nether_bricks_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(MoreBrickTypesModule.blocks.get(1))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreBrickTypesModule.blocks.get(1)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(1))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(1)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("sandstone_bricks")}), "quark:building/crafting/stairs/sandstone_bricks_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(MoreBrickTypesModule.blocks.get(2))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreBrickTypesModule.blocks.get(2)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(2))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(2)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("sandstone_bricks")}), "quark:building/crafting/stairs/red_sandstone_bricks_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(MoreBrickTypesModule.blocks.get(3))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreBrickTypesModule.blocks.get(3)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(3))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(3)))).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("soul_sandstone"), QuarkRecipeProvider.zCond("sandstone_bricks")})}), "quark:building/crafting/stairs/soul_sandstone_bricks_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(MoreBrickTypesModule.blocks.get(4))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreBrickTypesModule.blocks.get(4)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(4))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(4)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("cobblestone_bricks")}), "quark:building/crafting/stairs/cobblestone_bricks_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(MoreBrickTypesModule.blocks.get(5))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreBrickTypesModule.blocks.get(5)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(5))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(5)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("cobblestone_bricks")}), "quark:building/crafting/stairs/mossy_cobblestone_bricks_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(MoreBrickTypesModule.blocks.get(6))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreBrickTypesModule.blocks.get(6)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(6))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(6)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("blackstone_bricks")}), "quark:building/crafting/stairs/blackstone_bricks_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(MoreBrickTypesModule.blocks.get(7))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreBrickTypesModule.blocks.get(7)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(7))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(7)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("dirt_bricks")}), "quark:building/crafting/stairs/dirt_bricks_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(MoreBrickTypesModule.blocks.get(8))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreBrickTypesModule.blocks.get(8)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(8))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(8)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("netherrack_bricks")}), "quark:building/crafting/stairs/netherrack_bricks_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(SoulSandstoneModule.blocks.get(0))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)SoulSandstoneModule.blocks.get(0)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)SoulSandstoneModule.blocks.get(0))), QuarkRecipeProvider.has((ItemLike)((ItemLike)SoulSandstoneModule.blocks.get(0)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("soul_sandstone")}), "quark:building/crafting/stairs/soul_sandstone_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(SoulSandstoneModule.blocks.get(3))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)SoulSandstoneModule.blocks.get(3)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)SoulSandstoneModule.blocks.get(3))), QuarkRecipeProvider.has((ItemLike)((ItemLike)SoulSandstoneModule.blocks.get(3)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("soul_sandstone")}), "quark:building/crafting/stairs/smooth_soul_sandstone_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(RawMetalBricksModule.blocks.get(0))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RawMetalBricksModule.blocks.get(0)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)RawMetalBricksModule.blocks.get(0))), QuarkRecipeProvider.has((ItemLike)((ItemLike)RawMetalBricksModule.blocks.get(0)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("raw_metal_bricks")}), "quark:building/crafting/stairs/raw_iron_bricks_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(RawMetalBricksModule.blocks.get(1))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RawMetalBricksModule.blocks.get(1)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)RawMetalBricksModule.blocks.get(1))), QuarkRecipeProvider.has((ItemLike)((ItemLike)RawMetalBricksModule.blocks.get(1)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("raw_metal_bricks")}), "quark:building/crafting/stairs/raw_gold_bricks_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(RawMetalBricksModule.blocks.get(2))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RawMetalBricksModule.blocks.get(2)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)RawMetalBricksModule.blocks.get(2))), QuarkRecipeProvider.has((ItemLike)((ItemLike)RawMetalBricksModule.blocks.get(2)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("raw_metal_bricks")}), "quark:building/crafting/stairs/raw_copper_bricks_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(MoreStoneVariantsModule.blocks.get(0))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreStoneVariantsModule.blocks.get(0)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(0))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(0)))).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("granite"), QuarkRecipeProvider.zCond("more_stone_variants")})}), "quark:building/crafting/stairs/granite_bricks_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(MoreStoneVariantsModule.blocks.get(3))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreStoneVariantsModule.blocks.get(3)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(3))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(3)))).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("diorite"), QuarkRecipeProvider.zCond("more_stone_variants")})}), "quark:building/crafting/stairs/diorite_bricks_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(MoreStoneVariantsModule.blocks.get(6))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreStoneVariantsModule.blocks.get(6)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(6))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(6)))).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("andesite"), QuarkRecipeProvider.zCond("more_stone_variants")})}), "quark:building/crafting/stairs/andesite_bricks_stairs");
        Block calciteStairs = DataUtil.regSearch(Quark.asResource("calcite_stairs"));
        Block dripstoneStairs = DataUtil.regSearch(Quark.asResource("dripstone_block_stairs"));
        QuarkRecipeProvider.stairBuilder((ItemLike)calciteStairs, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Blocks.CALCITE})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)Blocks.CALCITE), QuarkRecipeProvider.has((ItemLike)Blocks.CALCITE)).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("calcite")}), "quark:building/crafting/slabs/calcite_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)dripstoneStairs, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Blocks.DRIPSTONE_BLOCK})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)Blocks.DRIPSTONE_BLOCK), QuarkRecipeProvider.has((ItemLike)Blocks.DRIPSTONE_BLOCK)).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("dripstone")}), "quark:building/crafting/slabs/dripstone_block_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(MoreStoneVariantsModule.polishedCalcite)), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{MoreStoneVariantsModule.polishedCalcite})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(MoreStoneVariantsModule.polishedCalcite))), QuarkRecipeProvider.has((ItemLike)MoreStoneVariantsModule.polishedCalcite)).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("calcite")}), "quark:building/crafting/slabs/polished_calcite_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(MoreStoneVariantsModule.polishedDripstone)), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{MoreStoneVariantsModule.polishedDripstone})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)MoreStoneVariantsModule.polishedDripstone), QuarkRecipeProvider.has((ItemLike)MoreStoneVariantsModule.polishedDripstone)).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("dripstone")}), "quark:building/crafting/slabs/polished_dripstone_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(MoreStoneVariantsModule.blocks.get(9))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreStoneVariantsModule.blocks.get(9)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(9))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(9)))).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("calcite"), QuarkRecipeProvider.zCond("more_stone_variants")})}), "quark:building/crafting/stairs/calcite_bricks_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(MoreStoneVariantsModule.blocks.get(12))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreStoneVariantsModule.blocks.get(12)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(12))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(12)))).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("dripstone"), QuarkRecipeProvider.zCond("more_stone_variants")})}), "quark:building/crafting/stairs/dripstone_bricks_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(MoreStoneVariantsModule.blocks.get(15))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreStoneVariantsModule.blocks.get(15)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(15))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(15)))).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("limestone"), QuarkRecipeProvider.zCond("more_stone_variants")})}), "quark:world/crafting/stairs/limestone_bricks_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(MoreStoneVariantsModule.blocks.get(18))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreStoneVariantsModule.blocks.get(18)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(18))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(18)))).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("jasper"), QuarkRecipeProvider.zCond("more_stone_variants")})}), "quark:world/crafting/stairs/jasper_bricks_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(MoreStoneVariantsModule.blocks.get(21))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreStoneVariantsModule.blocks.get(21)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(21))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(21)))).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("shale"), QuarkRecipeProvider.zCond("more_stone_variants")})}), "quark:world/crafting/stairs/shale_bricks_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(MoreStoneVariantsModule.blocks.get(24))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MoreStoneVariantsModule.blocks.get(24)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(24))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(24)))).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("myalite"), QuarkRecipeProvider.zCond("more_stone_variants")})}), "quark:world/crafting/stairs/myalite_bricks_stairs");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(MidoriModule.blocks.get(0))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MidoriModule.blocks.get(0)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)MidoriModule.blocks.get(0))), QuarkRecipeProvider.has((ItemLike)((ItemLike)MidoriModule.blocks.get(0)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("midori")}), "quark:world/crafting/stairs/midori_block_slab");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)MoreStoneVariantsModule.polishedCalcite, (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)Blocks.CALCITE).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("calcite")}), "quark:building/crafting/stonevariants/polished_calcite");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(9)), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)MoreStoneVariantsModule.polishedCalcite).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("stone_bricks"), QuarkRecipeProvider.zCond("calcite")})}), "quark:building/crafting/stonevariants/calcite_bricks");
        this.stoneVariantsChiseledAndPillar("calcite", (ICondition)QuarkRecipeProvider.zCond("calcite"), (ItemLike)MoreStoneVariantsModule.blocks.get(10), (ItemLike)MoreStoneVariantsModule.blocks.get(11), (ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreStoneVariantsModule.blocks.get(9)), (ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreStoneVariantsModule.polishedCalcite), recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)MoreStoneVariantsModule.polishedDripstone, (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)Blocks.DRIPSTONE_BLOCK).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("dripstone")}), "quark:building/crafting/stonevariants/polished_dripstone");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(12)), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)MoreStoneVariantsModule.polishedDripstone).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("stone_bricks"), QuarkRecipeProvider.zCond("dripstone")})}), "quark:building/crafting/stonevariants/dripstone_bricks");
        this.stoneVariantsChiseledAndPillar("dripstone", (ICondition)QuarkRecipeProvider.zCond("dripstone"), (ItemLike)MoreStoneVariantsModule.blocks.get(13), (ItemLike)MoreStoneVariantsModule.blocks.get(14), (ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreStoneVariantsModule.blocks.get(12)), (ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreStoneVariantsModule.polishedDripstone), recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(0)), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)Blocks.POLISHED_GRANITE).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("stone_bricks"), QuarkRecipeProvider.zCond("granite")})}), "quark:building/crafting/stonevariants/granite_bricks");
        this.stoneVariantsChiseledAndPillar("granite", (ICondition)QuarkRecipeProvider.zCond("granite"), (ItemLike)MoreStoneVariantsModule.blocks.get(1), (ItemLike)MoreStoneVariantsModule.blocks.get(2), (ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreStoneVariantsModule.blocks.get(0)), (ItemLike)Blocks.POLISHED_GRANITE_SLAB, recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(3)), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)Blocks.POLISHED_DIORITE).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("stone_bricks"), QuarkRecipeProvider.zCond("diorite")})}), "quark:building/crafting/stonevariants/diorite_bricks");
        this.stoneVariantsChiseledAndPillar("diorite", (ICondition)QuarkRecipeProvider.zCond("diorite"), (ItemLike)MoreStoneVariantsModule.blocks.get(4), (ItemLike)MoreStoneVariantsModule.blocks.get(5), (ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreStoneVariantsModule.blocks.get(3)), (ItemLike)Blocks.POLISHED_DIORITE_SLAB, recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(6)), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)Blocks.POLISHED_ANDESITE).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("stone_bricks"), QuarkRecipeProvider.zCond("andesite")})}), "quark:building/crafting/stonevariants/andesite_bricks");
        this.stoneVariantsChiseledAndPillar("andesite", (ICondition)QuarkRecipeProvider.zCond("andesite"), (ItemLike)MoreStoneVariantsModule.blocks.get(7), (ItemLike)MoreStoneVariantsModule.blocks.get(8), (ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreStoneVariantsModule.blocks.get(6)), (ItemLike)Blocks.POLISHED_ANDESITE_SLAB, recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(15)), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.limestoneBlock)).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("stone_bricks"), QuarkRecipeProvider.zCond("limestone")})}), "quark:building/crafting/stonevariants/worldstones/limestone_bricks");
        this.stoneVariantsChiseledAndPillar("limestone", (ICondition)QuarkRecipeProvider.zCond("limestone"), (ItemLike)MoreStoneVariantsModule.blocks.get(16), (ItemLike)MoreStoneVariantsModule.blocks.get(17), (ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreStoneVariantsModule.blocks.get(15)), (ItemLike)Quark.ZETA.variantRegistry.slabs.get(NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.limestoneBlock)), recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(18)), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.jasperBlock)).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("stone_bricks"), QuarkRecipeProvider.zCond("jasper")})}), "quark:building/crafting/stonevariants/worldstones/jasper_bricks");
        this.stoneVariantsChiseledAndPillar("jasper", (ICondition)QuarkRecipeProvider.zCond("jasper"), (ItemLike)MoreStoneVariantsModule.blocks.get(19), (ItemLike)MoreStoneVariantsModule.blocks.get(20), (ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreStoneVariantsModule.blocks.get(18)), (ItemLike)Quark.ZETA.variantRegistry.slabs.get(NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.jasperBlock)), recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(21)), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.shaleBlock)).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("stone_bricks"), QuarkRecipeProvider.zCond("shale")})}), "quark:building/crafting/stonevariants/worldstones/shale_bricks");
        this.stoneVariantsChiseledAndPillar("shale", (ICondition)QuarkRecipeProvider.zCond("shale"), (ItemLike)MoreStoneVariantsModule.blocks.get(22), (ItemLike)MoreStoneVariantsModule.blocks.get(23), (ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreStoneVariantsModule.blocks.get(21)), (ItemLike)Quark.ZETA.variantRegistry.slabs.get(NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.shaleBlock)), recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MoreStoneVariantsModule.blocks.get(24)), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.myaliteBlock)).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("stone_bricks"), QuarkRecipeProvider.zCond("myalite")})}), "quark:building/crafting/stonevariants/worldstones/myalite_bricks");
        this.stoneVariantsChiseledAndPillar("myalite", (ICondition)QuarkRecipeProvider.zCond("myalite"), (ItemLike)MoreStoneVariantsModule.blocks.get(25), (ItemLike)MoreStoneVariantsModule.blocks.get(25), (ItemLike)Quark.ZETA.variantRegistry.slabs.get(MoreStoneVariantsModule.blocks.get(24)), (ItemLike)Quark.ZETA.variantRegistry.slabs.get(NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.myaliteBlock)), recipeOutput);
        int i = 3;
        for (VanillaWoods.Wood wood : VanillaWoods.ALL) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)VerticalPlanksModule.blocks.get(i)), (int)3).pattern("#").pattern("#").pattern("#").define(Character.valueOf('#'), (ItemLike)wood.planks()).unlockedBy("obtained_planks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{wood.planks()})).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("vertical_planks")}), "quark:building/crafting/vertplanks/vertical_" + wood.name() + "_planks");
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wood.planks()).requires((ItemLike)VerticalPlanksModule.blocks.get(i)).unlockedBy("obtained_vertical_planks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)VerticalPlanksModule.blocks.get(i)})).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("vertical_planks")}), "quark:building/crafting/vertplanks/vertical_" + wood.name() + "_planks_revert");
            ++i;
        }
        i = 0;
        for (WoodSetHandler.WoodSet set : DataUtil.QuarkWorldWoodSets) {
            void var10_32;
            Block block;
            ICondition cond2 = this.and(new ICondition[]{QuarkRecipeProvider.zCond("vertical_planks"), QuarkRecipeProvider.zCond(set.name + "_wood")});
            if (set == BlossomTreesModule.woodSet) {
                cond2 = this.and(new ICondition[]{QuarkRecipeProvider.zCond("vertical_planks"), QuarkRecipeProvider.zCond("blossom_trees")});
            }
            if ((block = set.planks) == AzaleaWoodModule.woodSet.planks) {
                Block block2 = AncientWoodModule.woodSet.planks;
            } else if (block == AncientWoodModule.woodSet.planks) {
                Block block3 = AzaleaWoodModule.woodSet.planks;
            }
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)VerticalPlanksModule.blocks.get(i)), (int)3).pattern("#").pattern("#").pattern("#").define(Character.valueOf('#'), (ItemLike)var10_32).unlockedBy("obtained_planks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{var10_32})).save(recipeOutput.withConditions(new ICondition[]{cond2}), "quark:world/crafting/woodsets/" + set.name + "/vertical_" + set.name + "_planks");
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)var10_32).requires((ItemLike)VerticalPlanksModule.blocks.get(i)).unlockedBy("obtained_vertical_planks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)VerticalPlanksModule.blocks.get(i)})).save(recipeOutput.withConditions(new ICondition[]{cond2}), "quark:world/crafting/woodsets/" + set.name + "/vertical_" + set.name + "_planks_revert");
            ++i;
        }
        for (Block slab : VerticalSlabsModule.blocks.keySet()) {
            FlagCondition condition = QuarkRecipeProvider.zCond("vertical_slabs");
            if (slab.getDescriptionId().contains("ancient")) {
                condition = this.and(new ICondition[]{QuarkRecipeProvider.zCond("vertical_slabs"), QuarkRecipeProvider.zCond("ancient_wood")});
            } else if (slab.getDescriptionId().contains("azalea")) {
                condition = this.and(new ICondition[]{QuarkRecipeProvider.zCond("vertical_slabs"), QuarkRecipeProvider.zCond("azalea_wood")});
            } else if (slab.getDescriptionId().contains("blossom")) {
                condition = this.and(new ICondition[]{QuarkRecipeProvider.zCond("vertical_slabs"), QuarkRecipeProvider.zCond("blossom_trees")});
            } else if (slab.getDescriptionId().contains("soul_sandstone")) {
                condition = this.and(new ICondition[]{QuarkRecipeProvider.zCond("soul_sandstone")});
            }
            String string = BuiltInRegistries.BLOCK.getKey((Object)slab).getPath().replace("_slab", "");
            QuarkRecipeProvider.vertslabRecipe(RecipeCategory.BUILDING_BLOCKS, (ItemLike)VerticalSlabsModule.blocks.get(slab), Ingredient.of((ItemLike[])new ItemLike[]{slab})).unlockedBy("obtained_slab", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{slab.asItem()})).save(recipeOutput.withConditions(new ICondition[]{condition}), "quark:building/crafting/vertslabs/" + string + "_vertical_slab");
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab).requires((ItemLike)VerticalSlabsModule.blocks.get(slab)).unlockedBy("obtained_vertical_slab", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)VerticalPlanksModule.blocks.get(i)})).save(recipeOutput.withConditions(new ICondition[]{condition}), "quark:building/crafting/vertslabs/" + string + "_vertical_slab_revert");
        }
        for (IZetaBlock baseBlock : Quark.ZETA.variantRegistry.walls.keySet()) {
            void var10_57;
            String dir2;
            Block base = baseBlock.getBlock();
            FlagCondition flagCondition = QuarkRecipeProvider.zCond("");
            Block wallBlock = (Block)Quark.ZETA.variantRegistry.walls.get(baseBlock);
            if (base.getDescriptionId().contains("limestone") || base.getDescriptionId().contains("jasper") || base.getDescriptionId().contains("shale") || base.getDescriptionId().contains("myalite") || base.getDescriptionId().contains("myalite") || base.getDescriptionId().contains("permafrost")) {
                String dir22 = "quark:world/crafting/walls/";
                if (base.getDescriptionId().contains("jasper")) {
                    FlagCondition flagCondition2 = QuarkRecipeProvider.zCond("jasper");
                } else if (base.getDescriptionId().contains("limestone")) {
                    FlagCondition flagCondition3 = QuarkRecipeProvider.zCond("limestone");
                } else if (base.getDescriptionId().contains("shale")) {
                    FlagCondition flagCondition4 = QuarkRecipeProvider.zCond("shale");
                } else if (base.getDescriptionId().contains("myalite")) {
                    FlagCondition flagCondition5 = QuarkRecipeProvider.zCond("myalite");
                } else if (base.getDescriptionId().contains("permafrost")) {
                    FlagCondition flagCondition6 = QuarkRecipeProvider.zCond("permafrost");
                }
            } else {
                dir2 = "quark:building/crafting/walls/";
                if (base.getDescriptionId().contains("blackstone_bricks")) {
                    FlagCondition flagCondition7 = QuarkRecipeProvider.zCond("blackstone_bricks");
                } else if (base.getDescriptionId().contains("blue_nether_bricks")) {
                    FlagCondition flagCondition8 = QuarkRecipeProvider.zCond("blue_nether_bricks");
                } else if (base.getDescriptionId().contains("calcite_bricks")) {
                    FlagCondition flagCondition9 = QuarkRecipeProvider.zCond("more_stone_variants");
                } else if (base.getDescriptionId().equals("block.minecraft.calcite")) {
                    FlagCondition flagCondition10 = QuarkRecipeProvider.zCond("calcite");
                } else if (base.getDescriptionId().contains("cobblestone_bricks")) {
                    FlagCondition flagCondition11 = QuarkRecipeProvider.zCond("cobblestone_bricks");
                } else if (base.getDescriptionId().contains("dirt_bricks")) {
                    FlagCondition flagCondition12 = QuarkRecipeProvider.zCond("dirt_bricks");
                } else if (base.getDescriptionId().equals("block.minecraft.dripstone_block")) {
                    FlagCondition flagCondition13 = QuarkRecipeProvider.zCond("dripstone");
                } else if (base.getDescriptionId().contains("dripstone_bricks")) {
                    FlagCondition flagCondition14 = QuarkRecipeProvider.zCond("dripstone");
                } else if (base.getDescriptionId().contains("mossy_cobblestone_bricks")) {
                    FlagCondition flagCondition15 = QuarkRecipeProvider.zCond("cobblestone_bricks");
                } else if (base.getDescriptionId().contains("netherrack_bricks")) {
                    FlagCondition flagCondition16 = QuarkRecipeProvider.zCond("netherrack_bricks");
                } else if (base.getDescriptionId().contains("raw")) {
                    FlagCondition flagCondition17 = QuarkRecipeProvider.zCond("raw_metal_bricks");
                } else if (base.getDescriptionId().contains("sandstone_bricks")) {
                    FlagCondition flagCondition18 = QuarkRecipeProvider.zCond("sandstone_bricks");
                } else if (base.getDescriptionId().contains("soul_sandstone")) {
                    ICondition iCondition = this.and(new ICondition[]{QuarkRecipeProvider.zCond("soul_sandstone"), QuarkRecipeProvider.zCond("sandstone_bricks")});
                } else if (base.getDescriptionId().contains("tuff")) {
                    FlagCondition flagCondition19 = QuarkRecipeProvider.zCond("tuff");
                } else if (base.getDescriptionId().contains("tuff")) {
                    FlagCondition flagCondition20 = QuarkRecipeProvider.zCond("tuff");
                }
            }
            if (Objects.equals(var10_57, QuarkRecipeProvider.zCond(""))) {
                System.out.println("Wall is missing a condition:" + String.valueOf(wallBlock));
            }
            QuarkRecipeProvider.wallBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wallBlock, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{base})).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{var10_57}), dir2 + BuiltInRegistries.BLOCK.getKey((Object)base).getPath() + "_wall");
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.BOOKSHELF).pattern("###").pattern("XXX").pattern("###").define(Character.valueOf('#'), (ItemLike)Blocks.OAK_PLANKS).define(Character.valueOf('X'), (ItemLike)Items.BOOK).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("variant_bookshelves")}), "quark:building/crafting/bookshelves/oak_bookshelf");
        i = 0;
        for (VanillaWoods.Wood wood : VanillaWoods.NON_OAK) {
            String name = wood.name();
            Block plank = wood.planks();
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)VariantBookshelvesModule.variantBookshelves.get(i))).pattern("###").pattern("XXX").pattern("###").define(Character.valueOf('#'), (ItemLike)plank).define(Character.valueOf('X'), (ItemLike)Items.BOOK).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("variant_bookshelves")}), "quark:building/crafting/bookshelves/" + name + "_bookshelf");
            ++i;
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AncientWoodModule.woodSet.bookshelf).pattern("###").pattern("XXX").pattern("###").define(Character.valueOf('#'), (ItemLike)AncientWoodModule.woodSet.planks).define(Character.valueOf('X'), (ItemLike)Items.BOOK).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("variant_bookshelves"), QuarkRecipeProvider.zCond("ancient_wood")})}), "quark:world/crafting/woodsets/ancient/ancient_bookshelf");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AzaleaWoodModule.woodSet.bookshelf).pattern("###").pattern("XXX").pattern("###").define(Character.valueOf('#'), (ItemLike)AzaleaWoodModule.woodSet.planks).define(Character.valueOf('X'), (ItemLike)Items.BOOK).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("variant_bookshelves"), QuarkRecipeProvider.zCond("azalea_wood")})}), "quark:world/crafting/woodsets/ancient/azalea_bookshelf");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BlossomTreesModule.woodSet.bookshelf).pattern("###").pattern("XXX").pattern("###").define(Character.valueOf('#'), (ItemLike)BlossomTreesModule.woodSet.planks).define(Character.valueOf('X'), (ItemLike)Items.BOOK).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("variant_bookshelves"), QuarkRecipeProvider.zCond("blossom_trees")})}), "quark:building/crafting/bookshelves/blossom_bookshelf");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.LECTERN).pattern("SSS").pattern(" B ").pattern(" S ").define(Character.valueOf('S'), ItemTags.WOODEN_SLABS).define(Character.valueOf('B'), Tags.Items.BOOKSHELVES).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("variant_bookshelves")}), "quark:building/crafting/bookshelves/lectern_with_variant_bookshelves");
        i = 0;
        for (VanillaWoods.Wood wood : VanillaWoods.OVERWORLD_WITH_TREE) {
            Block hedge = (Block)HedgesModule.hedges.get(i);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)hedge, (int)2).pattern("L").pattern("W").define(Character.valueOf('L'), (ItemLike)wood.leaf()).define(Character.valueOf('W'), DataUtil.getLogTagFromLog(wood.log())).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("hedges")}), "quark:building/crafting/hedges/" + wood.name() + "_hedge");
            ++i;
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)HedgesModule.hedges.get(8)), (int)2).pattern("L").pattern("W").define(Character.valueOf('L'), (ItemLike)Blocks.AZALEA_LEAVES).define(Character.valueOf('W'), DataUtil.getLogTagFromLog(AzaleaWoodModule.woodSet.log)).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("azalea_wood"), QuarkRecipeProvider.zCond("hedges")})}), "quark:world/crafting/woodsets/azalea/azalea_hedge");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)HedgesModule.hedges.get(9)), (int)2).pattern("L").pattern("W").define(Character.valueOf('L'), (ItemLike)Blocks.FLOWERING_AZALEA_LEAVES).define(Character.valueOf('W'), DataUtil.getLogTagFromLog(AzaleaWoodModule.woodSet.log)).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("azalea_wood"), QuarkRecipeProvider.zCond("hedges")})}), "quark:world/crafting/woodsets/azalea/flowering_azalea_hedge");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)HedgesModule.hedges.get(8)), (int)2).pattern("L").pattern("W").define(Character.valueOf('L'), (ItemLike)Blocks.AZALEA_LEAVES).define(Character.valueOf('W'), ItemTags.OAK_LOGS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{this.not((ICondition)QuarkRecipeProvider.zCond("azalea_wood")), QuarkRecipeProvider.zCond("hedges")})}), "quark:building/crafting/hedges/azalea_hedge_oak");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)HedgesModule.hedges.get(9)), (int)2).pattern("L").pattern("W").define(Character.valueOf('L'), (ItemLike)Blocks.FLOWERING_AZALEA_LEAVES).define(Character.valueOf('W'), ItemTags.OAK_LOGS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{this.not((ICondition)QuarkRecipeProvider.zCond("azalea_wood")), QuarkRecipeProvider.zCond("hedges")})}), "quark:building/crafting/hedges/flowering_azalea_hedge_oak");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)HedgesModule.hedges.get(15)), (int)2).pattern("L").pattern("W").define(Character.valueOf('L'), (ItemLike)AncientWoodModule.ancient_leaves).define(Character.valueOf('W'), DataUtil.getLogTagFromLog(AncientWoodModule.woodSet.log)).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("ancient_wood"), QuarkRecipeProvider.zCond("hedges")})}), "quark:world/crafting/woodsets/ancient/ancient_hedge");
        i = 10;
        for (BlossomTreesModule.BlossomTree tree : BlossomTreesModule.blossomTrees) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)HedgesModule.hedges.get(i)), (int)2).pattern("L").pattern("W").define(Character.valueOf('L'), (ItemLike)tree.leaves).define(Character.valueOf('W'), DataUtil.getLogTagFromLog(BlossomTreesModule.woodSet.log)).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("blossom_trees"), QuarkRecipeProvider.zCond("hedges")})}), "quark:world/crafting/woodsets/blossom/" + tree.name + "_hedge");
            ++i;
        }
        i = 0;
        for (VanillaWoods.Wood wood : VanillaWoods.OVERWORLD_WITH_TREE) {
            Block carpet = (Block)LeafCarpetModule.carpets.get(i);
            ++i;
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)carpet, (int)3).pattern("##").define(Character.valueOf('#'), (ItemLike)wood.leaf()).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("leaf_carpet")}), "quark:building/crafting/leafcarpet/" + wood.name() + "_leaf_carpet");
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)LeafCarpetModule.carpets.get(8)), (int)3).pattern("##").define(Character.valueOf('#'), (ItemLike)Blocks.AZALEA_LEAVES).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("leaf_carpet")}), "quark:building/crafting/leafcarpet/azalea_leaf_carpet");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)LeafCarpetModule.carpets.get(8)), (int)3).pattern("##").define(Character.valueOf('#'), (ItemLike)Blocks.FLOWERING_AZALEA_LEAVES).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("leaf_carpet")}), "quark:building/crafting/leafcarpet/flowering_azalea_leaf_carpet");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)LeafCarpetModule.carpets.get(15)), (int)3).pattern("##").define(Character.valueOf('#'), (ItemLike)AncientWoodModule.ancient_leaves).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("ancient_wood"), QuarkRecipeProvider.zCond("leaf_carpet")})}), "quark:world/crafting/woodsets/ancient/ancient_leaf_carpet");
        i = 10;
        for (BlossomTreesModule.BlossomTree tree : BlossomTreesModule.blossomTrees) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)LeafCarpetModule.carpets.get(i)), (int)3).pattern("##").define(Character.valueOf('#'), (ItemLike)tree.leaves).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("blossom_trees"), QuarkRecipeProvider.zCond("leaf_carpet")})}), "quark:world/crafting/woodsets/blossom/" + tree.name + "_leaf_carpet");
            ++i;
        }
        i = 0;
        for (VanillaWoods.Wood wood : VanillaWoods.ALL) {
            if (wood.name().equals("bamboo")) {
                ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)WoodenPostsModule.blocks.get(i)), (int)8).pattern("F").pattern("F").pattern("F").define(Character.valueOf('F'), (ItemLike)Blocks.BAMBOO_BLOCK).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("wooden_posts")}), "quark:building/crafting/posts/" + wood.name() + "_post");
                ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)WoodenPostsModule.blocks.get(++i)), (int)8).pattern("F").pattern("F").pattern("F").define(Character.valueOf('F'), (ItemLike)Blocks.STRIPPED_BAMBOO_BLOCK).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("wooden_posts")}), "quark:building/crafting/posts/stripped_" + wood.name() + "_post");
                ++i;
                continue;
            }
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)WoodenPostsModule.blocks.get(i)), (int)8).pattern("F").pattern("F").pattern("F").define(Character.valueOf('F'), (ItemLike)wood.wood().asItem()).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("wooden_posts")}), "quark:building/crafting/posts/" + wood.name() + "_post");
            Block stripped = DataUtil.axeStrip(wood.wood());
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)WoodenPostsModule.blocks.get(++i)), (int)8).pattern("F").pattern("F").pattern("F").define(Character.valueOf('F'), (ItemLike)stripped.asItem()).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("wooden_posts")}), "quark:building/crafting/posts/stripped_" + wood.name() + "_post");
            ++i;
        }
        for (WoodSetHandler.WoodSet set : DataUtil.QuarkWorldWoodSets) {
            ICondition cond3 = this.and(new ICondition[]{QuarkRecipeProvider.zCond("wooden_posts"), QuarkRecipeProvider.zCond(set.name + "_wood")});
            if (set == BlossomTreesModule.woodSet) {
                cond3 = this.and(new ICondition[]{QuarkRecipeProvider.zCond("wooden_posts"), QuarkRecipeProvider.zCond("blossom_trees")});
            }
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)set.post, (int)8).pattern("F").pattern("F").pattern("F").define(Character.valueOf('F'), (ItemLike)set.wood.asItem()).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{cond3}), "quark:world/crafting/woodsets/" + set.name + "/" + set.name + "_post");
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)set.strippedPost, (int)8).pattern("F").pattern("F").pattern("F").define(Character.valueOf('F'), (ItemLike)set.strippedWood.asItem()).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{cond3}), "quark:world/crafting/woodsets/" + set.name + "/stripped_" + set.name + "_post");
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.LADDER, (int)4).pattern("# #").pattern("#W#").pattern("# #").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('W'), (ItemLike)Blocks.OAK_PLANKS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("variant_ladders")}), "quark:building/crafting/ladders/oak_ladder");
        i = 0;
        for (VanillaWoods.Wood wood : VanillaWoods.NON_OAK) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)DataUtil.getLadderFromPlank(wood.planks()), (int)4).pattern("# #").pattern("#W#").pattern("# #").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('W'), (ItemLike)wood.planks()).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("variant_ladders")}), "quark:building/crafting/ladders/" + wood.name() + "_ladder");
            ++i;
        }
        for (WoodSetHandler.WoodSet set : DataUtil.QuarkWorldWoodSets) {
            ICondition cond4 = this.and(new ICondition[]{QuarkRecipeProvider.zCond("variant_ladders"), QuarkRecipeProvider.zCond(set.name + "_wood")});
            if (set == BlossomTreesModule.woodSet) {
                cond4 = this.and(new ICondition[]{QuarkRecipeProvider.zCond("variant_ladders"), QuarkRecipeProvider.zCond("blossom_trees")});
            }
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)set.ladder, (int)4).pattern("# #").pattern("#W#").pattern("# #").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('W'), (ItemLike)set.planks).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{cond4}), "quark:world/crafting/woodsets/" + set.name + "/" + set.name + "_ladder");
        }
        i = 0;
        for (DyeColor dyeColor : MiscUtil.CREATIVE_COLOR_ORDER) {
            QuarkRecipeProvider.colorStools((ItemLike)StoolsModule.stools.get(i), dyeColor, recipeOutput);
            ++i;
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)GoldBarsModule.gold_bars, (int)16).pattern("###").pattern("###").define(Character.valueOf('#'), Tags.Items.INGOTS_GOLD).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("gold_bars")}), "quark:building/crafting/gold_bars");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)JapanesePaletteModule.bambooMat, (int)2).pattern("SBS").pattern("BBB").pattern("SBS").define(Character.valueOf('B'), (ItemLike)Items.BAMBOO).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("bamboo_mat")}), "quark:building/crafting/bamboo_mat");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)JapanesePaletteModule.bambooMatCarpet, (int)4).pattern("MM").define(Character.valueOf('M'), (ItemLike)JapanesePaletteModule.bambooMat).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("bamboo_mat")}), "quark:building/crafting/bamboo_mat_carpet");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)IndustrialPaletteModule.blocks.get(3)), (int)3).pattern("N N").pattern("NIN").pattern("N N").define(Character.valueOf('N'), Tags.Items.NUGGETS_IRON).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("iron_ladder")}), "quark:building/crafting/iron_ladder");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)IndustrialPaletteModule.blocks.get(0)), (int)24).pattern("###").pattern("# #").pattern("###").define(Character.valueOf('#'), Tags.Items.INGOTS_IRON).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("iron_plates")}), "quark:building/crafting/iron_plate");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)IndustrialPaletteModule.blocks.get(1)), (int)24).pattern("###").pattern("#W#").pattern("###").define(Character.valueOf('#'), Tags.Items.INGOTS_IRON).define(Character.valueOf('W'), Tags.Items.BUCKETS_WATER).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("iron_plates")}), "quark:building/crafting/rusty_iron_plate");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)IndustrialPaletteModule.blocks.get(1)), (int)8).pattern("###").pattern("#W#").pattern("###").define(Character.valueOf('#'), (ItemLike)IndustrialPaletteModule.blocks.get(0)).define(Character.valueOf('W'), Tags.Items.BUCKETS_WATER).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("iron_plates")}), "quark:building/crafting/rusty_iron_plate_from_iron_plate");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)IndustrialPaletteModule.blocks.get(2)), (int)1).pattern("#").pattern("#").define(Character.valueOf('#'), (ItemLike)Quark.ZETA.variantRegistry.slabs.get(IndustrialPaletteModule.blocks.get(0))).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("iron_plates")}), "quark:building/crafting/iron_pillar");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)RopeModule.rope, (int)3).pattern("##").pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)Items.STRING).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("rope")}), "quark:building/crafting/rope");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)ThatchModule.thatch, (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)Items.WHEAT).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("thatch")}), "quark:building/crafting/thatch");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.WHEAT, (int)1).requires((ItemLike)ThatchModule.thatch).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("thatch")}), "quark:building/crafting/thatch_revert");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)GlassItemFrameModule.glassFrame, (int)2).pattern("###").pattern("#F#").pattern("###").define(Character.valueOf('#'), Tags.Items.GLASS_PANES_COLORLESS).define(Character.valueOf('F'), (ItemLike)Items.ITEM_FRAME).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_item_frame")}), "quark:building/crafting/glass_item_frame");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)GlassItemFrameModule.glowingGlassFrame).requires((ItemLike)Items.GLOW_INK_SAC).requires((ItemLike)GlassItemFrameModule.glassFrame).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_item_frame")}), "quark:building/crafting/glowing_glass_item_frame");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)CompressedBlocksModule.blaze_lantern).pattern("BPB").pattern("PPP").pattern("BPB").define(Character.valueOf('B'), (ItemLike)Items.BLAZE_ROD).define(Character.valueOf('P'), (ItemLike)Items.BLAZE_POWDER).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("blaze_lantern")}), "quark:building/crafting/blaze_lantern");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MoreMudBlocksModule.blocks.get(0)), (int)2).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)Blocks.MUD_BRICK_SLAB).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("more_mud_blocks")}), "quark:building/crafting/carved_mud_bricks");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MoreMudBlocksModule.blocks.get(1)), (int)1).pattern("#").pattern("#").define(Character.valueOf('#'), (ItemLike)Blocks.MUD_BRICK_SLAB).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("more_mud_blocks")}), "quark:building/crafting/mud_pillar");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MoreMudBlocksModule.blocks.get(2)), (int)4).pattern(" # ").pattern("# #").pattern(" # ").define(Character.valueOf('#'), (ItemLike)Blocks.MUD_BRICKS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("more_mud_blocks")}), "quark:building/crafting/mud_brick_lattice");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(0)), (int)2).requires((ItemLike)Blocks.NETHER_BRICKS).requires((ItemLike)Blocks.WARPED_WART_BLOCK).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("blue_nether_bricks")}), "quark:building/crafting/blue_nether_bricks");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(1)), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)Blocks.CUT_SANDSTONE).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("sandstone_bricks")}), "quark:building/crafting/sandstone_bricks");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(2)), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)Blocks.CUT_RED_SANDSTONE).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("sandstone_bricks")}), "quark:building/crafting/red_sandstone_bricks");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(3)), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)SoulSandstoneModule.blocks.get(2)).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("soul_sandstone"), QuarkRecipeProvider.zCond("sandstone_bricks")})}), "quark:building/crafting/soul_sandstone_bricks");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(4)), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)Blocks.COBBLESTONE).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("cobblestone_bricks")}), "quark:building/crafting/cobblestone_bricks");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(5)), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)Blocks.MOSSY_COBBLESTONE).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("cobblestone_bricks")}), "quark:building/crafting/mossy_cobblestone_bricks");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(6)), (int)4).pattern("C#").pattern("##").define(Character.valueOf('C'), (ItemLike)MoreBrickTypesModule.blocks.get(4)).define(Character.valueOf('#'), (ItemLike)Blocks.BLACKSTONE).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("blackstone_bricks")}), "quark:building/crafting/blackstone_bricks");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(7)), (int)4).pattern("C#").pattern("##").define(Character.valueOf('C'), (ItemLike)MoreBrickTypesModule.blocks.get(4)).define(Character.valueOf('#'), (ItemLike)Blocks.DIRT).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("dirt_bricks")}), "quark:building/crafting/dirt_bricks");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MoreBrickTypesModule.blocks.get(8)), (int)4).pattern("C#").pattern("##").define(Character.valueOf('C'), (ItemLike)MoreBrickTypesModule.blocks.get(4)).define(Character.valueOf('#'), (ItemLike)Blocks.NETHERRACK).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("netherrack_bricks")}), "quark:building/crafting/netherrack_bricks");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)DuskboundBlocksModule.blocks.get(0)), (int)16).pattern("PPP").pattern("POP").pattern("PPP").define(Character.valueOf('P'), (ItemLike)Blocks.PURPUR_BLOCK).define(Character.valueOf('O'), (ItemLike)SpiralSpiresModule.dusky_myalite).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("duskbound_blocks"), QuarkRecipeProvider.zCond("spiral_spires")})}), "quark:building/crafting/duskbound_block");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)DuskboundBlocksModule.blocks.get(0)), (int)16).pattern("PPP").pattern("POP").pattern("PPP").define(Character.valueOf('P'), (ItemLike)Blocks.PURPUR_BLOCK).define(Character.valueOf('O'), (ItemLike)Blocks.OBSIDIAN).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("duskbound_blocks"), this.not((ICondition)QuarkRecipeProvider.zCond("spiral_spires"))})}), "quark:building/crafting/duskbound_block_without_myalite");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)DuskboundBlocksModule.blocks.get(1)), (int)4).pattern("DDD").pattern("DED").pattern("DDD").define(Character.valueOf('D'), (ItemLike)DuskboundBlocksModule.blocks.get(0)).define(Character.valueOf('E'), (ItemLike)Items.ENDER_PEARL).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("duskbound_blocks")}), "quark:building/crafting/duskbound_lantern");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SoulSandstoneModule.blocks.get(0))).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)Blocks.SOUL_SAND).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("soul_sandstone")}), "quark:building/crafting/soul_sandstone");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SoulSandstoneModule.blocks.get(1))).pattern("#").pattern("#").define(Character.valueOf('#'), (ItemLike)SoulSandstoneModule.blocks.get(0)).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("soul_sandstone")}), "quark:building/crafting/chiseled_soul_sandstone");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SoulSandstoneModule.blocks.get(3))).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)SoulSandstoneModule.blocks.get(0)).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("soul_sandstone")}), "quark:building/crafting/cut_soul_sandstone");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)GrateModule.grate).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)Blocks.IRON_BARS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("grate")}), "quark:building/crafting/grate");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)SturdyStoneModule.sturdy_stone).pattern("CCC").pattern("CCC").pattern("CCC").define(Character.valueOf('C'), (ItemLike)Blocks.COBBLESTONE).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{this.not(this.modLoaded("cyclic")), QuarkRecipeProvider.zCond("sturdy_stone")})}), "quark:building/crafting/sturdy_stone");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)SturdyStoneModule.sturdy_stone).pattern("SCS").pattern("CCC").pattern("SCS").define(Character.valueOf('C'), (ItemLike)Blocks.COBBLESTONE).define(Character.valueOf('S'), (ItemLike)Blocks.STONE).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{this.modLoaded("cyclic"), QuarkRecipeProvider.zCond("sturdy_stone")})}), "quark:building/crafting/sturdy_stone_cyclic");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.COBBLESTONE, (int)9).requires((ItemLike)SturdyStoneModule.sturdy_stone).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{this.not(this.modLoaded("cyclic")), QuarkRecipeProvider.zCond("sturdy_stone")})}), "quark:building/crafting/sturdy_stone_uncompress");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RawMetalBricksModule.blocks.get(0)), (int)4).pattern("II").pattern("II").define(Character.valueOf('I'), (ItemLike)Blocks.RAW_IRON_BLOCK).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("raw_metal_bricks")}), "quark:building/crafting/raw_iron_bricks");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Items.RAW_IRON, (int)1).requires((ItemLike)RawMetalBricksModule.blocks.get(0)).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("raw_metal_bricks")}), "quark:building/crafting/raw_iron_bricks_revert");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RawMetalBricksModule.blocks.get(1)), (int)4).pattern("II").pattern("II").define(Character.valueOf('I'), (ItemLike)Blocks.RAW_GOLD_BLOCK).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("raw_metal_bricks")}), "quark:building/crafting/raw_gold_bricks");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Items.RAW_GOLD, (int)1).requires((ItemLike)RawMetalBricksModule.blocks.get(1)).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("raw_metal_bricks")}), "quark:building/crafting/raw_gold_bricks_revert");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RawMetalBricksModule.blocks.get(2)), (int)4).pattern("II").pattern("II").define(Character.valueOf('I'), (ItemLike)Blocks.RAW_COPPER_BLOCK).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("raw_metal_bricks")}), "quark:building/crafting/raw_copper_bricks");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Items.RAW_GOLD, (int)1).requires((ItemLike)RawMetalBricksModule.blocks.get(2)).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("raw_metal_bricks")}), "quark:building/crafting/raw_copper_bricks_revert");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MidoriModule.blocks.get(0))).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)MidoriModule.moss_paste).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("midori")}), "quark:building/crafting/midori_block");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MidoriModule.blocks.get(1))).pattern("#").pattern("#").define(Character.valueOf('#'), (ItemLike)Quark.ZETA.variantRegistry.slabs.get(MidoriModule.blocks.get(0))).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("midori")}), "quark:building/crafting/midori_pillar");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)CelebratoryLampsModule.stone_lamp, (int)3).pattern("SSS").pattern("GTG").pattern("SSS").define(Character.valueOf('S'), (ItemLike)Blocks.STONE).define(Character.valueOf('G'), (ItemLike)Blocks.GLASS).define(Character.valueOf('T'), (ItemLike)Items.TORCH).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("celebratory_lamps")}), "quark:building/crafting/stone_lamp");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)CelebratoryLampsModule.stone_brick_lamp, (int)3).pattern("SSS").pattern("GTG").pattern("SSS").define(Character.valueOf('S'), (ItemLike)Blocks.STONE_BRICKS).define(Character.valueOf('G'), (ItemLike)Blocks.GLASS).define(Character.valueOf('T'), (ItemLike)Items.TORCH).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("celebratory_lamps")}), "quark:building/crafting/stone_brick_lamp");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)VariantSelectorModule.hammer).pattern("III").pattern("ISI").pattern(" S ").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("hammer")}), "quark:experimental/crafting/hammer");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BackpackModule.backpack).pattern("LRL").pattern("LCL").pattern("LIL").define(Character.valueOf('L'), Tags.Items.LEATHERS).define(Character.valueOf('R'), (ItemLike)BackpackModule.ravager_hide).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("backpack"), QuarkRecipeProvider.zCond("ravager_hide")})}), "quark:oddities/crafting/backpack");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BackpackModule.backpack).pattern("LIL").pattern("LCL").pattern("LIL").define(Character.valueOf('L'), Tags.Items.LEATHERS).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("backpack"), this.not((ICondition)QuarkRecipeProvider.zCond("ravager_hide"))})}), "quark:oddities/crafting/backpack_no_hide");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BackpackModule.ravager_hide, (int)9).requires((ItemLike)BackpackModule.bonded_ravager_hide).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("ravager_hide")}), "quark:oddities/crafting/bonded_ravager_hide_uncompress");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BackpackModule.bonded_ravager_hide).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)BackpackModule.ravager_hide).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("ravager_hide")}), "quark:oddities/crafting/bonded_ravager_hide");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)CrateModule.crate).pattern("IWI").pattern("WCW").pattern("IWI").define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("crate")}), "quark:oddities/crafting/crate");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)PipesModule.encasedPipe).requires((ItemLike)PipesModule.pipe).requires(Tags.Items.GLASS_BLOCKS_COLORLESS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("encased_pipes")}), "quark:oddities/crafting/encased_pipe");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)PipesModule.pipe).requires((ItemLike)PipesModule.encasedPipe).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("encased_pipes")}), "quark:oddities/crafting/encased_pipe_revert");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)MagnetsModule.magnet).pattern("CIC").pattern("BFR").pattern("CIC").define(Character.valueOf('C'), Tags.Items.COBBLESTONES).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('B'), Tags.Items.DYES_BLUE).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('F'), (ItemLike)Items.CHORUS_FRUIT).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("magnet"), this.not((ICondition)QuarkRecipeProvider.zCond("magnet_pre_end"))})}), "quark:oddities/crafting/magnet");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)MagnetsModule.magnet).pattern("CIC").pattern("BPR").pattern("CIC").define(Character.valueOf('C'), Tags.Items.COBBLESTONES).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('B'), Tags.Items.DYES_BLUE).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('P'), Tags.Items.INGOTS_COPPER).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("magnet"), QuarkRecipeProvider.zCond("magnet_pre_end")})}), "quark:oddities/crafting/magnet_pre_end");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)PipesModule.pipe).pattern("I").pattern("G").pattern("I").define(Character.valueOf('I'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("pipes")}), "quark:oddities/crafting/pipe");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)TinyPotatoModule.tiny_potato).pattern("H").pattern("P").define(Character.valueOf('H'), (ItemLike)StonelingsModule.diamondHeart).define(Character.valueOf('P'), (ItemLike)Items.POTATO).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("tiny_potato"), QuarkRecipeProvider.zCond("stonelings"), this.not((ICondition)QuarkRecipeProvider.zCond("tiny_potato_never_uses_heart"))})}), "quark:oddities/crafting/tiny_potato_heart");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)TinyPotatoModule.tiny_potato).pattern("D").pattern("P").define(Character.valueOf('D'), Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND, Items.EMERALD})).define(Character.valueOf('P'), (ItemLike)Items.POTATO).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("tiny_potato"), this.or(new ICondition[]{QuarkRecipeProvider.zCond("tiny_potato_never_uses_heart"), this.not((ICondition)QuarkRecipeProvider.zCond("stonelings"))})})}), "quark:oddities/crafting/tiny_potato_no_heart");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)AbacusModule.abacus).pattern("WSW").pattern("WIW").pattern("WSW").define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("abacus")}), "quark:tools/crafting/abacus");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)PickarangModule.pickarang).pattern("DWH").pattern("  W").pattern("  D").define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('H'), (ItemLike)StonelingsModule.diamondHeart).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("pickarang"), QuarkRecipeProvider.zCond("stonelings")})}), "quark:tools/crafting/pickarang_heart");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)PickarangModule.pickarang).pattern("DWD").pattern("  W").pattern("  D").define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{this.and(new ICondition[]{QuarkRecipeProvider.zCond("pickarang"), this.or(new ICondition[]{QuarkRecipeProvider.zCond("pickarang_never_uses_heart"), this.not((ICondition)QuarkRecipeProvider.zCond("stonelings"))})})}), "quark:tools/crafting/pickarang_no_heart");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)ColorRunesModule.rune).pattern("#S#").pattern("#C#").pattern("###").define(Character.valueOf('#'), TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"quark", (String)"corundum"))).define(Character.valueOf('S'), Tags.Items.COBBLESTONES).define(Character.valueOf('C'), (ItemLike)ColorRunesModule.rune).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("color_runes")}), "quark:tools/crafting/rune_duplication");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)SeedPouchModule.seed_pouch, (int)1).pattern(" S ").pattern("HXH").pattern(" H ").define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('H'), TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"quark", (String)"seed_pouch_holdable"))).define(Character.valueOf('X'), (ItemLike)ColorRunesModule.rune).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("seed_pouch")}), "quark:tools/crafting/seed_pouch");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)TorchArrowModule.torch_arrow).requires((ItemLike)Items.TORCH).requires((ItemLike)Items.ARROW).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("torch_arrow")}), "quark:tools/crafting/torch_arrow");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)TrowelModule.trowel).pattern("S  ").pattern(" II").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("trowel")}), "quark:tools/crafting/trowel");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)GlassShardModule.dirtyGlassPane, (int)16).pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)GlassShardModule.dirtyGlass).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/panes/dirty_glass_pane");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.BREAD).pattern("##").pattern("# ").define(Character.valueOf('#'), (ItemLike)Items.WHEAT).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("bent_recipes")}), "quark:tweaks/crafting/utility/bent/bread");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.COOKIE).pattern("X#").pattern("# ").define(Character.valueOf('#'), (ItemLike)Items.WHEAT).define(Character.valueOf('X'), (ItemLike)Items.COCOA_BEANS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("bent_recipes")}), "quark:tweaks/crafting/utility/bent/cookie");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.PAPER, (int)3).pattern("##").pattern("# ").define(Character.valueOf('#'), (ItemLike)Items.SUGAR_CANE).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("bent_recipes")}), "quark:tweaks/crafting/utility/bent/paper");
        for (VanillaWoods.Wood wood : VanillaWoods.OVERWORLD) {
            String boatName = "_chest_boat";
            if (wood == VanillaWoods.BAMBOO) {
                boatName = "_chest_raft";
            }
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)DataUtil.getChestBoatFromPlank(wood.planks())).pattern("#X#").pattern("###").define(Character.valueOf('#'), (ItemLike)wood.planks()).define(Character.valueOf('X'), Tags.Items.CHESTS_WOODEN).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).group("direct_chest_boat").save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("direct_chest_boat")}), "quark:tweaks/crafting/utility/chest_boat/direct_" + wood.name() + boatName);
        }
        for (WoodSetHandler.WoodSet set : DataUtil.QuarkWorldWoodSets) {
            ICondition cond5 = this.and(new ICondition[]{QuarkRecipeProvider.zCond("direct_chest_boat"), QuarkRecipeProvider.zCond(set.name + "_wood")});
            if (set == BlossomTreesModule.woodSet) {
                cond5 = this.and(new ICondition[]{QuarkRecipeProvider.zCond("direct_chest_boat"), QuarkRecipeProvider.zCond("blossom_trees")});
            }
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)set.chestBoatItem).pattern("#X#").pattern("###").define(Character.valueOf('#'), (ItemLike)set.planks).define(Character.valueOf('X'), Tags.Items.CHESTS_WOODEN).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).group("direct_chest_boat").save(recipeOutput.withConditions(new ICondition[]{cond5}), "quark:tweaks/crafting/utility/chest_boat/direct_" + set.name + "_chest_boat");
        }
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.PINK_DYE).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.BRAIN_CORAL, Items.BRAIN_CORAL_FAN})).group("pink_dye").unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("coral_to_dye")}), "quark:tweaks/crafting/utility/coral/brain_to_pink");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.MAGENTA_DYE).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.BUBBLE_CORAL, Items.BUBBLE_CORAL_FAN})).group("magenta_dye").unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("coral_to_dye")}), "quark:tweaks/crafting/utility/coral/bubble_to_magenta");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.RED_DYE).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.FIRE_CORAL, Items.FIRE_CORAL_FAN})).group("red_dye").unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("coral_to_dye")}), "quark:tweaks/crafting/utility/coral/fire_to_red");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.YELLOW_DYE).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.HORN_CORAL, Items.HORN_CORAL_FAN})).group("yellow_dye").unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("coral_to_dye")}), "quark:tweaks/crafting/utility/coral/horn_to_yellow");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BLUE_DYE).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.TUBE_CORAL, Items.TUBE_CORAL_FAN})).group("blue_dye").unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("coral_to_dye")}), "quark:tweaks/crafting/utility/coral/tube_to_blue");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STONE_SWORD).pattern("#").pattern("#").pattern("S").define(Character.valueOf('#'), QuarkTags.Items.STONE_TOOL_MATERIALS).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("better_stone_tools")}), "quark:tweaks/crafting/utility/better_stone_tools/sword");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STONE_SHOVEL).pattern("#").pattern("S").pattern("S").define(Character.valueOf('#'), QuarkTags.Items.STONE_TOOL_MATERIALS).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("better_stone_tools")}), "quark:tweaks/crafting/utility/better_stone_tools/shovel");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STONE_PICKAXE).pattern("###").pattern(" S ").pattern(" S ").define(Character.valueOf('#'), QuarkTags.Items.STONE_TOOL_MATERIALS).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("better_stone_tools")}), "quark:tweaks/crafting/utility/better_stone_tools/pickaxe");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STONE_AXE).pattern("##").pattern("#S").pattern(" S").define(Character.valueOf('#'), QuarkTags.Items.STONE_TOOL_MATERIALS).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("better_stone_tools")}), "quark:tweaks/crafting/utility/better_stone_tools/axe");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STONE_AXE).pattern("##").pattern(" S").pattern(" S").define(Character.valueOf('#'), QuarkTags.Items.STONE_TOOL_MATERIALS).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("better_stone_tools")}), "quark:tweaks/crafting/utility/better_stone_tools/hoe");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BLACK_DYE).requires((ItemLike)Items.CHARCOAL).group("black_dye").unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("charcoal_to_dye")}), "quark:tweaks/crafting/utility/misc/charcoal_to_black_dye");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.CHEST_MINECART).pattern("#C#").pattern("###").define(Character.valueOf('#'), Tags.Items.INGOTS_IRON).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("minecart_upgrade")}), "quark:tweaks/crafting/utility/misc/chest_minecart");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.DISPENSER).requires((ItemLike)Items.BOW).requires((ItemLike)Items.DROPPER).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("dropper_upgrade")}), "quark:tweaks/crafting/utility/misc/dispenser_bow");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.DISPENSER).pattern(" #X").pattern("#DX").pattern(" #X").define(Character.valueOf('#'), Tags.Items.RODS_WOODEN).define(Character.valueOf('X'), (ItemLike)Items.STRING).define(Character.valueOf('D'), (ItemLike)Items.DROPPER).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("dropper_upgrade")}), "quark:tweaks/crafting/utility/misc/dispenser_no_bow");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.HOPPER).pattern("IWI").pattern("IWI").pattern(" I ").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('W'), ItemTags.LOGS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("easy_hopper")}), "quark:tweaks/crafting/utility/misc/easy_hopper");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STICK, (int)16).pattern("#").pattern("#").define(Character.valueOf('#'), ItemTags.LOGS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("easy_sticks")}), "quark:tweaks/crafting/utility/misc/easy_sticks");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STICK, (int)8).pattern("#").pattern("#").define(Character.valueOf('#'), ItemTags.BAMBOO_BLOCKS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("easy_sticks")}), "quark:tweaks/crafting/utility/misc/easy_sticks_bamboo");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.FURNACE_MINECART).pattern("#X#").pattern("###").define(Character.valueOf('#'), Tags.Items.INGOTS_IRON).define(Character.valueOf('X'), (ItemLike)Items.FURNACE).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("minecart_upgrade")}), "quark:tweaks/crafting/utility/misc/furnace_minecart");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.HOPPER_MINECART).pattern("#X#").pattern("###").define(Character.valueOf('#'), Tags.Items.INGOTS_IRON).define(Character.valueOf('X'), (ItemLike)Items.HOPPER).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("minecart_upgrade")}), "quark:tweaks/crafting/utility/misc/hopper_minecart");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.HOPPER_MINECART).pattern("X X").pattern("#X#").pattern("III").define(Character.valueOf('#'), Tags.Items.RODS_WOODEN).define(Character.valueOf('X'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('I'), (ItemLike)Items.STONE).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("repeater_and_torches")}), "quark:tweaks/crafting/utility/misc/repeater");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.TNT_MINECART).pattern("#X#").pattern("###").define(Character.valueOf('#'), Tags.Items.INGOTS_IRON).define(Character.valueOf('X'), (ItemLike)Items.TNT).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("minecart_upgrade")}), "quark:tweaks/crafting/utility/misc/tnt_minecart");
        QuarkRecipeProvider.shardGlassRecipe(Items.BLACK_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/black_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.BLUE_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/blue_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.BROWN_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/brown_glass");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GLASS).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)GlassShardModule.clearShard).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/clear_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.CYAN_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/cyan_glass");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)GlassShardModule.dirtyGlass).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)GlassShardModule.dirtyShard).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/dirty_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.GRAY_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/gray_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.GREEN_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/green_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.LIGHT_BLUE_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/light_blue_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.LIGHT_GRAY_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/light_gray_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.LIME_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/lime_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.MAGENTA_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/magenta_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.ORANGE_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/orange_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.PINK_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/pink_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.PURPLE_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/purple_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.RED_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/red_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.WHITE_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/white_glass");
        QuarkRecipeProvider.shardGlassRecipe(Items.YELLOW_STAINED_GLASS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("glass_shard")}), "quark:tweaks/crafting/utility/glass/yellow_glass");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(NewStoneTypesModule.limestoneBlock)), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{NewStoneTypesModule.limestoneBlock})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)NewStoneTypesModule.limestoneBlock), QuarkRecipeProvider.has((ItemLike)NewStoneTypesModule.limestoneBlock)).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("limestone")}), "quark:world/crafting/slabs/limestone_slab");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(NewStoneTypesModule.limestoneBlock)), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{NewStoneTypesModule.limestoneBlock})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)NewStoneTypesModule.limestoneBlock), QuarkRecipeProvider.has((ItemLike)NewStoneTypesModule.limestoneBlock)).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("limestone")}), "quark:world/crafting/stairs/limestone_stairs");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.limestoneBlock)), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)NewStoneTypesModule.limestoneBlock).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("limestone")}), "quark:world/crafting/polished_limestone");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.limestoneBlock))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.limestoneBlock)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.limestoneBlock))), QuarkRecipeProvider.has((ItemLike)((ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.limestoneBlock)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("limestone")}), "quark:world/crafting/slabs/polished_limestone_slab");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.limestoneBlock))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.limestoneBlock)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.limestoneBlock))), QuarkRecipeProvider.has((ItemLike)((ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.limestoneBlock)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("limestone")}), "quark:world/crafting/stairs/polished_limestone_stairs");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(NewStoneTypesModule.jasperBlock)), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{NewStoneTypesModule.jasperBlock})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)NewStoneTypesModule.jasperBlock), QuarkRecipeProvider.has((ItemLike)NewStoneTypesModule.jasperBlock)).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("jasper")}), "quark:world/crafting/slabs/jasper_slab");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(NewStoneTypesModule.jasperBlock)), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{NewStoneTypesModule.jasperBlock})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)NewStoneTypesModule.jasperBlock), QuarkRecipeProvider.has((ItemLike)NewStoneTypesModule.jasperBlock)).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("jasper")}), "quark:world/crafting/stairs/jasper_stairs");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.jasperBlock)), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)NewStoneTypesModule.jasperBlock).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("jasper")}), "quark:world/crafting/polished_jasper");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.jasperBlock))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.jasperBlock)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.jasperBlock))), QuarkRecipeProvider.has((ItemLike)((ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.jasperBlock)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("jasper")}), "quark:world/crafting/slabs/polished_jasper_slab");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.jasperBlock))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.jasperBlock)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.jasperBlock))), QuarkRecipeProvider.has((ItemLike)((ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.jasperBlock)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("jasper")}), "quark:world/crafting/stairs/polished_jasper_stairs");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(NewStoneTypesModule.shaleBlock)), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{NewStoneTypesModule.shaleBlock})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)NewStoneTypesModule.shaleBlock), QuarkRecipeProvider.has((ItemLike)NewStoneTypesModule.shaleBlock)).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("shale")}), "quark:world/crafting/slabs/shale_slab");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(NewStoneTypesModule.shaleBlock)), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{NewStoneTypesModule.shaleBlock})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)NewStoneTypesModule.shaleBlock), QuarkRecipeProvider.has((ItemLike)NewStoneTypesModule.shaleBlock)).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("shale")}), "quark:world/crafting/stairs/shale_stairs");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.shaleBlock)), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)NewStoneTypesModule.shaleBlock).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("shale")}), "quark:world/crafting/polished_shale");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.shaleBlock))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.shaleBlock)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.shaleBlock))), QuarkRecipeProvider.has((ItemLike)((ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.shaleBlock)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("shale")}), "quark:world/crafting/slabs/polished_shale_slab");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.shaleBlock))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.shaleBlock)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.shaleBlock))), QuarkRecipeProvider.has((ItemLike)((ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.shaleBlock)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("shale")}), "quark:world/crafting/stairs/polished_shale_stairs");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(NewStoneTypesModule.myaliteBlock)), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{NewStoneTypesModule.myaliteBlock})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)NewStoneTypesModule.myaliteBlock), QuarkRecipeProvider.has((ItemLike)NewStoneTypesModule.myaliteBlock)).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("myalite")}), "quark:world/crafting/slabs/myalite_slab");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(NewStoneTypesModule.myaliteBlock)), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{NewStoneTypesModule.myaliteBlock})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)NewStoneTypesModule.myaliteBlock), QuarkRecipeProvider.has((ItemLike)NewStoneTypesModule.myaliteBlock)).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("myalite")}), "quark:world/crafting/stairs/myalite_stairs");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.myaliteBlock)), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)NewStoneTypesModule.myaliteBlock).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("myalite")}), "quark:world/crafting/polished_myalite");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.myaliteBlock))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.myaliteBlock)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.myaliteBlock))), QuarkRecipeProvider.has((ItemLike)((ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.myaliteBlock)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("myalite")}), "quark:world/crafting/slabs/polished_myalite_slab");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.myaliteBlock))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.myaliteBlock)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.myaliteBlock))), QuarkRecipeProvider.has((ItemLike)((ItemLike)NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.myaliteBlock)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("myalite")}), "quark:world/crafting/stairs/polished_myalite_stairs");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)PermafrostModule.blocks.get(1)), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)PermafrostModule.blocks.get(0)).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("permafrost")}), "quark:world/crafting/permafrost_bricks");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(PermafrostModule.blocks.get(0))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)PermafrostModule.blocks.get(0)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)PermafrostModule.blocks.get(0))), QuarkRecipeProvider.has((ItemLike)((ItemLike)PermafrostModule.blocks.get(0)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("permafrost")}), "quark:world/crafting/slabs/permafrost_slab");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(PermafrostModule.blocks.get(0))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)PermafrostModule.blocks.get(0)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)PermafrostModule.blocks.get(0))), QuarkRecipeProvider.has((ItemLike)((ItemLike)PermafrostModule.blocks.get(0)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("permafrost")}), "quark:world/crafting/stairs/permafrost_stairs");
        QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Quark.ZETA.variantRegistry.slabs.get(PermafrostModule.blocks.get(1))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)PermafrostModule.blocks.get(1)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)PermafrostModule.blocks.get(1))), QuarkRecipeProvider.has((ItemLike)((ItemLike)PermafrostModule.blocks.get(1)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("permafrost")}), "quark:world/crafting/slabs/permafrost_bricks_slab");
        QuarkRecipeProvider.stairBuilder((ItemLike)((ItemLike)Quark.ZETA.variantRegistry.stairs.get(PermafrostModule.blocks.get(1))), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)PermafrostModule.blocks.get(1)})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)((ItemLike)PermafrostModule.blocks.get(1))), QuarkRecipeProvider.has((ItemLike)((ItemLike)PermafrostModule.blocks.get(1)))).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("permafrost")}), "quark:world/crafting/stairs/permafrost_bricks_stairs");
        for (WoodSetHandler.WoodSet set : DataUtil.QuarkWorldWoodSets) {
            FlagCondition cond6 = QuarkRecipeProvider.zCond(set.name + "_wood");
            if (set == BlossomTreesModule.woodSet) {
                cond6 = QuarkRecipeProvider.zCond("blossom_trees");
            }
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)set.planks, (int)4).requires((ItemLike)set.planks).group("planks").unlockedBy("has_log", QuarkRecipeProvider.has((ItemLike)set.planks)).save(recipeOutput.withConditions(new ICondition[]{cond6}), "quark:world/crafting/woodsets/" + set.name + "/" + set.name + "_planks");
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)set.wood, (int)3).define(Character.valueOf('#'), (ItemLike)set.log).pattern("##").pattern("##").group("bark").unlockedBy("has_log", QuarkRecipeProvider.has((ItemLike)set.log)).save(recipeOutput.withConditions(new ICondition[]{cond6}), "quark:world/crafting/woodsets/" + set.name + "/" + set.name + "_wood");
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)set.strippedWood, (int)3).define(Character.valueOf('#'), (ItemLike)set.strippedLog).pattern("##").pattern("##").group("bark").unlockedBy("has_log", QuarkRecipeProvider.has((ItemLike)set.strippedLog)).save(recipeOutput.withConditions(new ICondition[]{cond6}), "quark:world/crafting/woodsets/" + set.name + "/stripped_" + set.name + "_wood");
            QuarkRecipeProvider.stairBuilder((ItemLike)DataUtil.regSearch(Quark.asResource(set.name + "_planks_stairs")), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{set.planks})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)set.planks), QuarkRecipeProvider.has((ItemLike)set.planks)).save(recipeOutput.withConditions(new ICondition[]{cond6}), "quark:world/crafting/woodsets/" + set.name + "/" + set.name + "_stairs");
            QuarkRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)DataUtil.regSearch(Quark.asResource(set.name + "_planks_slab")), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{set.planks})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)set.planks), QuarkRecipeProvider.has((ItemLike)set.planks)).save(recipeOutput.withConditions(new ICondition[]{cond6}), "quark:world/crafting/woodsets/" + set.name + "/" + set.name + "_slab");
            QuarkRecipeProvider.doorBuilder((ItemLike)set.door, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{set.planks.asItem()})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)set.planks), QuarkRecipeProvider.has((ItemLike)set.planks)).save(recipeOutput.withConditions(new ICondition[]{cond6}), "quark:world/crafting/woodsets/" + set.name + "/" + set.name + "_door");
            QuarkRecipeProvider.trapdoorBuilder((ItemLike)set.trapdoor, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{set.planks.asItem()})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)set.planks), QuarkRecipeProvider.has((ItemLike)set.planks)).save(recipeOutput.withConditions(new ICondition[]{cond6}), "quark:world/crafting/woodsets/" + set.name + "/" + set.name + "_trapdoor");
            QuarkRecipeProvider.fenceBuilder((ItemLike)set.fence, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{set.planks.asItem()})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)set.planks), QuarkRecipeProvider.has((ItemLike)set.planks)).save(recipeOutput.withConditions(new ICondition[]{cond6}), "quark:world/crafting/woodsets/" + set.name + "/" + set.name + "_fence");
            QuarkRecipeProvider.fenceGateBuilder((ItemLike)set.fenceGate, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{set.planks.asItem()})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)set.planks), QuarkRecipeProvider.has((ItemLike)set.planks)).save(recipeOutput.withConditions(new ICondition[]{cond6}), "quark:world/crafting/woodsets/" + set.name + "/" + set.name + "_fence_gate");
            QuarkRecipeProvider.signBuilder((ItemLike)set.sign, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{set.planks.asItem()})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)set.planks), QuarkRecipeProvider.has((ItemLike)set.planks)).save(recipeOutput.withConditions(new ICondition[]{cond6}), "quark:world/crafting/woodsets/" + set.name + "/" + set.name + "_sign");
            QuarkRecipeProvider.pressurePlateBuilder((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)set.pressurePlate, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{set.planks})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)set.planks), QuarkRecipeProvider.has((ItemLike)set.planks)).save(recipeOutput.withConditions(new ICondition[]{cond6}), "quark:world/crafting/woodsets/" + set.name + "/" + set.name + "_pressure_plate");
            QuarkRecipeProvider.buttonBuilder((ItemLike)set.button, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{set.planks})).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)set.planks), QuarkRecipeProvider.has((ItemLike)set.planks)).save(recipeOutput.withConditions(new ICondition[]{cond6}), "quark:world/crafting/woodsets/" + set.name + "/" + set.name + "_button");
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)set.hangingSignItem, (int)6).pattern("C C").pattern("###").pattern("###").define(Character.valueOf('C'), (ItemLike)Items.CHAIN).define(Character.valueOf('#'), (ItemLike)set.strippedLog).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)set.strippedLog), QuarkRecipeProvider.has((ItemLike)set.strippedLog)).group("hanging_sign").save(recipeOutput.withConditions(new ICondition[]{cond6}), "quark:world/crafting/woodsets/" + set.name + "/" + set.name + "_hanging_sign");
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)set.boatItem).pattern("# #").pattern("###").define(Character.valueOf('#'), (ItemLike)set.planks).unlockedBy("in_water", QuarkRecipeProvider.insideOf((Block)Blocks.WATER)).group("boat").save(recipeOutput.withConditions(new ICondition[]{cond6}), "quark:world/crafting/woodsets/" + set.name + "/" + set.name + "_boat");
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)set.chestBoatItem).requires(Tags.Items.CHESTS_WOODEN).requires((ItemLike)set.boatItem).unlockedBy("has_boat", QuarkRecipeProvider.has((TagKey)ItemTags.BOATS)).group("chest_boat").save(recipeOutput.withConditions(new ICondition[]{cond6}), "quark:world/crafting/woodsets/" + set.name + "/" + set.name + "_chest_boat");
        }
        for (CorundumColor corundumColor : CorundumColor.values()) {
            FlagCondition cond7 = QuarkRecipeProvider.zCond("corundum");
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)CorundumModule.getWaxedCrystal(corundumColor)).requires((ItemLike)CorundumModule.getCrystal(corundumColor)).requires((ItemLike)Items.HONEYCOMB).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)CorundumModule.getCrystal(corundumColor)), QuarkRecipeProvider.has((ItemLike)CorundumModule.getCrystal(corundumColor))).save(recipeOutput.withConditions(new ICondition[]{cond7}), "quark:world/crafting/" + corundumColor.name().toLowerCase() + "_waxed_corundum");
            QuarkRecipeProvider.paneRecipe((ItemLike)CorundumModule.getPane(corundumColor), (ItemLike)CorundumModule.getCrystal(corundumColor)).unlockedBy(QuarkRecipeProvider.getHasName((ItemLike)CorundumModule.getCrystal(corundumColor)), QuarkRecipeProvider.has((ItemLike)CorundumModule.getCrystal(corundumColor))).save(recipeOutput.withConditions(new ICondition[0]), "quark:world/crafting/" + corundumColor.name().toLowerCase() + "_corundum_pane");
        }
    }

    public static ShapedRecipeBuilder chestRecipe(ItemLike output, ItemLike plank) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output).pattern("###").pattern("# #").pattern("###").define(Character.valueOf('#'), plank);
    }

    public static ShapelessRecipeBuilder trappedChestRecipe(ItemLike output, ItemLike originalChest) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)output).requires(originalChest).requires((ItemLike)Items.TRIPWIRE_HOOK);
    }

    public static ShapedRecipeBuilder fourChestRecipe(ItemLike output, TagKey<Item> log) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)4).pattern("###").pattern("# #").pattern("###").define(Character.valueOf('#'), log);
    }

    public static ShapedRecipeBuilder shardGlassRecipe(Item output) {
        StainedGlassBlock glass = (StainedGlassBlock)Block.byItem((Item)output);
        DyeColor shardColor = glass.getColor();
        Item shard = GlassShardModule.shardColors.get(shardColor);
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)shard);
    }

    public static ShapelessRecipeBuilder dyedFramedGlassRecipe(ItemLike output, DyeColor dye) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)8).requires((ItemLike)FramedGlassModule.framed_glass).requires((ItemLike)FramedGlassModule.framed_glass).requires((ItemLike)FramedGlassModule.framed_glass).requires((ItemLike)FramedGlassModule.framed_glass).requires((ItemLike)FramedGlassModule.framed_glass).requires((ItemLike)FramedGlassModule.framed_glass).requires((ItemLike)FramedGlassModule.framed_glass).requires((ItemLike)FramedGlassModule.framed_glass).requires((ItemLike)DyeItem.byColor((DyeColor)dye));
    }

    public static ShapedRecipeBuilder paneRecipe(ItemLike output, ItemLike glass) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)16).pattern("###").pattern("###").define(Character.valueOf('#'), glass);
    }

    public static ShapedRecipeBuilder corundomLampRecipe(ItemLike output, CorundumColor corundumColor) {
        Block corundum = CorundumModule.getCrystal(corundumColor);
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)output).pattern(" R ").pattern("RCR").pattern(" R ").define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('C'), (ItemLike)corundum);
    }

    public static ShapedRecipeBuilder crystalLampRecipe(ItemLike output, CorundumColor corundumColor) {
        Item dye = DataUtil.getDyeItemFromCorondumColor(corundumColor);
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)output).pattern(" D ").pattern("RAR").pattern(" G ").define(Character.valueOf('D'), (ItemLike)dye).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('A'), (ItemLike)Blocks.AMETHYST_BLOCK).define(Character.valueOf('G'), Tags.Items.DUSTS_GLOWSTONE);
    }

    public static ShapedRecipeBuilder hollowLogRecipe(ItemLike output, ItemLike solidLog) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)4).pattern(" L ").pattern("L L").pattern(" L ").define(Character.valueOf('L'), solidLog).unlockedBy("test", PlayerTrigger.TriggerInstance.tick());
    }

    public static RecipeBuilder vertslabRecipe(RecipeCategory category, ItemLike output, Ingredient input) {
        if (output == null || input == null) {
            System.out.println("Missing vertical/horizontal slab pair!!!");
        }
        return ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)output, (int)3).define(Character.valueOf('#'), input).pattern("#").pattern("#").pattern("#");
    }

    public static void compressUncompress(ItemLike item, ItemLike block, RecipeOutput recipeOutput, String configFlag, String blockName) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)block).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), item).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond(blockName)}), "quark:building/crafting/compressed/" + blockName);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)item, (int)9).requires(block).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput, "quark:building/crafting/compressed/" + blockName + "uncompress");
    }

    public static void variantFurnace(ItemLike baseBlock, Block furnaceBlock, RecipeOutput recipeOutput, String blockName) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)furnaceBlock).pattern("###").pattern("# #").pattern("###").define(Character.valueOf('#'), baseBlock).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("variant_furnaces")}), "quark:building/crafting/furnaces/" + blockName + "_furnace");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.SMOKER).pattern(" # ").pattern("#X#").pattern(" # ").define(Character.valueOf('#'), ItemTags.LOGS).define(Character.valueOf('X'), (ItemLike)furnaceBlock).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("variant_furnaces")}), "quark:building/crafting/furnaces/" + blockName + "_smoker");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.BLAST_FURNACE).pattern("III").pattern("IXI").pattern("###").define(Character.valueOf('#'), (ItemLike)Blocks.SMOOTH_STONE).define(Character.valueOf('X'), (ItemLike)furnaceBlock).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("variant_furnaces")}), "quark:building/crafting/furnaces/" + blockName + "_blast_furnace");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.FURNACE_MINECART).requires((ItemLike)furnaceBlock).requires((ItemLike)Items.MINECART).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("variant_furnaces")}), "quark:building/crafting/furnaces/" + blockName + "_minecart");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.FURNACE_MINECART).pattern("#X#").pattern("###").define(Character.valueOf('#'), Tags.Items.INGOTS_IRON).define(Character.valueOf('X'), (ItemLike)furnaceBlock).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("variant_furnaces"), QuarkRecipeProvider.zCond("minecart_upgrade")}), "quark:building/crafting/furnaces/" + blockName + "_minecarft_tweaked");
    }

    public static void colorShingles(ItemLike output, DyeColor color, RecipeOutput recipeOutput) {
        Block terracotta = DataUtil.getTerrracottaFromDyeColor(color);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)2).pattern("##").define(Character.valueOf('#'), (ItemLike)terracotta).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput, "quark:building/crafting/shingles/" + color.getName() + "_shingles");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)8).pattern("SSS").pattern("SDS").pattern("SSS").define(Character.valueOf('S'), (ItemLike)ShinglesModule.blocks.getFirst()).define(Character.valueOf('D'), (ItemLike)DyeItem.byColor((DyeColor)color)).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput, "quark:building/crafting/shingles/" + color.getName() + "_shingles_dye");
    }

    public static void colorStools(ItemLike output, DyeColor color, RecipeOutput recipeOutput) {
        Block wool = DataUtil.getWoolFromDyeColor(color);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)4).pattern("###").pattern("WWW").define(Character.valueOf('#'), (ItemLike)wool).define(Character.valueOf('W'), ItemTags.WOODEN_SLABS).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{QuarkRecipeProvider.zCond("stools")}), "quark:building/crafting/stools/" + color.getName() + "_stool");
    }

    public void stoneVariantsChiseledAndPillar(String name, ICondition condition, ItemLike chiseled, ItemLike pillar, ItemLike brickSlab, ItemLike polishedSlab, RecipeOutput recipeOutput) {
        ICondition chiseledCond = this.and(new ICondition[]{condition, QuarkRecipeProvider.zCond("stone_chiseled"), QuarkRecipeProvider.zCond("stone_bricks")});
        ICondition pillarCond = this.and(new ICondition[]{condition, QuarkRecipeProvider.zCond("stone_pillar")});
        String worldDir = "";
        if (name.equals("limestone") || name.equals("jasper") || name.equals("shale") || name.equals("myalite")) {
            worldDir = "worldstones/";
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)chiseled).pattern("#").pattern("#").define(Character.valueOf('#'), brickSlab).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{chiseledCond}), "quark:building/crafting/stonevariants/" + worldDir + "chiseled_" + name + "_bricks");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)pillar).pattern("#").pattern("#").define(Character.valueOf('#'), polishedSlab).unlockedBy("test", PlayerTrigger.TriggerInstance.tick()).save(recipeOutput.withConditions(new ICondition[]{pillarCond}), "quark:building/crafting/stonevariants/" + worldDir + name + "_pillar");
    }
}

