/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.client.render.entity;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.client.handler.ModelHandler;
import org.violetmoon.quark.content.mobs.client.layer.shiba.ShibaCollarLayer;
import org.violetmoon.quark.content.mobs.client.layer.shiba.ShibaMouthItemLayer;
import org.violetmoon.quark.content.mobs.client.model.ShibaModel;
import org.violetmoon.quark.content.mobs.entity.Shiba;

public class ShibaRenderer
extends MobRenderer<Shiba, ShibaModel> {
    private static final ResourceLocation[] SHIBA_BASES = new ResourceLocation[]{Quark.asResource("textures/model/entity/shiba/shiba0.png"), Quark.asResource("textures/model/entity/shiba/shiba1.png"), Quark.asResource("textures/model/entity/shiba/shiba2.png")};
    private static final ResourceLocation SHIBA_RARE = Quark.asResource("textures/model/entity/shiba/shiba_rare.png");
    private static final ResourceLocation SHIBA_DOGE = Quark.asResource("textures/model/entity/shiba/shiba_doge.png");

    public ShibaRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)((ShibaModel)((Object)ModelHandler.model(ModelHandler.shiba))), 0.5f);
        this.addLayer(new ShibaCollarLayer((RenderLayerParent<Shiba, ShibaModel>)this));
        this.addLayer(new ShibaMouthItemLayer((RenderLayerParent<Shiba, ShibaModel>)this, context.getItemInHandRenderer()));
    }

    @NotNull
    public ResourceLocation getTextureLocation(Shiba entity) {
        if (entity.hasCustomName() && entity.getCustomName().getString().trim().equalsIgnoreCase("doge")) {
            return SHIBA_DOGE;
        }
        long least = Math.abs(entity.getUUID().getLeastSignificantBits());
        if (least % 200L == 0L) {
            return SHIBA_RARE;
        }
        int type = (int)(least % (long)SHIBA_BASES.length);
        return SHIBA_BASES[type];
    }
}

