/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.entity;

import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.mobs.module.ForgottenModule;
import org.violetmoon.quark.content.tools.base.RuneColor;
import org.violetmoon.quark.content.tools.module.ColorRunesModule;

public class Forgotten
extends Skeleton {
    public static final EntityDataAccessor<ItemStack> SHEATHED_ITEM = SynchedEntityData.defineId(Forgotten.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    public static final ResourceKey<LootTable> FORGOTTEN_LOOT_TABLE = Quark.asResourceKey(Registries.LOOT_TABLE, "entities/forgotten");

    public Forgotten(EntityType<? extends Forgotten> type, Level world) {
        super(type, world);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHEATHED_ITEM, (Object)ItemStack.EMPTY);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.MAX_HEALTH, 60.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        SpawnGroupData ilivingentitydata = super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
        this.reassessWeaponGoal();
        return ilivingentitydata;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            boolean isUsingBow;
            boolean shouldUseBow;
            LivingEntity target = this.getTarget();
            boolean bl = shouldUseBow = target == null;
            if (!shouldUseBow) {
                MobEffectInstance eff = target.getEffect(MobEffects.BLINDNESS);
                boolean bl2 = shouldUseBow = eff == null || eff.getDuration() < 20;
            }
            if (shouldUseBow != (isUsingBow = this.getMainHandItem().getItem() instanceof BowItem)) {
                this.swap();
            }
        }
        double w = this.getBbWidth() * 2.0f;
        double h = this.getBbHeight();
        this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)0xFFFFFF), this.getX() + Math.random() * w - w / 2.0, this.getY() + Math.random() * h, this.getZ() + Math.random() * w - w / 2.0, 0.0, 0.0, 0.0);
    }

    private void swap() {
        ItemStack curr = this.getMainHandItem();
        ItemStack off = (ItemStack)this.entityData.get(SHEATHED_ITEM);
        this.setItemInHand(InteractionHand.MAIN_HAND, off);
        this.entityData.set(SHEATHED_ITEM, (Object)curr);
        Stream<WrappedGoal> stream = this.goalSelector.getAvailableGoals().stream().filter(WrappedGoal::isRunning);
        stream.map(WrappedGoal::getGoal).filter(g -> g instanceof MeleeAttackGoal || g instanceof RangedBowAttackGoal).forEach(Goal::stop);
        this.reassessWeaponGoal();
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return FORGOTTEN_LOOT_TABLE;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        CompoundTag sheathed = new CompoundTag();
        if (this.entityData.get(SHEATHED_ITEM) != ItemStack.EMPTY) {
            ((ItemStack)this.entityData.get(SHEATHED_ITEM)).save((HolderLookup.Provider)this.level().registryAccess(), (Tag)sheathed);
        }
        compound.put("sheathed", (Tag)sheathed);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        CompoundTag sheathed = compound.getCompound("sheathed");
        this.entityData.set(SHEATHED_ITEM, (Object)ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)sheathed));
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource source, boolean recentlyHitIn) {
    }

    public boolean canPickUpLoot() {
        return false;
    }

    protected void populateDefaultEquipmentSlots(@NotNull RandomSource rand, @NotNull DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(rand, difficulty);
        this.prepareEquipment(this.level().registryAccess(), difficulty);
    }

    public void prepareEquipment(RegistryAccess access, DifficultyInstance difficulty) {
        DyeColor color;
        RuneColor rune;
        ItemStack bow = new ItemStack((ItemLike)Items.BOW);
        ItemStack sheathed = new ItemStack((ItemLike)Items.IRON_SWORD);
        EnchantmentHelper.enchantItemFromProvider((ItemStack)bow, (RegistryAccess)access, (ResourceKey)VanillaEnchantmentProviders.MOB_SPAWN_EQUIPMENT, (DifficultyInstance)difficulty, (RandomSource)this.random);
        EnchantmentHelper.enchantItemFromProvider((ItemStack)sheathed, (RegistryAccess)access, (ResourceKey)VanillaEnchantmentProviders.MOB_SPAWN_EQUIPMENT, (DifficultyInstance)difficulty, (RandomSource)this.random);
        if (Quark.ZETA.modules.isEnabled(ColorRunesModule.class) && this.random.nextBoolean() && (rune = RuneColor.byDyeColor(color = DyeColor.values()[this.random.nextInt(DyeColor.values().length)])) != null) {
            ColorRunesModule.withRune(bow, rune);
            ColorRunesModule.withRune(sheathed, rune);
        }
        this.setItemSlot(EquipmentSlot.MAINHAND, bow);
        this.entityData.set(SHEATHED_ITEM, (Object)sheathed);
        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)ForgottenModule.forgotten_hat));
    }

    @NotNull
    protected AbstractArrow getArrow(@NotNull ItemStack arrowStack, float distanceFactor, @Nullable ItemStack itemStack) {
        AbstractArrow arrow = super.getArrow(arrowStack, distanceFactor, itemStack);
        if (arrow instanceof Arrow) {
            Arrow arrowInstance = (Arrow)arrow;
            arrowInstance.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 100, 0));
        }
        return arrow;
    }
}

