/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.datagen.groups;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.violetmoon.quark.base.handler.QuarkSounds;
import org.violetmoon.quark.content.mobs.module.StonelingsModule;
import org.violetmoon.quark.content.world.module.GlimmeringWealdModule;
import org.violetmoon.quark.mixin.mixins.accessor.AccessorOverworldBiomes;

public class QuarkBiomes {
    public static void bootstrap(BootstrapContext<Biome> ctx) {
        HolderGetter placedFeatureLookup = ctx.lookup(Registries.PLACED_FEATURE);
        HolderGetter configuredCarverLookup = ctx.lookup(Registries.CONFIGURED_CARVER);
        ctx.register(GlimmeringWealdModule.BIOME_KEY, (Object)QuarkBiomes.glimmeringWeald((HolderGetter<PlacedFeature>)placedFeatureLookup, configuredCarverLookup));
    }

    private static Biome glimmeringWeald(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        MobSpawnSettings.Builder mobSpawnSettingsBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)mobSpawnSettingsBuilder);
        mobSpawnSettingsBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(StonelingsModule.stonelingType, 200, 1, 4));
        BiomeGenerationSettings.Builder biomeGenerationSettingsBuilder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        AccessorOverworldBiomes.quark$globalOverworldGeneration(biomeGenerationSettingsBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeGenerationSettingsBuilder, (boolean)true);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomeGenerationSettingsBuilder);
        BiomeDefaultFeatures.addForestGrass((BiomeGenerationSettings.Builder)biomeGenerationSettingsBuilder);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)biomeGenerationSettingsBuilder);
        BiomeDefaultFeatures.addOtherBirchTrees((BiomeGenerationSettings.Builder)biomeGenerationSettingsBuilder);
        BiomeDefaultFeatures.addForestFlowers((BiomeGenerationSettings.Builder)biomeGenerationSettingsBuilder);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomeGenerationSettingsBuilder);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)biomeGenerationSettingsBuilder);
        biomeGenerationSettingsBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, GlimmeringWealdModule.GLOW_SHROOMS_FEATURE);
        biomeGenerationSettingsBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, GlimmeringWealdModule.GLOW_SHROOMS_EXTRAS_FEATURE);
        Music music = Musics.createGameMusic((Holder)Holder.direct((Object)QuarkSounds.MUSIC_GLIMMERING_WEALD));
        return AccessorOverworldBiomes.quark$biome(true, 0.8f, 0.4f, mobSpawnSettingsBuilder, biomeGenerationSettingsBuilder, music);
    }
}

