/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.util.TriFunction;
import org.violetmoon.zeta.item.ZetaItem;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;

public class QuarkItemFrameItem
extends ZetaItem {
    private final TriFunction<? extends HangingEntity, Level, BlockPos, Direction> entityProvider;

    public QuarkItemFrameItem(String name, ZetaModule module, TriFunction<? extends HangingEntity, Level, BlockPos, Direction> entityProvider) {
        super(name, module, new Item.Properties());
        this.entityProvider = entityProvider;
        CreativeTabManager.addNextToItem((ResourceKey)CreativeModeTabs.FUNCTIONAL_BLOCKS, (ItemLike)this, (ItemLike)Items.GLOW_ITEM_FRAME, (boolean)false);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        Direction facing = context.getClickedFace();
        BlockPos placeLocation = pos.relative(facing);
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        if (player != null && !this.canPlace(player, facing, stack, placeLocation)) {
            return InteractionResult.FAIL;
        }
        Level world = context.getLevel();
        HangingEntity frame = this.entityProvider.apply(world, placeLocation, facing);
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data != null) {
            EntityType.updateCustomEntityTag((Level)world, (Player)player, (Entity)frame, (CustomData)data);
        }
        if (frame.survives()) {
            if (!world.isClientSide) {
                world.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, frame.position());
                frame.playPlacementSound();
                world.addFreshEntity((Entity)frame);
            }
            stack.shrink(1);
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    protected boolean canPlace(Player player, Direction facing, ItemStack stack, BlockPos pos) {
        return !player.level().isOutsideBuildHeight(pos) && player.mayUseItemAt(pos, facing, stack);
    }
}

