/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.block.ZetaBushBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.MiscUtil;

public class GlowLichenGrowthBlock
extends ZetaBushBlock
implements BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);

    public GlowLichenGrowthBlock(@Nullable ZetaModule module) {
        super("glow_lichen_growth", module, CreativeModeTabs.NATURAL_BLOCKS, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLOW_LICHEN).randomTicks().lightLevel(s -> 8));
    }

    public void animateTick(@NotNull BlockState stateIn, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        super.animateTick(stateIn, worldIn, pos, rand);
        for (int i = 0; i < 10; ++i) {
            worldIn.addParticle((ParticleOptions)ParticleTypes.MYCELIUM, (double)pos.getX() + (Math.random() - 0.5) * 5.0 + 0.5, (double)pos.getY() + (Math.random() - 0.5) * 8.0 + 0.5, (double)pos.getZ() + (Math.random() - 0.5) * 5.0 + 0.5, 0.0, 0.0, 0.0);
        }
        worldIn.addParticle((ParticleOptions)ParticleTypes.MYCELIUM, (double)pos.getX() + (Math.random() - 0.5) * 0.4 + 0.5, (double)pos.getY() + (Math.random() - 0.5) * 0.3 + 0.3, (double)pos.getZ() + (Math.random() - 0.5) * 0.4 + 0.5, 0.0, 0.0, 0.0);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    protected boolean mayPlaceOn(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        return state.isFaceSturdy(world, pos, Direction.UP);
    }

    public boolean isValidBonemealTarget(LevelReader reader, BlockPos pos, BlockState state) {
        for (Direction dir : MiscUtil.HORIZONTALS) {
            if (!this.canSpread((BlockGetter)reader, pos.relative(dir))) continue;
            return true;
        }
        return false;
    }

    public boolean isBonemealSuccess(@NotNull Level world, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        return true;
    }

    public void performBonemeal(@NotNull ServerLevel world, @NotNull RandomSource rand, @NotNull BlockPos pos, @NotNull BlockState state) {
        ArrayList list = Lists.newArrayList((Object[])MiscUtil.HORIZONTALS);
        Collections.shuffle(list);
        for (Direction dir : list) {
            BlockPos offPos = pos.relative(dir);
            if (!this.canSpread((BlockGetter)world, offPos)) continue;
            world.setBlock(offPos, state, 3);
            return;
        }
    }

    private boolean canSpread(BlockGetter world, BlockPos pos) {
        BlockPos below = pos.below();
        return world.getBlockState(pos).isAir() && this.mayPlaceOn(world.getBlockState(below), world, below);
    }
}

