/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.module;

import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.violetmoon.zeta.client.event.load.ZAddBlockColorHandlers;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="building")
public class MorePottedPlantsModule
extends ZetaModule {
    public static List<FlowerPotBlock> pottedPlants = new ArrayList<FlowerPotBlock>();
    private static final Map<Block, Block> tintedBlocks = new HashMap<Block, Block>();
    private static final Map<Block, Block> blockMapForDatagen = new HashMap<Block, Block>();
    @Hint(key="pottable_stuff")
    List<Block> pottableBlocks = Lists.newArrayList();

    @LoadEvent
    public final void register(ZRegister event) {
        this.add(event, Blocks.BEETROOTS, "beetroot");
        this.add(event, Blocks.SWEET_BERRY_BUSH, "berries");
        this.add(event, Blocks.CARROTS, "carrot");
        this.add(event, Blocks.CHORUS_FLOWER, "chorus");
        this.add(event, Blocks.COCOA, "cocoa_bean");
        FlowerPotBlock grass = this.add(event, Blocks.SHORT_GRASS, "short_grass");
        this.add(event, Blocks.PEONY, "peony");
        FlowerPotBlock largeFern = this.add(event, Blocks.LARGE_FERN, "large_fern");
        this.add(event, Blocks.LILAC, "lilac");
        this.add(event, Blocks.MELON_STEM, "melon");
        this.add(event, Blocks.NETHER_SPROUTS, "nether_sprouts");
        this.add(event, Blocks.NETHER_WART, "nether_wart");
        this.add(event, Blocks.POTATOES, "potato");
        this.add(event, Blocks.PUMPKIN_STEM, "pumpkin");
        this.add(event, Blocks.ROSE_BUSH, "rose");
        event.getVariantRegistry().addFlowerPot(Blocks.SEA_PICKLE, "sea_pickle", p -> p.lightLevel(b -> 3));
        FlowerPotBlock sugarCane = this.add(event, Blocks.SUGAR_CANE, "sugar_cane");
        this.add(event, Blocks.SUNFLOWER, "sunflower");
        FlowerPotBlock tallGrass = this.add(event, Blocks.TALL_GRASS, "tall_grass");
        this.add(event, Blocks.TWISTING_VINES, "twisting_vines");
        FlowerPotBlock vine = this.add(event, Blocks.VINE, "vine");
        this.add(event, Blocks.WEEPING_VINES, "weeping_vines");
        this.add(event, Blocks.WHEAT, "wheat");
        event.getVariantRegistry().addFlowerPot(Blocks.CAVE_VINES, "cave_vines", p -> p.lightLevel(b -> 14));
        this.add(event, Blocks.PITCHER_PLANT, "pitcher_plant");
        tintedBlocks.put((Block)grass, Blocks.SHORT_GRASS);
        tintedBlocks.put((Block)largeFern, Blocks.LARGE_FERN);
        tintedBlocks.put((Block)sugarCane, Blocks.SUGAR_CANE);
        tintedBlocks.put((Block)tallGrass, Blocks.TALL_GRASS);
        tintedBlocks.put((Block)vine, Blocks.VINE);
    }

    public static ItemLike getItemLikeFromBlock(Block block) {
        return blockMapForDatagen.get(block).asItem();
    }

    private FlowerPotBlock add(ZRegister event, Block block, String name) {
        this.pottableBlocks.add(block);
        FlowerPotBlock pot = event.getVariantRegistry().addFlowerPot(block, name, (Function)Functions.identity());
        pottedPlants.add(pot);
        blockMapForDatagen.put((Block)pot, block);
        return pot;
    }

    @ZetaLoadModule(clientReplacement=true)
    public static final class Client
    extends MorePottedPlantsModule {
        @LoadEvent
        public void registerColors(ZAddBlockColorHandlers event) {
            for (Block b : tintedBlocks.keySet()) {
                BlockState tState = tintedBlocks.get(b).defaultBlockState();
                BlockColors blockColors = event.getBlockColors();
                BlockColor color = (state, worldIn, pos, tintIndex) -> blockColors.getColor(tState, worldIn, pos, tintIndex);
                event.register(color, new Block[]{b});
            }
        }
    }
}

