/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.block;

import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnchantingTableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.violetmoon.quark.addons.oddities.block.be.MatrixEnchantingTableBlockEntity;
import org.violetmoon.quark.addons.oddities.module.MatrixEnchantingModule;
import org.violetmoon.quark.api.IEnchantmentInfluencer;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.zeta.block.IZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.BooleanSuppliers;

public class MatrixEnchantingTableBlock
extends EnchantingTableBlock
implements IZetaBlock {
    private final ZetaModule module;
    private BooleanSupplier enabledSupplier = BooleanSuppliers.TRUE;

    public MatrixEnchantingTableBlock(ZetaModule module) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ENCHANTING_TABLE));
        this.module = module;
        module.zeta().registry.registerBlock((Block)this, "matrix_enchanter", true);
        if (!MatrixEnchantingModule.automaticallyConvert) {
            this.setCreativeTab(CreativeModeTabs.FUNCTIONAL_BLOCKS, (ItemLike)Blocks.ENCHANTING_TABLE, false);
        }
    }

    @NotNull
    public MutableComponent getName() {
        return Blocks.ENCHANTING_TABLE.getName();
    }

    public MatrixEnchantingTableBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    @Nullable
    public ZetaModule getModule() {
        return this.module;
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new MatrixEnchantingTableBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level world, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return MatrixEnchantingTableBlock.createTickerHelper(type, MatrixEnchantingModule.blockEntityType, MatrixEnchantingTableBlockEntity::tick);
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (!(level.getBlockEntity(pos) instanceof MatrixEnchantingTableBlockEntity)) {
            level.setBlockEntity(this.newBlockEntity(pos, state));
        }
        if (Quark.ZETA.modules.isEnabled(MatrixEnchantingModule.class)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.openMenu((MenuProvider)((MatrixEnchantingTableBlockEntity)level.getBlockEntity(pos)), pos);
            }
        } else {
            level.setBlockAndUpdate(pos, Blocks.ENCHANTING_TABLE.defaultBlockState());
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void animateTick(@NotNull BlockState stateIn, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        boolean enabled = Quark.ZETA.modules.isEnabled(MatrixEnchantingModule.class);
        boolean showInfluences = enabled && MatrixEnchantingModule.allowInfluencing;
        boolean allowUnderwater = enabled && MatrixEnchantingModule.allowUnderwaterEnchanting;
        boolean allowShort = enabled && MatrixEnchantingModule.allowShortBlockEnchanting;
        for (int i = -2; i <= 2; ++i) {
            block1: for (int j = -2; j <= 2; ++j) {
                if (i > -2 && i < 2 && j == -1) {
                    j = 2;
                }
                if (rand.nextInt(16) != 0) continue;
                for (int k = 0; k <= 1; ++k) {
                    IEnchantmentInfluencer influencer;
                    BlockPos blockpos = pos.offset(i, k, j);
                    BlockState state = worldIn.getBlockState(blockpos);
                    BlockPos test = pos.offset(i / 2, 0, j / 2);
                    if (!worldIn.isEmptyBlock(test) && (!allowUnderwater || worldIn.getBlockState(test).getBlock() != Blocks.WATER) && (!allowShort || !MatrixEnchantingTableBlockEntity.isShortBlock(worldIn, test))) continue block1;
                    if (showInfluences && (influencer = MatrixEnchantingTableBlockEntity.getInfluencerFromBlock(state, worldIn, blockpos)) != null) {
                        int comp = influencer.getEnchantmentInfluenceColor((BlockGetter)worldIn, blockpos, state);
                        ParticleOptions extra = influencer.getExtraParticleOptions((BlockGetter)worldIn, blockpos, state);
                        double chance = influencer.getExtraParticleChance((BlockGetter)worldIn, blockpos, state);
                        int steps = 20;
                        double dx = (double)(pos.getX() - blockpos.getX()) / (double)steps;
                        double dy = (double)(pos.getY() - blockpos.getY()) / (double)steps;
                        double dz = (double)(pos.getZ() - blockpos.getZ()) / (double)steps;
                        for (int p = 0; p < steps; ++p) {
                            boolean doExtra;
                            boolean doDust = rand.nextDouble() < 0.5;
                            boolean bl = doExtra = extra != null && rand.nextDouble() < chance;
                            if (!doDust && !doExtra) continue;
                            double px = (double)blockpos.getX() + 0.5 + dx * (double)p + rand.nextDouble() * 0.2 - 0.1;
                            double py = (double)blockpos.getY() + 0.5 + dy * (double)p + Math.sin((double)p / (double)steps * Math.PI) * 0.5 + rand.nextDouble() * 0.2 - 0.1;
                            double pz = (double)blockpos.getZ() + 0.5 + dz * (double)p + rand.nextDouble() * 0.2 - 0.1;
                            if (doDust) {
                                worldIn.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f((float)(comp >> 16) / 255.0f, (float)(comp >> 8) / 255.0f, (float)comp / 255.0f), 1.0f), px, py, pz, 0.0, 0.0, 0.0);
                            }
                            if (!doExtra) continue;
                            worldIn.addParticle(extra, px, py, pz, 0.0, 0.0, 0.0);
                        }
                    }
                    if (!(state.getEnchantPowerBonus((LevelReader)worldIn, blockpos) > 0.0f)) continue;
                    worldIn.addParticle((ParticleOptions)ParticleTypes.ENCHANT, (double)pos.getX() + 0.5, (double)pos.getY() + 2.0, (double)pos.getZ() + 0.5, (double)((float)i + rand.nextFloat()) - 0.5, (double)((float)k - rand.nextFloat()) - 1.0, (double)((float)j + rand.nextFloat()) - 0.5);
                }
            }
        }
    }

    public void setPlacedBy(@NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull LivingEntity placer, @NotNull ItemStack stack) {
        BlockEntity tileentity;
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        if (stack.get(DataComponents.CUSTOM_NAME) != null && (tileentity = worldIn.getBlockEntity(pos)) instanceof MatrixEnchantingTableBlockEntity) {
            MatrixEnchantingTableBlockEntity matrixEnchanter = (MatrixEnchantingTableBlockEntity)tileentity;
            matrixEnchanter.setCustomName(stack.getHoverName());
        }
    }

    public void onRemove(@NotNull BlockState state, Level worldIn, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        BlockEntity tileentity = worldIn.getBlockEntity(pos);
        if (tileentity instanceof MatrixEnchantingTableBlockEntity) {
            MatrixEnchantingTableBlockEntity enchanter = (MatrixEnchantingTableBlockEntity)tileentity;
            enchanter.dropItem(0);
            enchanter.dropItem(1);
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }
}

