/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.content.automation.module.PistonsMoveTileEntitiesModule;
import org.violetmoon.quark.content.building.module.RopeModule;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.item.ZetaBlockItem;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.IZetaBlockItemProvider;
import org.violetmoon.zeta.registry.RenderLayerRegistry;

public class RopeBlock
extends ZetaBlock
implements IZetaBlockItemProvider,
SimpleWaterloggedBlock {
    private static final VoxelShape SHAPE = RopeBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public RopeBlock(String regname, @Nullable ZetaModule module, BlockBehaviour.Properties properties) {
        super(regname, module, properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        if (module == null) {
            return;
        }
        module.zeta().renderLayerRegistry.put((Block)this, RenderLayerRegistry.Layer.CUTOUT);
        this.setCreativeTab(CreativeModeTabs.FUNCTIONAL_BLOCKS, (ItemLike)Blocks.CHAIN, true);
    }

    public BlockItem provideItemBlock(Block block, Item.Properties properties) {
        return new ZetaBlockItem(this, block, properties){

            public boolean doesSneakBypassUseZeta(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
                return world.getBlockState(pos).getBlock() instanceof RopeBlock;
            }
        };
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shapes.empty();
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    public boolean propagatesSkylightDown(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, pos, facingPos);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (this.pullUp(level, pos)) {
            if (!player.getAbilities().instabuild && !player.addItem(new ItemStack((ItemLike)this))) {
                player.drop(new ItemStack((ItemLike)this), false);
            }
            level.playSound(null, pos, this.soundType.getBreakSound(), SoundSource.BLOCKS, 0.5f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, @NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (hand == InteractionHand.MAIN_HAND) {
            if (stack.getItem() == this.asItem() && !player.isDiscrete()) {
                if (this.pullDown(worldIn, pos)) {
                    if (!player.getAbilities().instabuild) {
                        stack.shrink(1);
                    }
                    worldIn.playSound(null, pos, this.soundType.getPlaceSound(), SoundSource.BLOCKS, 0.5f, 1.0f);
                    return ItemInteractionResult.sidedSuccess((boolean)worldIn.isClientSide);
                }
            } else {
                if (FluidUtil.getFluidHandler((ItemStack)stack).isPresent()) {
                    FluidActionResult interact = FluidUtil.tryPickUpFluid((ItemStack)stack, (Player)player, (Level)worldIn, (BlockPos)this.getBottomPos(worldIn, pos), (Direction)Direction.UP);
                    if (interact.success) {
                        stack.shrink(1);
                        if (!player.addItem(interact.result)) {
                            player.drop(interact.result, false);
                        }
                    }
                    return interact.success ? ItemInteractionResult.sidedSuccess((boolean)worldIn.isClientSide) : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
                if (stack.getItem() == Items.GLASS_BOTTLE) {
                    BlockPos bottomPos = this.getBottomPos(worldIn, pos);
                    BlockState stateAt = worldIn.getBlockState(bottomPos);
                    if (stateAt.getFluidState().is((Fluid)Fluids.WATER)) {
                        Vec3 playerPos = player.position();
                        worldIn.playSound(player, playerPos.x, playerPos.y, playerPos.z, SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
                        stack.shrink(1);
                        ItemStack bottleStack = PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER);
                        player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                        if (stack.isEmpty()) {
                            player.setItemInHand(hand, bottleStack);
                        } else if (!player.addItem(bottleStack)) {
                            player.drop(bottleStack, false);
                        }
                        return ItemInteractionResult.sidedSuccess((boolean)worldIn.isClientSide);
                    }
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
                if (this.pullUp(worldIn, pos)) {
                    if (!player.getAbilities().instabuild && !player.addItem(new ItemStack((ItemLike)this))) {
                        player.drop(new ItemStack((ItemLike)this), false);
                    }
                    worldIn.playSound(null, pos, this.soundType.getBreakSound(), SoundSource.BLOCKS, 0.5f, 1.0f);
                    return ItemInteractionResult.sidedSuccess((boolean)worldIn.isClientSide);
                }
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public boolean pullUp(Level world, BlockPos pos) {
        BlockState state;
        BlockPos basePos = pos;
        while ((state = world.getBlockState(pos = pos.below())).getBlock() == this) {
        }
        BlockPos ropePos = pos.above();
        if (ropePos.equals((Object)basePos)) {
            return false;
        }
        world.setBlockAndUpdate(ropePos, world.getBlockState(ropePos).getFluidState().createLegacyBlock());
        this.moveBlock(world, pos, ropePos);
        return true;
    }

    public boolean pullDown(Level world, BlockPos pos) {
        BlockState state;
        boolean endRope = false;
        boolean wasAirAtEnd = false;
        while (true) {
            if (!world.isInWorldBounds(pos = pos.below())) {
                return false;
            }
            state = world.getBlockState(pos);
            Block block = state.getBlock();
            if (block == this) continue;
            if (endRope) break;
            endRope = true;
            wasAirAtEnd = world.isEmptyBlock(pos) || world.getBlockState(pos).getBlock() instanceof LiquidBlock;
        }
        boolean can = wasAirAtEnd || world.isEmptyBlock(pos) || state.canBeReplaced();
        if (can) {
            BlockPos ropePos = pos.above();
            this.moveBlock(world, ropePos, pos);
            BlockState ropePosState = world.getBlockState(ropePos);
            if (world.isEmptyBlock(ropePos) || ropePosState.canBeReplaced()) {
                world.setBlockAndUpdate(ropePos, (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ropePosState.getFluidState().getType() == Fluids.WATER)));
                return true;
            }
        }
        return false;
    }

    private BlockPos getBottomPos(Level worldIn, BlockPos pos) {
        RopeBlock block = this;
        while (block == this) {
            pos = pos.below();
            BlockState state = worldIn.getBlockState(pos);
            block = state.getBlock();
        }
        return pos;
    }

    private boolean isIllegalBlock(Block block) {
        return block == Blocks.OBSIDIAN || block == Blocks.CRYING_OBSIDIAN || block == Blocks.RESPAWN_ANCHOR;
    }

    private void moveBlock(Level world, BlockPos srcPos, BlockPos dstPos) {
        BlockEntity target;
        BlockState state = world.getBlockState(srcPos);
        Block block = state.getBlock();
        if (state.getDestroySpeed((BlockGetter)world, srcPos) == -1.0f || !state.canSurvive((LevelReader)world, dstPos) || state.isAir() || state.getBlock() instanceof LiquidBlock || state.getPistonPushReaction() != PushReaction.NORMAL || this.isIllegalBlock(block)) {
            return;
        }
        BlockEntity tile = world.getBlockEntity(srcPos);
        if (tile != null) {
            if (RopeModule.forceEnableMoveTileEntities ? PistonsMoveTileEntitiesModule.shouldMoveTE(state) : PistonsMoveTileEntitiesModule.shouldMoveTE(true, state)) {
                return;
            }
            tile.setRemoved();
        }
        FluidState fluidState = world.getFluidState(srcPos);
        world.setBlockAndUpdate(srcPos, fluidState.createLegacyBlock());
        BlockState nextState = Block.updateFromNeighbourShapes((BlockState)state, (LevelAccessor)world, (BlockPos)dstPos);
        if (nextState.getProperties().contains(BlockStateProperties.WATERLOGGED)) {
            nextState = (BlockState)nextState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(dstPos).getType() == Fluids.WATER));
        }
        world.setBlockAndUpdate(dstPos, nextState);
        if (tile != null && (target = BlockEntity.loadStatic((BlockPos)dstPos, (BlockState)state, (CompoundTag)tile.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess()), (HolderLookup.Provider)world.registryAccess())) != null) {
            world.setBlockEntity(target);
            target.setBlockState(state);
            target.setChanged();
        }
        world.updateNeighborsAt(dstPos, state.getBlock());
        for (Entity entity : world.getEntities(null, new AABB(srcPos.above()))) {
            entity.teleportRelative(0.0, (double)(dstPos.getY() - srcPos.getY()), 0.0);
        }
    }

    public boolean canSurvive(@NotNull BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos upPos = pos.above();
        BlockState upState = worldIn.getBlockState(upPos);
        return upState.getBlock() == this || upState.isFaceSturdy((BlockGetter)worldIn, upPos, Direction.DOWN);
    }

    public void neighborChanged(BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        if (!state.canSurvive((LevelReader)worldIn, pos)) {
            worldIn.levelEvent(2001, pos, Block.getId((BlockState)worldIn.getBlockState(pos)));
            RopeBlock.dropResources((BlockState)state, (Level)worldIn, (BlockPos)pos);
            worldIn.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
    }

    public boolean isLadderZeta(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    public int getFlammabilityZeta(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 30;
    }

    public int getFireSpreadSpeedZeta(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }
}

