/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.block;

import it.unimi.dsi.fastutil.doubles.Double2ObjectArrayMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.api.ICrawlSpaceBlock;
import org.violetmoon.zeta.block.SimpleFluidloggedBlock;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.RenderLayerRegistry;

public class GrateBlock
extends ZetaBlock
implements SimpleFluidloggedBlock,
ICrawlSpaceBlock {
    private static final VoxelShape TRUE_SHAPE = GrateBlock.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Double2ObjectArrayMap<VoxelShape> WALK_BLOCK_CACHE = new Double2ObjectArrayMap();
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty LAVALOGGED = BooleanProperty.create((String)"lavalogged");

    public GrateBlock(@Nullable ZetaModule module) {
        super("grate", module, BlockBehaviour.Properties.of().strength(5.0f, 10.0f).sound(SoundType.METAL).isValidSpawn((what, huh, idk, hoh) -> false).lightLevel(state -> (Boolean)state.getValue((Property)LAVALOGGED) != false ? 15 : 0).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)LAVALOGGED, (Comparable)Boolean.valueOf(false)));
        if (module == null) {
            return;
        }
        module.zeta().renderLayerRegistry.put((Block)this, RenderLayerRegistry.Layer.CUTOUT);
        this.setCreativeTab(CreativeModeTabs.FUNCTIONAL_BLOCKS, (ItemLike)Blocks.CHAIN, false);
    }

    private static VoxelShape createNewBox(double stepHeight) {
        return GrateBlock.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)(17.0 + 16.0 * stepHeight), (double)16.0);
    }

    public boolean hasDynamicShape() {
        return true;
    }

    @Override
    public boolean canCrawl(Level level, BlockState state, BlockPos pos, Direction direction) {
        return true;
    }

    @Override
    public double crawlHeight(Level level, BlockState state, BlockPos pos, Direction direction) {
        return 0.0;
    }

    @Override
    public boolean isLog(ServerPlayer sp, BlockState state, BlockPos pos, Direction direction) {
        return false;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return TRUE_SHAPE;
    }

    private static VoxelShape getCachedShape(double stepHeight) {
        return (VoxelShape)WALK_BLOCK_CACHE.computeIfAbsent(stepHeight, GrateBlock::createNewBox);
    }

    public boolean collisionExtendsVerticallyZeta(BlockState state, BlockGetter level, BlockPos pos, Entity collidingEntity) {
        Animal animal;
        if (!(!(collidingEntity instanceof Animal) && !(collidingEntity instanceof WaterAnimal) || collidingEntity instanceof Animal && (animal = (Animal)collidingEntity).getLeashHolder() != null)) {
            WaterAnimal waterAnimal;
            return !(collidingEntity instanceof WaterAnimal) || (waterAnimal = (WaterAnimal)collidingEntity).getLeashHolder() == null;
        }
        return false;
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Entity entity;
        Entity entity2 = entity = context instanceof EntityCollisionContext ? ((EntityCollisionContext)context).getEntity() : null;
        if (entity != null) {
            LivingEntity livingEntity;
            AttributeInstance stepHeight;
            WaterAnimal waterAnimal;
            Animal animal;
            if (entity instanceof ItemEntity || entity instanceof ExperienceOrb) {
                return Shapes.empty();
            }
            boolean preventedType = entity instanceof Animal || entity instanceof WaterAnimal;
            boolean leashed = entity instanceof Animal && (animal = (Animal)entity).getLeashHolder() != null || entity instanceof WaterAnimal && (waterAnimal = (WaterAnimal)entity).getLeashHolder() != null;
            boolean onGrate = world.getBlockState(entity.blockPosition().offset(0, -1, 0)).getBlock() instanceof GrateBlock;
            if (preventedType && !leashed && !onGrate && (stepHeight = (livingEntity = (LivingEntity)entity).getAttribute(Attributes.STEP_HEIGHT)) != null) {
                return GrateBlock.getCachedShape(stepHeight.getValue());
            }
            return TRUE_SHAPE;
        }
        return TRUE_SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Fluid fluidAt = context.getLevel().getFluidState(context.getClickedPos()).getType();
        BlockState state = this.defaultBlockState();
        return this.acceptsFluid(fluidAt) ? this.withFluid(state, fluidAt) : state;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public boolean propagatesSkylightDown(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        return this.fluidContained(state) == Fluids.EMPTY;
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block updatedBlock, @NotNull BlockPos neighbor, boolean isMoving) {
        BlockState neighborState;
        super.neighborChanged(state, level, pos, updatedBlock, neighbor, isMoving);
        if (!pos.below().equals((Object)neighbor) && (neighborState = level.getBlockState(neighbor)).getFluidState().is(FluidTags.WATER) && this.fluidContained(state).isSame((Fluid)Fluids.LAVA)) {
            level.destroyBlock(pos, true);
            level.setBlock(pos, EventHooks.fireFluidPlaceBlockEvent((LevelAccessor)level, (BlockPos)pos, (BlockPos)neighbor, (BlockState)Blocks.OBSIDIAN.defaultBlockState()), 3);
            level.levelEvent(1501, pos, 0);
        }
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos facingPos) {
        Fluid fluid;
        if (((Boolean)state.getValue((Property)LAVALOGGED)).booleanValue() && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            state = this.withFluid(state, (Fluid)Fluids.WATER);
        }
        if ((fluid = this.fluidContained(state)) != Fluids.EMPTY) {
            level.scheduleTick(pos, fluid, fluid.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, pos, facingPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, LAVALOGGED});
    }

    @NotNull
    public FluidState getFluidState(@NotNull BlockState state) {
        FluidState contained = this.fluidContained(state).defaultFluidState();
        if (contained.hasProperty((Property)BlockStateProperties.FALLING)) {
            contained = (FluidState)contained.setValue((Property)BlockStateProperties.FALLING, (Comparable)Boolean.valueOf(false));
        }
        return contained;
    }

    public boolean acceptsFluid(@NotNull Fluid fluid) {
        return fluid == Fluids.WATER || fluid == Fluids.LAVA;
    }

    @NotNull
    public BlockState withFluid(@NotNull BlockState state, @NotNull Fluid fluid) {
        return (BlockState)((BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid == Fluids.WATER))).setValue((Property)LAVALOGGED, (Comparable)Boolean.valueOf(fluid == Fluids.LAVA));
    }

    @NotNull
    public Fluid fluidContained(@NotNull BlockState state) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.WATER;
        }
        if (((Boolean)state.getValue((Property)LAVALOGGED)).booleanValue()) {
            return Fluids.LAVA;
        }
        return Fluids.EMPTY;
    }
}

